/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ColorEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.ColorRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Color;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroColorProperty
extends IntrospectedProperty<ColorDescriptor> {
    private ColorRenderer myColorRenderer = null;
    private ColorEditor myColorEditor = null;
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroColorProperty_";

    public IntroColorProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
    }

    @Override
    @NotNull
    public PropertyRenderer<ColorDescriptor> getRenderer() {
        if (this.myColorRenderer == null) {
            this.myColorRenderer = new ColorRenderer();
        }
        ColorRenderer colorRenderer = this.myColorRenderer;
        if (colorRenderer == null) {
            IntroColorProperty.$$$reportNull$$$0(0);
        }
        return colorRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<ColorDescriptor> getEditor() {
        if (this.myColorEditor == null) {
            this.myColorEditor = new ColorEditor(this.getName());
        }
        return this.myColorEditor;
    }

    @Override
    public void write(@NotNull ColorDescriptor value, XmlWriter writer) {
        if (value == null) {
            IntroColorProperty.$$$reportNull$$$0(1);
        }
        writer.writeColorDescriptor(value);
    }

    @Override
    public ColorDescriptor getValue(RadComponent component) {
        ColorDescriptor colorDescriptor = (ColorDescriptor)component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
        if (colorDescriptor == null) {
            return new ColorDescriptor((Color)this.invokeGetter(component));
        }
        return colorDescriptor;
    }

    @Override
    protected void setValueImpl(RadComponent component, ColorDescriptor value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        if (value != null && value.isColorSet()) {
            this.invokeSetter(component, value.getResolvedColor());
        }
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        super.resetValue(component);
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/IntroColorProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/IntroColorProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

