/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ranker.local;

import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsUtil;
import com.intellij.completion.ml.ranker.local.ZipModelMetadataReader;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeaturesInfo;
import com.intellij.internal.ml.ModelMetadata;
import com.intellij.internal.ml.completion.CompletionRankingModelBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.ToDoubleFunction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REGISTRY_PATH_KEY", "", "executor", "Ljava/util/concurrent/ExecutorService;", "localModel", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$CompletionLocalRankingModel;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "languageId", "initModelFromPathToZipSynchronously", "", "isPathToTheModelChanged", "", "isPathToTheModelSet", "scheduleInitModel", "Ljava/util/concurrent/Future;", "CompletionLocalRankingModel", "Tree", "TreesModel", "intellij.completionMlRanking"})
public final class MLCompletionLocalModelsUtil {
    private static final String REGISTRY_PATH_KEY = "completion.ml.path.to.zip.model";
    private static final Logger LOG;
    private static final ExecutorService executor;
    private static volatile CompletionLocalRankingModel localModel;
    public static final MLCompletionLocalModelsUtil INSTANCE;

    @Nullable
    public final DecisionFunction getModel(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        if (!this.isPathToTheModelSet()) {
            localModel = null;
            return null;
        }
        if (this.isPathToTheModelChanged()) {
            this.scheduleInitModel();
            return null;
        }
        CompletionLocalRankingModel completionLocalRankingModel = localModel;
        if (completionLocalRankingModel == null) {
            return null;
        }
        CompletionLocalRankingModel resLocalModel = completionLocalRankingModel;
        List<String> list = resLocalModel.getSupportedLanguages();
        String string = languageId;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return list.contains(string2) ? (DecisionFunction)resLocalModel : null;
    }

    private final Future<?> scheduleInitModel() {
        Future<?> future = executor.submit(scheduleInitModel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit { initMo\u2026athToZipSynchronously() }");
        return future;
    }

    private final boolean isPathToTheModelSet() {
        RegistryValue registryValue = Registry.get((String)REGISTRY_PATH_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(REGISTRY_PATH_KEY)");
        return registryValue.isChangedFromDefault();
    }

    private final boolean isPathToTheModelChanged() {
        CompletionLocalRankingModel completionLocalRankingModel = localModel;
        return Intrinsics.areEqual((Object)Registry.stringValue((String)REGISTRY_PATH_KEY), (Object)(completionLocalRankingModel != null ? completionLocalRankingModel.getPath() : null)) ^ true;
    }

    private final void initModelFromPathToZipSynchronously() {
        localModel = null;
        long startTime = System.currentTimeMillis();
        String string = Registry.stringValue((String)REGISTRY_PATH_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Registry.stringValue(REGISTRY_PATH_KEY)");
        String pathToZip = string;
        ZipModelMetadataReader resourcesReader = new ZipModelMetadataReader(pathToZip);
        localModel = resourcesReader.readModel();
        long endTime = System.currentTimeMillis();
        LOG.info("ML Completion local model initialization took: " + (endTime - startTime) + " ms.");
    }

    private MLCompletionLocalModelsUtil() {
    }

    static {
        MLCompletionLocalModelsUtil mLCompletionLocalModelsUtil;
        INSTANCE = mLCompletionLocalModelsUtil = new MLCompletionLocalModelsUtil();
        Logger logger = Logger.getInstance(MLCompletionLocalModelsUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MLCom\u2026alModelsUtil::class.java)");
        LOG = logger;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"MLCompletionTxtModelsUtil pool executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026odelsUtil pool executor\")");
        executor = executorService;
    }

    public static final /* synthetic */ void access$initModelFromPathToZipSynchronously(MLCompletionLocalModelsUtil $this) {
        $this.initModelFromPathToZipSynchronously();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$Tree;", "", "thresholds", "", "", "values", "features", "", "left", "right", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getFeatures", "()Ljava/util/List;", "getLeft", "getRight", "getThresholds", "getValues", "predict", "featuresValues", "", "traverse", "node", "intellij.completionMlRanking"})
    private static final class Tree {
        @NotNull
        private final List<Double> thresholds;
        @NotNull
        private final List<Double> values;
        @NotNull
        private final List<Integer> features;
        @NotNull
        private final List<Integer> left;
        @NotNull
        private final List<Integer> right;

        private final double traverse(int node, double[] featuresValues) {
            double threshold;
            int featureId;
            double featureValue;
            boolean bl = node != -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return ((Number)this.left.get(node)).intValue() != -1 ? ((featureValue = featuresValues[featureId = ((Number)this.features.get(node)).intValue()]) <= (threshold = ((Number)this.thresholds.get(node)).doubleValue()) ? this.traverse(((Number)this.left.get(node)).intValue(), featuresValues) : this.traverse(((Number)this.right.get(node)).intValue(), featuresValues)) : ((Number)this.values.get(node)).doubleValue();
        }

        public final double predict(@NotNull double[] featuresValues) {
            Intrinsics.checkNotNullParameter((Object)featuresValues, (String)"featuresValues");
            return this.traverse(0, featuresValues);
        }

        @NotNull
        public final List<Double> getThresholds() {
            return this.thresholds;
        }

        @NotNull
        public final List<Double> getValues() {
            return this.values;
        }

        @NotNull
        public final List<Integer> getFeatures() {
            return this.features;
        }

        @NotNull
        public final List<Integer> getLeft() {
            return this.left;
        }

        @NotNull
        public final List<Integer> getRight() {
            return this.right;
        }

        public Tree(@NotNull List<Double> thresholds, @NotNull List<Double> values, @NotNull List<Integer> features2, @NotNull List<Integer> left, @NotNull List<Integer> right) {
            Intrinsics.checkNotNullParameter(thresholds, (String)"thresholds");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            this.thresholds = thresholds;
            this.values = values;
            this.features = features2;
            this.left = left;
            this.right = right;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\tJ\u0010\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$TreesModel;", "", "()V", "trees", "Ljava/util/ArrayList;", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$Tree;", "addTree", "", "thresholds", "", "", "values", "features", "", "left", "right", "predict", "featuresValues", "", "intellij.completionMlRanking"})
    public static final class TreesModel {
        private final ArrayList<Tree> trees = new ArrayList();

        public final void addTree(@NotNull List<Double> thresholds, @NotNull List<Double> values, @NotNull List<Integer> features2, @NotNull List<Integer> left, @NotNull List<Integer> right) {
            Intrinsics.checkNotNullParameter(thresholds, (String)"thresholds");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            this.trees.add(new Tree(thresholds, values, features2, left, right));
        }

        public final double predict(@Nullable double[] featuresValues) {
            if (featuresValues == null) {
                return 0.0;
            }
            double koef = 1.0 / (double)this.trees.size();
            double sum2 = this.trees.stream().mapToDouble((ToDoubleFunction)new ToDoubleFunction<Tree>(featuresValues){
                final /* synthetic */ double[] $featuresValues;

                public final double applyAsDouble(Tree it) {
                    return it.predict(this.$featuresValues);
                }
                {
                    this.$featuresValues = dArray;
                }
            }).sum();
            return sum2 * koef;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$CompletionLocalRankingModel;", "Lcom/intellij/internal/ml/completion/CompletionRankingModelBase;", "metadata", "Lcom/intellij/internal/ml/FeaturesInfo;", "path", "", "treesModel", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$TreesModel;", "languages", "", "(Lcom/intellij/internal/ml/FeaturesInfo;Ljava/lang/String;Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$TreesModel;Ljava/util/List;)V", "getLanguages", "()Ljava/util/List;", "getPath", "()Ljava/lang/String;", "getTreesModel", "()Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$TreesModel;", "getSupportedLanguages", "predict", "", "features", "", "intellij.completionMlRanking"})
    public static final class CompletionLocalRankingModel
    extends CompletionRankingModelBase {
        @NotNull
        private final String path;
        @NotNull
        private final TreesModel treesModel;
        @NotNull
        private final List<String> languages;

        public double predict(@Nullable double[] features2) {
            return this.treesModel.predict(features2);
        }

        @NotNull
        public final List<String> getSupportedLanguages() {
            return this.languages;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final TreesModel getTreesModel() {
            return this.treesModel;
        }

        @NotNull
        public final List<String> getLanguages() {
            return this.languages;
        }

        public CompletionLocalRankingModel(@NotNull FeaturesInfo metadata, @NotNull String path, @NotNull TreesModel treesModel, @NotNull List<String> languages) {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)treesModel, (String)"treesModel");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            super((ModelMetadata)metadata);
            this.path = path;
            this.treesModel = treesModel;
            this.languages = languages;
        }
    }
}

