/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.personalization.session.ElementSessionFactorsStorage;
import com.intellij.completion.ml.personalization.session.LookupSessionFactorsStorage;
import com.intellij.completion.ml.personalization.session.SessionFactorsUtils;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.openapi.util.registry.Registry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003)*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u0002H\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000b0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u0018\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0002J&\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0002J*\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J(\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils;", "", "()V", "SESSION_FACTOR_PREFIX", "", "elementFactors", "", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "lookupFactors", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "name", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "getName", "(Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;)Ljava/lang/String;", "calculateFactors", "", "S", "storage", "factors", "", "(Ljava/lang/Object;Ljava/lang/Iterable;)Ljava/util/Map;", "calculateLookupFactors", "lookupStorage", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "elementFactor", "extractor", "Lkotlin/Function1;", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "lookupFactor", "saveElementFactorsTo", "", "map", "", "Lcom/intellij/completion/ml/storage/LookupStorage;", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "shouldUseSessionFactors", "", "updateSessionFactors", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "items", "ElementFactor", "SessionFactor", "SessionLookupFactor", "intellij.completionMlRanking"})
public final class SessionFactorsUtils {
    private static final String SESSION_FACTOR_PREFIX = "session_";
    private static final List<SessionFactor.LookupBased> lookupFactors;
    private static final List<SessionFactor.LookupElementBased> elementFactors;
    public static final SessionFactorsUtils INSTANCE;

    public final boolean shouldUseSessionFactors() {
        return Registry.is((String)"completion.ml.enable.session.factors");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> updateSessionFactors(@NotNull MutableLookupStorage lookupStorage, @NotNull List<? extends LookupElement> items) {
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (!this.shouldUseSessionFactors()) {
            return MapsKt.emptyMap();
        }
        LookupSessionFactorsStorage sessionFactors = lookupStorage.getSessionFactors();
        sessionFactors.fireSortingPerforming(items.size());
        Map<String, Object> lookupFactors2 = this.calculateLookupFactors(sessionFactors);
        lookupStorage.getSessionFactors().updateLastUsedFactors(lookupFactors2);
        Iterable $this$forEachIndexed$iv = items;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LookupElement lookupElement = (LookupElement)item$iv;
            int i = n;
            boolean bl2 = false;
            ElementSessionFactorsStorage factorsStorage = lookupStorage.getItemStorage(LookupElementExtensionsKt.idString((LookupElement)item)).getSessionFactors();
            factorsStorage.computeSessionFactors(i, (Function1<? super ElementSessionFactorsStorage, ? extends Map<String, ? extends Object>>)((Function1)updateSessionFactors.1.1.INSTANCE));
        }
        return lookupFactors2;
    }

    public final void saveElementFactorsTo(@NotNull Map<String, Object> map, @NotNull LookupStorage lookupStorage, @NotNull LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        ElementSessionFactorsStorage factorsStorage = lookupStorage.getItemStorage(LookupElementExtensionsKt.idString(lookupElement)).getSessionFactors();
        map.putAll(factorsStorage.lastUsedElementFactors());
    }

    private final String getName(SessionFactor<?> $this$name) {
        return SESSION_FACTOR_PREFIX + $this$name.getSimpleName();
    }

    private final Map<String, Object> calculateLookupFactors(LookupSessionFactorsStorage lookupStorage) {
        return this.calculateFactors(lookupStorage, (Iterable)lookupFactors);
    }

    private final <S> Map<String, Object> calculateFactors(S storage, Iterable<? extends SessionFactor<S>> factors) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        for (SessionFactor<S> factor : factors) {
            String factorName = this.getName(factor);
            Map map = result;
            boolean bl2 = false;
            Map map2 = map;
            boolean bl3 = false;
            boolean bl4 = !map2.containsKey(factorName);
            bl2 = false;
            boolean bl5 = false;
            if (_Assertions.ENABLED && !bl4) {
                bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Object factorValue = factor.getValue(storage);
            if (factorValue == null) continue;
            result.put(factorName, factorValue);
        }
        return result;
    }

    private final SessionFactor.LookupBased lookupFactor(String name, Function1<? super LookupSessionFactorsStorage, ? extends Object> extractor) {
        return new SessionLookupFactor(name, extractor);
    }

    private final SessionFactor.LookupElementBased elementFactor(String name, Function1<? super ElementSessionFactorsStorage, ? extends Object> extractor) {
        return new ElementFactor(name, extractor);
    }

    private SessionFactorsUtils() {
    }

    static {
        SessionFactorsUtils sessionFactorsUtils;
        INSTANCE = sessionFactorsUtils = new SessionFactorsUtils();
        lookupFactors = CollectionsKt.listOf((Object[])new SessionFactor.LookupBased[]{sessionFactorsUtils.lookupFactor("visible_size", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.1.INSTANCE)), sessionFactorsUtils.lookupFactor("sorting_order", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.2.INSTANCE)), sessionFactorsUtils.lookupFactor("duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.3.INSTANCE)), sessionFactorsUtils.lookupFactor("query_number", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.4.INSTANCE)), sessionFactorsUtils.lookupFactor("unique_queries", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.5.INSTANCE)), sessionFactorsUtils.lookupFactor("current_query_frequency", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.6.INSTANCE)), sessionFactorsUtils.lookupFactor("current_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.7.INSTANCE)), sessionFactorsUtils.lookupFactor("average_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.8.INSTANCE)), sessionFactorsUtils.lookupFactor("min_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.9.INSTANCE)), sessionFactorsUtils.lookupFactor("max_query_duration", (Function1<? super LookupSessionFactorsStorage, ? extends Object>)((Function1)lookupFactors.10.INSTANCE))});
        elementFactors = CollectionsKt.listOf((Object[])new SessionFactor.LookupElementBased[]{sessionFactorsUtils.elementFactor("visible_position", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.1.INSTANCE)), sessionFactorsUtils.elementFactor("times_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.2.INSTANCE)), sessionFactorsUtils.elementFactor("total_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.3.INSTANCE)), sessionFactorsUtils.elementFactor("average_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.4.INSTANCE)), sessionFactorsUtils.elementFactor("max_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.5.INSTANCE)), sessionFactorsUtils.elementFactor("min_time_in_selection", (Function1<? super ElementSessionFactorsStorage, ? extends Object>)((Function1)elementFactors.6.INSTANCE))});
    }

    public static final /* synthetic */ Map access$calculateFactors(SessionFactorsUtils $this, Object storage, Iterable factors) {
        return $this.calculateFactors(storage, factors);
    }

    public static final /* synthetic */ List access$getElementFactors$p(SessionFactorsUtils $this) {
        SessionFactorsUtils sessionFactorsUtils = $this;
        return elementFactors;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionLookupFactor;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "simpleName", "", "valueExtractor", "Lkotlin/Function1;", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "intellij.completionMlRanking"})
    private static final class SessionLookupFactor
    implements SessionFactor.LookupBased {
        @NotNull
        private final String simpleName;
        private final Function1<LookupSessionFactorsStorage, Object> valueExtractor;

        @Override
        @Nullable
        public Object getValue(@NotNull LookupSessionFactorsStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.valueExtractor.invoke((Object)storage);
        }

        @Override
        @NotNull
        public String getSimpleName() {
            return this.simpleName;
        }

        public SessionLookupFactor(@NotNull String simpleName, @NotNull Function1<? super LookupSessionFactorsStorage, ? extends Object> valueExtractor) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter(valueExtractor, (String)"valueExtractor");
            this.simpleName = simpleName;
            this.valueExtractor = valueExtractor;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$ElementFactor;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "simpleName", "", "valueExtractor", "Lkotlin/Function1;", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "intellij.completionMlRanking"})
    private static final class ElementFactor
    implements SessionFactor.LookupElementBased {
        @NotNull
        private final String simpleName;
        private final Function1<ElementSessionFactorsStorage, Object> valueExtractor;

        @Override
        @Nullable
        public Object getValue(@NotNull ElementSessionFactorsStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.valueExtractor.invoke((Object)storage);
        }

        @Override
        @NotNull
        public String getSimpleName() {
            return this.simpleName;
        }

        public ElementFactor(@NotNull String simpleName, @NotNull Function1<? super ElementSessionFactorsStorage, ? extends Object> valueExtractor) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter(valueExtractor, (String)"valueExtractor");
            this.simpleName = simpleName;
            this.valueExtractor = valueExtractor;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\n\u000bJ\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "T", "", "simpleName", "", "getSimpleName", "()Ljava/lang/String;", "getValue", "storage", "(Ljava/lang/Object;)Ljava/lang/Object;", "LookupBased", "LookupElementBased", "intellij.completionMlRanking"})
    private static interface SessionFactor<T> {
        @NotNull
        public String getSimpleName();

        @Nullable
        public Object getValue(T var1);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupBased;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "Lcom/intellij/completion/ml/personalization/session/LookupSessionFactorsStorage;", "intellij.completionMlRanking"})
        public static interface LookupBased
        extends SessionFactor<LookupSessionFactorsStorage> {
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor$LookupElementBased;", "Lcom/intellij/completion/ml/personalization/session/SessionFactorsUtils$SessionFactor;", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "intellij.completionMlRanking"})
        public static interface LookupElementBased
        extends SessionFactor<ElementSessionFactorsStorage> {
        }
    }
}

