/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.testFramework.LightVirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyShellCodeFragment
extends GroovyCodeFragment {
    private final Map<String, PsiVariable> myVariables = new HashMap<String, PsiVariable>();
    private final Map<String, GrTypeDefinition> myTypeDefinitions = new HashMap<String, GrTypeDefinition>();

    public GroovyShellCodeFragment(Project project, LightVirtualFile virtualFile) {
        super(project, (VirtualFile)virtualFile);
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyShellCodeFragment clone = (GroovyShellCodeFragment)super.clone();
        clone.myVariables.putAll(this.myVariables);
        clone.myTypeDefinitions.putAll(this.myTypeDefinitions);
        return clone;
    }

    public void addVariable(String name, GrExpression expr) {
        PsiType type2 = expr.getType();
        if (type2 instanceof GrClassReferenceType) {
            PsiClassType.ClassResolveResult resolveResult2 = ((GrClassReferenceType)type2).resolveGenerics();
            PsiClass psiClass = resolveResult2.getElement();
            PsiImmediateClassType psiImmediateClassType = type2 = psiClass == null ? null : new PsiImmediateClassType(psiClass, resolveResult2.getSubstitutor());
        }
        if (type2 != null) {
            this.myVariables.put(name, new GrLightVariable(this.getManager(), name, type2, (PsiElement)this));
        }
    }

    public void addVariable(String name, PsiType type2) {
        this.myVariables.put(name, new GrLightVariable(this.getManager(), name, type2, (PsiElement)this));
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(0);
        }
        if (state == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(1);
        }
        if (place == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(2);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processVariables(processor, state)) {
            return false;
        }
        return this.processTypeDefinitions(processor, state);
    }

    private boolean processVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        ElementClassHint classHint;
        if (processor == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(4);
        }
        if (!ResolveUtil.shouldProcessMethods(classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) && !ResolveUtil.shouldProcessProperties(classHint)) {
            return true;
        }
        NameHint nameHint2 = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint2 != null ? nameHint2.getName(state) : null;
        if (name != null) {
            PsiVariable var = this.myVariables.get(name);
            if (var != null && processor.execute((PsiElement)var, state)) {
                return false;
            }
        } else {
            for (PsiVariable var : this.myVariables.values()) {
                if (processor.execute((PsiElement)var, state)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processTypeDefinitions(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        ElementClassHint classHint;
        if (processor == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GroovyShellCodeFragment.$$$reportNull$$$0(6);
        }
        if (!ResolveUtil.shouldProcessClasses(classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        NameHint nameHint2 = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint2 != null ? nameHint2.getName(state) : null;
        if (name != null) {
            GrTypeDefinition definition = this.myTypeDefinitions.get(name);
            if (definition != null && processor.execute((PsiElement)definition, state)) {
                return false;
            }
        } else {
            for (GrTypeDefinition definition : this.myTypeDefinitions.values()) {
                if (processor.execute((PsiElement)definition, state)) continue;
                return false;
            }
        }
        return true;
    }

    public void addTypeDefinition(GrTypeDefinition typeDefinition) {
        this.myTypeDefinitions.put(typeDefinition.getName(), typeDefinition);
    }

    public void clearVariables() {
        this.myVariables.clear();
    }

    public void clearClasses() {
        this.myTypeDefinitions.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/shell/GroovyShellCodeFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processTypeDefinitions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

