/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyClassImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.CompilationPhaseHint;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public final class GrClassImplUtil {
    private static final Logger LOG = Logger.getInstance(GrClassImplUtil.class);
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = PsiMethod::isConstructor;

    private GrClassImplUtil() {
    }

    public static GrMethod @NotNull [] getCodeConstructors(@NotNull GrTypeDefinition definition) {
        if (definition == null) {
            GrClassImplUtil.$$$reportNull$$$0(0);
        }
        Object[] methods = definition.getCodeMethods();
        List result2 = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        GrMethod[] grMethodArray = result2.toArray(GrMethod.EMPTY_ARRAY);
        if (grMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(1);
        }
        return grMethodArray;
    }

    public static PsiMethod @NotNull [] getConstructors(@NotNull GrTypeDefinition definition) {
        if (definition == null) {
            GrClassImplUtil.$$$reportNull$$$0(2);
        }
        Object[] methods = definition.getMethods();
        List result2 = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        PsiMethod[] psiMethodArray = result2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiClass findInnerClassByName(GrTypeDefinition grType, String name, boolean checkBases) {
        if (!checkBases) {
            for (PsiClass inner : grType.getInnerClasses()) {
                if (!name.equals(inner.getName())) continue;
                return inner;
            }
            return null;
        }
        Map<String, CandidateInfo> innerClasses = CollectClassMembersUtil.getAllInnerClasses(grType, true);
        CandidateInfo info = innerClasses.get(name);
        return info == null ? null : (PsiClass)info.getElement();
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType) {
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(4);
        }
        return GrClassImplUtil.getSuperClass(grType, grType.getExtendsListTypes());
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType, PsiClassType @NotNull [] extendsListTypes) {
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(5);
        }
        if (extendsListTypes == null) {
            GrClassImplUtil.$$$reportNull$$$0(6);
        }
        if (extendsListTypes.length == 0) {
            return GrClassImplUtil.getBaseClass(grType);
        }
        PsiClass superClass = extendsListTypes[0].resolve();
        return superClass != null ? superClass : GrClassImplUtil.getBaseClass(grType);
    }

    @Nullable
    public static PsiClass getBaseClass(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Object", grType.getResolveScope());
    }

    public static PsiClassType @NotNull [] getSuperTypes(GrTypeDefinition grType, boolean includeSynthetic) {
        Object[] extendsList = grType.getExtendsListTypes(includeSynthetic);
        if (extendsList.length == 0) {
            extendsList = new PsiClassType[]{GrClassImplUtil.createBaseClassType(grType)};
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])ArrayUtil.mergeArrays((Object[])extendsList, (Object[])grType.getImplementsListTypes(includeSynthetic), (ArrayFactory)PsiClassType.ARRAY_FACTORY);
        if (psiClassTypeArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(7);
        }
        return psiClassTypeArray;
    }

    public static PsiClassType createBaseClassType(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return TypesUtil.createTypeByFQClassName("java.lang.Enum", grType);
        }
        return TypesUtil.getJavaLangObject(grType);
    }

    public static PsiMethod @NotNull [] getAllMethods(GrTypeDefinition grType) {
        PsiMethod[] psiMethodArray = (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)grType, () -> {
            ArrayList list = new ArrayList();
            GrClassImplUtil.getAllMethodsInner(grType, list, new HashSet());
            return CachedValueProvider.Result.create((Object)list.toArray(PsiMethod.EMPTY_ARRAY), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, grType});
        });
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(8);
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<PsiMethod> getAllMethods(Collection<? extends PsiClass> classes2) {
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
        HashSet visited = new HashSet();
        for (PsiClass psiClass : classes2) {
            GrClassImplUtil.getAllMethodsInner(psiClass, allMethods, visited);
        }
        ArrayList<PsiMethod> arrayList = allMethods;
        if (arrayList == null) {
            GrClassImplUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void getAllMethodsInner(PsiClass clazz, List<? super PsiMethod> allMethods, HashSet<? super PsiClass> visited) {
        PsiClass[] supers;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add((PsiClass)clazz);
        ContainerUtil.addAll(allMethods, (Object[])clazz.getMethods());
        for (PsiClass aSuper : supers = clazz.getSupers()) {
            GrClassImplUtil.getAllMethodsInner(aSuper, allMethods, visited);
        }
    }

    public static PsiClassType[] getReferenceListTypes(@Nullable GrReferenceList list) {
        if (list == null) {
            return PsiClassType.EMPTY_ARRAY;
        }
        return list.getReferencedTypes();
    }

    public static PsiClass @NotNull [] getInterfaces(GrTypeDefinition grType) {
        return GrClassImplUtil.getInterfaces(grType, true);
    }

    public static PsiClass @NotNull [] getInterfaces(GrTypeDefinition grType, boolean includeSynthetic) {
        PsiClassType[] implementsListTypes = grType.getImplementsListTypes(includeSynthetic);
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(implementsListTypes.length);
        for (PsiClassType type2 : implementsListTypes) {
            PsiClass psiClass = type2.resolve();
            if (psiClass == null) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    public static PsiClass @NotNull [] getSupers(GrTypeDefinition grType, boolean includeSynthetic) {
        PsiClassType[] superTypes = grType.getSuperTypes(includeSynthetic);
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (PsiClassType superType : superTypes) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            result2.add(superClass);
        }
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean processDeclarations(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        NameHint nameHint2;
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            GrClassImplUtil.$$$reportNull$$$0(13);
        }
        if (state == null) {
            GrClassImplUtil.$$$reportNull$$$0(14);
        }
        if (place == null) {
            GrClassImplUtil.$$$reportNull$$$0(15);
        }
        if (ResolveUtilKt.isAnnotationResolve(processor)) {
            return true;
        }
        if (processor.getHint(CompilationPhaseHint.HINT_KEY) != null) {
            return GroovyClassImplUtilKt.processPhase(grType, processor, state);
        }
        if (ResolveUtilKt.shouldProcessTypeParameters(processor)) {
            for (PsiTypeParameter typeParameter : grType.getTypeParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
                return false;
            }
        }
        String name = (nameHint2 = (NameHint)processor.getHint(NameHint.KEY)) == null ? null : nameHint2.getName(state);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        boolean processInstanceMethods = (ResolveUtil.shouldProcessMethods(classHint) || ResolveUtil.shouldProcessProperties(classHint)) && GrClassImplUtil.shouldProcessInstanceMembers(grType, lastParent);
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            PsiField[] fieldInfo;
            Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
            if (name != null) {
                PsiField field;
                fieldInfo = fieldsMap.get(name);
                if (fieldInfo != null ? !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, (CandidateInfo)fieldInfo) : grType.isTrait() && lastParent != null && (field = GrClassImplUtil.findFieldByName(grType, name, false, true)) != null && field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                    return false;
                }
            } else {
                for (CandidateInfo info : fieldsMap.values()) {
                    if (GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, info)) continue;
                    return false;
                }
                if (grType.isTrait() && lastParent != null) {
                    void var15_23;
                    fieldInfo = CollectClassMembersUtil.getFields(grType, true);
                    int info = fieldInfo.length;
                    boolean bl = false;
                    while (var15_23 < info) {
                        PsiField field = fieldInfo[var15_23];
                        if (field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                            return false;
                        }
                        ++var15_23;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            boolean isPlaceGroovy;
            Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
            boolean bl = isPlaceGroovy = place.getLanguage() == GroovyLanguage.INSTANCE;
            if (name == null) {
                for (List list : methodsMap.values()) {
                    for (CandidateInfo info : list) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            } else {
                List<CandidateInfo> byName = methodsMap.get(name);
                if (byName != null) {
                    for (CandidateInfo info : byName) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessClasses(classHint)) {
            Map<String, CandidateInfo> classes2 = CollectClassMembersUtil.getAllInnerClasses(grType, true);
            if (name == null) {
                for (CandidateInfo info : classes2.values()) {
                    if (processor.execute(info.getElement(), state)) continue;
                    return false;
                }
            } else {
                CandidateInfo info = classes2.get(name);
                if (info != null && !processor.execute(info.getElement(), state)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processField(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, CandidateInfo fieldInfo) {
        PsiField field;
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            GrClassImplUtil.$$$reportNull$$$0(17);
        }
        if (state == null) {
            GrClassImplUtil.$$$reportNull$$$0(18);
        }
        if (place == null) {
            GrClassImplUtil.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            GrClassImplUtil.$$$reportNull$$$0(20);
        }
        if (factory == null) {
            GrClassImplUtil.$$$reportNull$$$0(21);
        }
        if (level == null) {
            GrClassImplUtil.$$$reportNull$$$0(22);
        }
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)(field = (PsiField)fieldInfo.getElement()), place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)field) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)field)) {
            return true;
        }
        LOG.assertTrue(field.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)fieldInfo.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)field, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean processMethod(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, boolean placeGroovy, @NotNull CandidateInfo info) {
        PsiMethod method;
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            GrClassImplUtil.$$$reportNull$$$0(24);
        }
        if (state == null) {
            GrClassImplUtil.$$$reportNull$$$0(25);
        }
        if (place == null) {
            GrClassImplUtil.$$$reportNull$$$0(26);
        }
        if (substitutor == null) {
            GrClassImplUtil.$$$reportNull$$$0(27);
        }
        if (factory == null) {
            GrClassImplUtil.$$$reportNull$$$0(28);
        }
        if (level == null) {
            GrClassImplUtil.$$$reportNull$$$0(29);
        }
        if (info == null) {
            GrClassImplUtil.$$$reportNull$$$0(30);
        }
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)(method = (PsiMethod)info.getElement()), place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)method) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(placeGroovy, method)) {
            return true;
        }
        LOG.assertTrue(method.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)method, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean shouldProcessTraitMember(@NotNull GrTypeDefinition grType, @NotNull PsiMember element, @NotNull PsiElement place) {
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(31);
        }
        if (element == null) {
            GrClassImplUtil.$$$reportNull$$$0(32);
        }
        if (place == null) {
            GrClassImplUtil.$$$reportNull$$$0(33);
        }
        return !grType.isTrait() || !element.hasModifierProperty("static") || grType.equals(element.getContainingClass()) && PsiTreeUtil.isAncestor((PsiElement)grType, (PsiElement)place, (boolean)true);
    }

    private static boolean shouldProcessInstanceMembers(@NotNull GrTypeDefinition grType, @Nullable PsiElement lastParent) {
        GrModifierList modifierList;
        if (grType == null) {
            GrClassImplUtil.$$$reportNull$$$0(34);
        }
        return lastParent == null || (modifierList = grType.getModifierList()) == null || !modifierList.hasAnnotation("groovy.lang.Category");
    }

    private static boolean processInstanceMember(boolean shouldProcessInstance, @NotNull PsiMember member) {
        if (member == null) {
            GrClassImplUtil.$$$reportNull$$$0(35);
        }
        if (shouldProcessInstance) {
            return true;
        }
        if (member instanceof GrReflectedMethod) {
            return ((GrReflectedMethod)member).getBaseMethod().hasModifierProperty("static");
        }
        return member.hasModifierProperty("static");
    }

    public static boolean isSameDeclaration(PsiElement place, PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        if (element instanceof GrScriptField) {
            element = ((GrScriptField)element).getOriginalVariable();
        }
        while (place != null) {
            if (place == element) {
                return true;
            }
            place = place.getParent();
            if (element instanceof GrField && ((GrField)element).getInitializerGroovy() == place) {
                return false;
            }
            if (place instanceof GrClosableBlock) {
                return false;
            }
            if (!(place instanceof GrEnumConstantInitializer)) continue;
            return false;
        }
        return false;
    }

    private static boolean isMethodVisible(boolean isPlaceGroovy, PsiMethod method) {
        return isPlaceGroovy || !(method instanceof GrGdkMethod);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, false)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            return method;
        }
        return null;
    }

    private static PsiMethod[] findMethodsByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSyntheticAccessors) {
        if (!checkBases) {
            ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
            for (PsiMethod method : CollectClassMembersUtil.getMethods(grType, includeSyntheticAccessors)) {
                if (!name.equals(method.getName())) continue;
                result2.add(method);
            }
            return result2.toArray(PsiMethod.EMPTY_ARRAY);
        }
        Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, includeSyntheticAccessors);
        return PsiImplUtil.mapToMethods(methodsMap.get(name));
    }

    public static PsiMethod @NotNull [] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, true);
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(36);
        }
        return psiMethodArray;
    }

    public static PsiMethod @NotNull [] findCodeMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, false);
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(37);
        }
        return psiMethodArray;
    }

    public static PsiMethod @NotNull [] findMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, true);
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(38);
        }
        return psiMethodArray;
    }

    private static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases, boolean includeSynthetic) {
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, includeSynthetic)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            result2.add(method);
        }
        return result2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Nullable
    private static MethodSignature getSignatureForInheritor(@NotNull PsiMethod methodFromSuperClass, @NotNull GrTypeDefinition inheritor) {
        PsiClass clazz;
        if (methodFromSuperClass == null) {
            GrClassImplUtil.$$$reportNull$$$0(39);
        }
        if (inheritor == null) {
            GrClassImplUtil.$$$reportNull$$$0(40);
        }
        if ((clazz = methodFromSuperClass.getContainingClass()) == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        return methodFromSuperClass.getSignature(superSubstitutor);
    }

    public static PsiMethod @NotNull [] findCodeMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, false);
        if (psiMethodArray == null) {
            GrClassImplUtil.$$$reportNull$$$0(41);
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(GrTypeDefinition grType, String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        if (!checkBases) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = grType.findMethodsByName(name, false)) {
                result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
            }
        } else {
            Map<String, List<CandidateInfo>> map2 = CollectClassMembersUtil.getAllMethods(grType, true);
            List<CandidateInfo> candidateInfos = map2.get(name);
            if (candidateInfos != null) {
                for (CandidateInfo info : candidateInfos) {
                    PsiElement element = info.getElement();
                    result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)element), (Object)info.getSubstitutor()));
                }
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result2;
        if (arrayList == null) {
            GrClassImplUtil.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors(GrTypeDefinition grType) {
        Map<String, List<CandidateInfo>> allMethodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (List<CandidateInfo> infos : allMethodsMap.values()) {
            for (CandidateInfo info : infos) {
                result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result2;
        if (arrayList == null) {
            GrClassImplUtil.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @Nullable
    public static PsiField findFieldByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSynthetic) {
        if (!checkBases) {
            for (PsiField field : CollectClassMembersUtil.getFields(grType, includeSynthetic)) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        CandidateInfo info = fieldsMap.get(name);
        return info == null ? null : (PsiField)info.getElement();
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType) {
        return GrClassImplUtil.getAllFields(grType, true);
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType, boolean includeSynthetic) {
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        return (PsiField[])ContainerUtil.map2Array(fieldsMap.values(), PsiField.class, entry -> (PsiField)entry.getElement());
    }

    public static boolean isClassEquivalentTo(GrTypeDefinitionImpl definition, PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo((PsiClass)definition, (PsiElement)another);
    }

    @NotNull
    public static Collection<? extends PsiMethod> expandReflectedMethods(@NotNull PsiMethod method) {
        Object[] methods;
        if (method == null) {
            GrClassImplUtil.$$$reportNull$$$0(44);
        }
        if (method instanceof GrMethod && (methods = ((GrMethod)method).getReflectedMethods()).length > 0) {
            return new SmartList(methods);
        }
        List<PsiMethod> list = Collections.singletonList(method);
        if (list == null) {
            GrClassImplUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public static Set<MethodSignature> getDuplicatedSignatures(@NotNull PsiClass clazz) {
        if (clazz == null) {
            GrClassImplUtil.$$$reportNull$$$0(46);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
            MostlySingularMultiMap signatures2 = new MostlySingularMultiMap();
            for (PsiMethod method : clazz.getMethods()) {
                MethodSignature signature = method.getSignature(factory.createRawSubstitutor((PsiTypeParameterListOwner)method));
                signatures2.add((Object)signature, (Object)method);
            }
            HashSet<MethodSignature> result2 = new HashSet<MethodSignature>();
            for (MethodSignature signature : signatures2.keySet()) {
                if (signatures2.valuesForKey((Object)signature) <= 1) continue;
                result2.add(signature);
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{clazz});
        });
        if (set == null) {
            GrClassImplUtil.$$$reportNull$$$0(47);
        }
        return set;
    }

    public static GrAccessorMethod findSetter(GrField field) {
        return (GrAccessorMethod)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetSetter(field), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static GrAccessorMethod doGetSetter(GrField field) {
        PsiMethod[] setters;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        for (PsiMethod setter : setters = containingClass.findMethodsByName(GroovyPropertyUtils.getSetterName(field.getName()), false)) {
            if (!(setter instanceof GrAccessorMethod)) continue;
            return (GrAccessorMethod)setter;
        }
        return null;
    }

    public static GrAccessorMethod[] findGetters(GrField field) {
        return (GrAccessorMethod[])CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetGetters(field), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static GrAccessorMethod @NotNull [] doGetGetters(GrField field) {
        PsiMethod[] booleanGetters;
        PsiMethod[] getters;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            if (GrAccessorMethod.EMPTY_ARRAY == null) {
                GrClassImplUtil.$$$reportNull$$$0(48);
            }
            return GrAccessorMethod.EMPTY_ARRAY;
        }
        GrAccessorMethod getter = null;
        GrAccessorMethod booleanGetter = null;
        for (PsiMethod method : getters = containingClass.findMethodsByName(GroovyPropertyUtils.getGetterNameNonBoolean(field.getName()), false)) {
            if (!(method instanceof GrAccessorMethod)) continue;
            getter = (GrAccessorMethod)method;
            break;
        }
        for (PsiMethod method : booleanGetters = containingClass.findMethodsByName(GroovyPropertyUtils.getGetterNameBoolean(field.getName()), false)) {
            if (!(method instanceof GrAccessorMethod)) continue;
            booleanGetter = (GrAccessorMethod)method;
            break;
        }
        if (getter != null && booleanGetter != null) {
            GrAccessorMethod[] grAccessorMethodArray = new GrAccessorMethod[]{getter, booleanGetter};
            if (grAccessorMethodArray == null) {
                GrClassImplUtil.$$$reportNull$$$0(49);
            }
            return grAccessorMethodArray;
        }
        if (getter != null) {
            GrAccessorMethod[] grAccessorMethodArray = new GrAccessorMethod[]{getter};
            if (grAccessorMethodArray == null) {
                GrClassImplUtil.$$$reportNull$$$0(50);
            }
            return grAccessorMethodArray;
        }
        if (GrAccessorMethod.EMPTY_ARRAY == null) {
            GrClassImplUtil.$$$reportNull$$$0(51);
        }
        return GrAccessorMethod.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsListTypes";
                break;
            }
            case 13: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 19: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodFromSuperClass";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeConstructors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeMethodsBySignature";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeMethodsByName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "expandReflectedMethods";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicatedSignatures";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetGetters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCodeConstructors";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processField";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessTraitMember";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInstanceMembers";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceMember";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureForInheritor";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "expandReflectedMethods";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicatedSignatures";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

