/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrOperatorExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrOperatorReference;
import org.jetbrains.plugins.groovy.util.SafePublicationClearableLazyValue;

public class GrAssignmentExpressionImpl
extends GrOperatorExpressionImpl
implements GrAssignmentExpression {
    private final SafePublicationClearableLazyValue<GroovyCallReference> myReference;
    private final Function<GrAssignmentExpression, PsiType> ELVIS_TYPE_CALCULATOR;

    public GrAssignmentExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrAssignmentExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myReference = new SafePublicationClearableLazyValue(() -> this.isOperatorAssignment() ? new GrOperatorReference(this) : null);
        this.ELVIS_TYPE_CALCULATOR = e -> TypesUtil.getLeastUpperBoundNullable(e.getLeftType(), e.getRightType(), e.getManager());
    }

    @Override
    @Nullable
    public GroovyCallReference getReference() {
        return this.myReference.getValue();
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myReference.clear();
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    @NotNull
    public GrExpression getLValue() {
        GrExpression grExpression = Objects.requireNonNull(GrAssignmentExpressionImpl.findExpressionChild(this));
        if (grExpression == null) {
            GrAssignmentExpressionImpl.$$$reportNull$$$0(1);
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement psiElement = this.findNotNullChildByType(GroovyTokenSets.ASSIGNMENTS);
        if (psiElement == null) {
            GrAssignmentExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public IElementType getOperator() {
        return TokenSets.ASSIGNMENTS_TO_OPERATORS.get(this.getOperationTokenType());
    }

    @Override
    public boolean isOperatorAssignment() {
        return TokenSets.ASSIGNMENTS_TO_OPERATORS.containsKey(this.getOperationTokenType());
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrAssignmentExpressionImpl.$$$reportNull$$$0(3);
        }
        visitor2.visitAssignmentExpression(this);
    }

    @Override
    @Nullable
    public PsiType getLeftType() {
        return this.getLValue().getType();
    }

    @Override
    @Nullable
    public PsiType getRightType() {
        GrExpression rValue = this.getRValue();
        return rValue == null ? null : rValue.getType();
    }

    @Override
    @Nullable
    public PsiType getType() {
        IElementType type2 = this.getOperationTokenType();
        if (TokenSets.ASSIGNMENTS_TO_OPERATORS.containsKey(type2)) {
            return super.getType();
        }
        if (type2 == GroovyElementTypes.T_ELVIS_ASSIGN) {
            return TypeInferenceHelper.getCurrentContext().getExpressionType(this, this.ELVIS_TYPE_CALCULATOR);
        }
        return this.getRightType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrAssignmentExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

