/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.NestedContextKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.SharedVariableInferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesReachingDefinitionsInstance;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.InferenceContext;
import org.jetbrains.plugins.groovy.lang.psi.impl.PartialContext;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class TypeInferenceHelper {
    private static final Logger LOG = Logger.getInstance(TypeInferenceHelper.class);
    private static final ThreadLocal<InferenceContext> ourInferenceContext = new ThreadLocal();

    static <T> T doInference(@NotNull Map<VariableDescriptor, DFAType> bindings, boolean allowCaching, @NotNull Computable<? extends T> computation) {
        if (bindings == null) {
            TypeInferenceHelper.$$$reportNull$$$0(0);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            NestedContextKt.checkNestedContext();
        }
        boolean reallyAllowsCaching = allowCaching && TypeInferenceHelper.getCurrentContext().isInferenceResultsCachingAllowed();
        return TypeInferenceHelper.withContext(new PartialContext(bindings, reallyAllowsCaching), computation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withContext(@NotNull InferenceContext context, @NotNull Computable<? extends T> computation) {
        if (context == null) {
            TypeInferenceHelper.$$$reportNull$$$0(2);
        }
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(3);
        }
        InferenceContext previous = ourInferenceContext.get();
        ourInferenceContext.set(context);
        try {
            Object object = computation.compute();
            return (T)object;
        }
        finally {
            ourInferenceContext.set(previous);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static InferenceContext getCurrentContext() {
        InferenceContext context = ourInferenceContext.get();
        return context != null ? context : TypeInferenceHelper.getTopContext();
    }

    public static <T> T inTopContext(@NotNull Computable<? extends T> computation) {
        if (computation == null) {
            TypeInferenceHelper.$$$reportNull$$$0(4);
        }
        return TypeInferenceHelper.withContext(TypeInferenceHelper.getTopContext(), computation);
    }

    @NotNull
    @Contract(pure=true)
    public static InferenceContext getTopContext() {
        InferenceContext inferenceContext = InferenceContext.TOP_CONTEXT;
        if (inferenceContext == null) {
            TypeInferenceHelper.$$$reportNull$$$0(5);
        }
        return inferenceContext;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull GrReferenceExpression refExpr) {
        GrControlFlowOwner scope;
        if (refExpr == null) {
            TypeInferenceHelper.$$$reportNull$$$0(6);
        }
        if ((scope = ControlFlowUtils.findControlFlowOwner(refExpr)) == null) {
            return null;
        }
        GroovyReference rValueReference = refExpr.getRValueReference();
        PsiElement resolve2 = rValueReference == null ? null : rValueReference.resolve();
        boolean mixinOnly = resolve2 instanceof GrField && PsiUtil.isCompileStatic(refExpr);
        VariableDescriptor descriptor = VariableDescriptorFactory.createDescriptor(refExpr);
        if (descriptor == null) {
            return null;
        }
        ReadWriteVariableInstruction rwInstruction = ControlFlowUtils.findRWInstruction(refExpr, scope.getControlFlow());
        if (rwInstruction == null) {
            return null;
        }
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        PsiType sharedType = TypeInferenceHelper.getSharedVariableType(descriptor);
        return sharedType != null ? sharedType : cache2.getInferredType(descriptor, rwInstruction, mixinOnly);
    }

    @Nullable
    public static PsiType getInferredType(VariableDescriptor descriptor, Instruction instruction, GrControlFlowOwner scope) {
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        return cache2.getInferredType(descriptor, instruction, false);
    }

    @Nullable
    public static PsiType getVariableTypeInContext(@Nullable PsiElement context, @NotNull GrVariable variable) {
        if (variable == null) {
            TypeInferenceHelper.$$$reportNull$$$0(7);
        }
        if (context == null) {
            return variable.getType();
        }
        GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(context);
        if (scope == null) {
            return null;
        }
        Instruction nearest = ControlFlowUtils.findNearestInstruction(context, scope.getControlFlow());
        if (nearest == null) {
            return null;
        }
        boolean mixinOnly = variable instanceof GrField && PsiUtil.isCompileStatic(scope);
        InferenceCache cache2 = TypeInferenceHelper.getInferenceCache(scope);
        VariableDescriptor descriptor = VariableDescriptorFactory.createDescriptor(variable);
        PsiType sharedType = TypeInferenceHelper.getSharedVariableType(descriptor);
        if (sharedType != null) {
            return sharedType;
        }
        PsiType inferredType = cache2.getInferredType(descriptor, nearest, mixinOnly);
        return inferredType != null ? inferredType : variable.getType();
    }

    public static boolean isTooComplexTooAnalyze(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(8);
        }
        return TypeInferenceHelper.getInferenceCache(scope).isTooComplexToAnalyze();
    }

    @NotNull
    static InferenceCache getInferenceCache(@NotNull GrControlFlowOwner scope) {
        if (scope == null) {
            TypeInferenceHelper.$$$reportNull$$$0(9);
        }
        InferenceCache inferenceCache = (InferenceCache)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create((Object)new InferenceCache(scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (inferenceCache == null) {
            TypeInferenceHelper.$$$reportNull$$$0(10);
        }
        return inferenceCache;
    }

    static boolean isSharedVariable(@NotNull VariableDescriptor descriptor) {
        SharedVariableInferenceCache cache2;
        if (descriptor == null) {
            TypeInferenceHelper.$$$reportNull$$$0(11);
        }
        return (cache2 = TypeInferenceHelper.getSharedVariableCache(descriptor)) != null && cache2.getSharedVariableDescriptors().contains(descriptor);
    }

    @Nullable
    private static PsiType getSharedVariableType(@NotNull VariableDescriptor descriptor) {
        SharedVariableInferenceCache cache2;
        if (descriptor == null) {
            TypeInferenceHelper.$$$reportNull$$$0(12);
        }
        return (cache2 = TypeInferenceHelper.getSharedVariableCache(descriptor)) == null ? null : cache2.getSharedVariableType(descriptor);
    }

    @Nullable
    private static SharedVariableInferenceCache getSharedVariableCache(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            TypeInferenceHelper.$$$reportNull$$$0(13);
        }
        if (descriptor instanceof ResolvedVariableDescriptor) {
            GrControlFlowOwner trueOwner = ControlFlowUtils.findControlFlowOwner(((ResolvedVariableDescriptor)descriptor).getVariable());
            if (trueOwner == null) {
                return null;
            }
            return TypeInferenceHelper.getInferenceCache(trueOwner).getSharedVariableInferenceCache();
        }
        return null;
    }

    @Nullable
    static List<DefinitionMap> getDefUseMaps(Instruction @NotNull [] flow, @NotNull TObjectIntHashMap<VariableDescriptor> varIndexes) {
        if (varIndexes == null) {
            TypeInferenceHelper.$$$reportNull$$$0(14);
        }
        if (flow == null) {
            TypeInferenceHelper.$$$reportNull$$$0(15);
        }
        TypesReachingDefinitionsInstance dfaInstance = new TypesReachingDefinitionsInstance(flow, varIndexes);
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance, lattice);
        return engine.performDFAWithTimeout();
    }

    @Nullable
    public static PsiType getInitializerType(PsiElement element) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifierExpression() == null) {
            return TypeInferenceHelper.getInitializerTypeFor(element);
        }
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        return null;
    }

    @Nullable
    public static PsiType getInitializerTypeFor(PsiElement element) {
        GrUnaryExpression unary;
        GrTuple list;
        GrTupleAssignmentExpression assignment;
        PsiElement parent2 = PsiUtil.skipParentheses(element.getParent(), true);
        if (parent2 instanceof GrAssignmentExpression) {
            if (element instanceof GrIndexProperty) {
                GrExpression rvalue = ((GrAssignmentExpression)parent2).getRValue();
                return rvalue != null ? rvalue.getType() : null;
            }
            return ((GrAssignmentExpression)parent2).getType();
        }
        if (parent2 instanceof GrTuple && (assignment = (list = (GrTuple)parent2).getParent()) != null) {
            GrExpression rValue = assignment.getRValue();
            int idx = list.indexOf(element);
            if (idx >= 0 && rValue != null) {
                PsiType rType = rValue.getType();
                if (rType instanceof GrTupleType) {
                    List<PsiType> componentTypes = ((GrTupleType)rType).getComponentTypes();
                    if (idx < componentTypes.size()) {
                        return componentTypes.get(idx);
                    }
                    return null;
                }
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)rType, (boolean)false);
            }
        }
        if (parent2 instanceof GrUnaryExpression && TokenSets.POSTFIX_UNARY_OP_SET.contains((unary = (GrUnaryExpression)parent2).getOperationTokenType())) {
            return unary.getOperationType();
        }
        return null;
    }

    @Nullable
    public static GrExpression getInitializerFor(GrExpression lValue) {
        PsiElement parent2 = lValue.getParent();
        if (parent2 instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent2).getRValue();
        }
        if (parent2 instanceof GrTuple) {
            GrExpression[] initializers;
            int i = ((GrTuple)parent2).indexOf(lValue);
            GrTupleAssignmentExpression grandParent = ((GrTuple)parent2).getParent();
            LOG.assertTrue(grandParent != null);
            GrExpression rValue = grandParent.getRValue();
            if (rValue instanceof GrListOrMap && !((GrListOrMap)rValue).isMap() && i < (initializers = ((GrListOrMap)rValue).getInitializers()).length) {
                return initializers[i];
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeInferenceHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inTopContext";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeInContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTooComplexTooAnalyze";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSharedVariable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSharedVariableType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSharedVariableCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefUseMaps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

