/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetTypeState;
import org.jetbrains.jps.model.JpsModel;

public class BuildTargetsState {
    private static final Logger LOG = Logger.getInstance(BuildTargetsState.class);
    private final BuildDataPaths myDataPaths;
    private final AtomicInteger myMaxTargetId = new AtomicInteger(0);
    private long myLastSuccessfulRebuildDuration = -1L;
    private final ConcurrentMap<BuildTargetType<?>, BuildTargetTypeState> myTypeStates = new ConcurrentHashMap(16, 0.75f, 1);
    private final JpsModel myModel;
    private final BuildRootIndexImpl myBuildRootIndex;

    public BuildTargetsState(BuildDataPaths dataPaths, JpsModel model, BuildRootIndexImpl buildRootIndex) {
        this.myDataPaths = dataPaths;
        this.myModel = model;
        this.myBuildRootIndex = buildRootIndex;
        File targetTypesFile = this.getTargetTypesFile();
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(targetTypesFile)));){
            this.myMaxTargetId.set(input.readInt());
            this.myLastSuccessfulRebuildDuration = input.readLong();
        }
        catch (IOException e) {
            LOG.debug("Cannot load " + targetTypesFile + ":" + e.getMessage(), (Throwable)e);
            LOG.debug("Loading all target types to calculate max target id");
            for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
                this.getTypeState(type);
            }
        }
    }

    private File getTargetTypesFile() {
        return new File(this.myDataPaths.getTargetsDataRoot(), "targetTypes.dat");
    }

    public void save() {
        try {
            File targetTypesFile = this.getTargetTypesFile();
            FileUtil.createParentDirs((File)targetTypesFile);
            try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(targetTypesFile)));){
                output.writeInt(this.myMaxTargetId.get());
                output.writeLong(this.myLastSuccessfulRebuildDuration);
            }
        }
        catch (IOException e) {
            LOG.info("Cannot save targets info: " + e.getMessage(), (Throwable)e);
        }
        for (BuildTargetTypeState state : this.myTypeStates.values()) {
            state.save();
        }
    }

    public int getBuildTargetId(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildTargetsState.$$$reportNull$$$0(0);
        }
        return this.getTypeState(target.getTargetType()).getTargetId(target);
    }

    public long getLastSuccessfulRebuildDuration() {
        return this.myLastSuccessfulRebuildDuration;
    }

    public void setLastSuccessfulRebuildDuration(long duration) {
        this.myLastSuccessfulRebuildDuration = duration;
    }

    @NotNull
    public BuildTargetConfiguration getTargetConfiguration(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildTargetsState.$$$reportNull$$$0(1);
        }
        BuildTargetConfiguration buildTargetConfiguration = this.getTypeState(target.getTargetType()).getConfiguration(target);
        if (buildTargetConfiguration == null) {
            BuildTargetsState.$$$reportNull$$$0(2);
        }
        return buildTargetConfiguration;
    }

    public List<Pair<String, Integer>> getStaleTargetIds(@NotNull BuildTargetType<?> type) {
        if (type == null) {
            BuildTargetsState.$$$reportNull$$$0(3);
        }
        return this.getTypeState(type).getStaleTargetIds();
    }

    public void cleanStaleTarget(BuildTargetType<?> type, String targetId) {
        this.getTypeState(type).removeStaleTarget(targetId);
    }

    public void setAverageBuildTime(BuildTargetType<?> type, long time) {
        this.getTypeState(type).setAverageTargetBuildTime(time);
    }

    public long getAverageBuildTime(BuildTargetType<?> type) {
        return this.getTypeState(type).getAverageTargetBuildTime();
    }

    private BuildTargetTypeState getTypeState(BuildTargetType<?> type) {
        BuildTargetTypeState newState;
        BuildTargetTypeState state = (BuildTargetTypeState)this.myTypeStates.get(type);
        if (state == null && (state = this.myTypeStates.putIfAbsent(type, newState = new BuildTargetTypeState(type, this))) == null) {
            state = newState;
        }
        return state;
    }

    public void markUsedId(int id) {
        int max;
        int current;
        while (!this.myMaxTargetId.compareAndSet(current = this.myMaxTargetId.get(), max = Math.max(id, current))) {
        }
    }

    public int getFreeId() {
        return this.myMaxTargetId.incrementAndGet();
    }

    public void clean() {
        FileUtil.delete((File)this.myDataPaths.getTargetsDataRoot());
    }

    public JpsModel getModel() {
        return this.myModel;
    }

    public BuildRootIndexImpl getBuildRootIndex() {
        return this.myBuildRootIndex;
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetsState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetsState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTargetId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetConfiguration";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStaleTargetIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

