/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

abstract class Timed<T>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.Timed");
    private static final Map<Timed, Boolean> ourReferences = Collections.synchronizedMap(new WeakHashMap());
    protected static final int SERVICE_DELAY = 60;
    private int myLastCheckedAccessCount;
    int myAccessCount;
    protected T myT;
    private boolean myPolled;

    Timed(@Nullable Disposable parentDisposable) {
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public synchronized void dispose() {
        T t = this.myT;
        this.myT = null;
        if (t instanceof Disposable && !Disposer.isDisposed((Disposable)((Disposable)t))) {
            Disposer.dispose((Disposable)((Disposable)t));
        }
        this.remove();
    }

    protected final void poll() {
        if (!this.myPolled) {
            ourReferences.put(this, Boolean.TRUE);
            this.myPolled = true;
        }
    }

    protected final void remove() {
        ourReferences.remove(this);
        this.myPolled = false;
        this.myLastCheckedAccessCount = 0;
        this.myAccessCount = 0;
    }

    protected synchronized boolean isLocked() {
        return false;
    }

    protected synchronized boolean checkLocked() {
        return this.isLocked();
    }

    public synchronized boolean isCached() {
        return this.myT != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeTimed() {
        Timed[] references;
        for (Timed timed : references = ourReferences.keySet().toArray(new Timed[0])) {
            if (timed == null) continue;
            Timed timed2 = timed;
            synchronized (timed2) {
                if (timed.myLastCheckedAccessCount == timed.myAccessCount && !timed.checkLocked()) {
                    Disposer.dispose((Disposable)timed);
                } else {
                    timed.myLastCheckedAccessCount = timed.myAccessCount;
                }
            }
        }
    }

    static {
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            try {
                Timed.disposeTimed();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }
}

