/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchSupply {
    public static final String SEARCH_QUERY_KEY = "SEARCH_QUERY";
    private static final Key SPEED_SEARCH_COMPONENT_MARKER = new Key("SPEED_SEARCH_COMPONENT_MARKER");
    public static final DataKey<String> SPEED_SEARCH_CURRENT_QUERY = DataKey.create((String)"SPEED_SEARCH_CURRENT_QUERY");
    public static final String ENTERED_PREFIX_PROPERTY_NAME = "enteredPrefix";

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(0);
        }
        return SpeedSearchSupply.getSupply(component, false);
    }

    @Nullable
    public static SpeedSearchSupply getSupply(@NotNull JComponent component, boolean evenIfInactive) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(1);
        }
        SpeedSearchSupply speedSearch = (SpeedSearchSupply)component.getClientProperty(SPEED_SEARCH_COMPONENT_MARKER);
        if (evenIfInactive) {
            return speedSearch;
        }
        return speedSearch != null && speedSearch.isPopupActive() ? speedSearch : null;
    }

    @Nullable
    public abstract Iterable<TextRange> matchingFragments(@NotNull String var1);

    public abstract void refreshSelection();

    public abstract boolean isPopupActive();

    @Nullable
    public String getEnteredPrefix() {
        return null;
    }

    protected void installSupplyTo(@NotNull JComponent component) {
        if (component == null) {
            SpeedSearchSupply.$$$reportNull$$$0(2);
        }
        component.putClientProperty(SPEED_SEARCH_COMPONENT_MARKER, this);
        this.addChangeListener(evt -> component.repaint());
    }

    public abstract void addChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void removeChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void findAndSelectElement(@NotNull String var1);

    public boolean isObjectFilteredOut(Object o) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearchSupply";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSupply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installSupplyTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

