/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class HighlightedText {
    @Nls
    private final StringBuilder myBuffer;
    private final List<HighlightedRegion> myHighlightedRegions = new ArrayList<HighlightedRegion>();

    public HighlightedText() {
        this.myBuffer = new StringBuilder();
    }

    public void appendText(@Nls String text, TextAttributes attributes) {
        int startOffset = this.myBuffer.length();
        this.myBuffer.append(text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, this.myBuffer.length(), attributes));
        }
    }

    public void appendText(char[] text, TextAttributes attributes) {
        int startOffset = this.myBuffer.length();
        this.myBuffer.append(text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, this.myBuffer.length(), attributes));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HighlightedText)) {
            return false;
        }
        HighlightedText highlightedText = (HighlightedText)o;
        return StringUtil.equals((CharSequence)this.myBuffer, (CharSequence)highlightedText.myBuffer) && this.myHighlightedRegions.equals(highlightedText.myHighlightedRegions);
    }

    @NotNull
    @Nls
    public String getText() {
        String string = this.myBuffer.toString();
        if (string == null) {
            HighlightedText.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyToComponent(HighlightableComponent renderer) {
        renderer.setText(this.myBuffer.toString());
        for (HighlightedRegion info : this.myHighlightedRegions) {
            renderer.addHighlighter(info.startOffset, info.endOffset, info.textAttributes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/HighlightedText", "getText"));
    }
}

