/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class LocalFilePath
implements FilePath {
    @NotNull
    private final @SystemIndependent String myPath;
    private final boolean myIsDirectory;
    private VirtualFile myCachedFile;

    public LocalFilePath(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            LocalFilePath.$$$reportNull$$$0(0);
        }
        this.myPath = FileUtil.toCanonicalPath((String)path2);
        this.myIsDirectory = isDirectory;
    }

    public LocalFilePath(@NotNull Path path2, boolean isDirectory) {
        if (path2 == null) {
            LocalFilePath.$$$reportNull$$$0(1);
        }
        this(path2.toAbsolutePath().toString(), isDirectory);
    }

    private LocalFilePath(@NotNull String path2, boolean isDirectory, @Nullable Void privateConstructorMarker) {
        if (path2 == null) {
            LocalFilePath.$$$reportNull$$$0(2);
        }
        this.myPath = path2;
        this.myIsDirectory = isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFilePath path2 = (LocalFilePath)o;
        if (this.myIsDirectory != path2.myIsDirectory) {
            return false;
        }
        return FileUtil.PATH_HASHING_STRATEGY.equals((Object)this.myPath, (Object)path2.myPath);
    }

    public int hashCode() {
        int result = FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)this.myPath);
        result = 31 * result + (this.myIsDirectory ? 1 : 0);
        return result;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void hardRefresh() {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @Override
    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            LocalFilePath.$$$reportNull$$$0(4);
        }
        return FileUtil.startsWith((String)this.getPath(), (String)parent.getPath(), (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    @Override
    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath(this.myPath);
        return parent.isEmpty() ? null : new LocalFilePath(parent, true, null);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile cachedFile = this.myCachedFile;
        if (cachedFile == null || !cachedFile.isValid() || !FileUtil.PATH_HASHING_STRATEGY.equals((Object)cachedFile.getPath(), (Object)this.myPath)) {
            this.myCachedFile = cachedFile = LocalFileSystem.getInstance().findFileByPath(this.myPath);
        }
        return cachedFile;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @Override
    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @Override
    @NotNull
    public String getName() {
        String string = PathUtil.getFileName(this.myPath);
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string = FileUtil.toSystemDependentName((String)this.myPath);
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public Document getDocument() {
        VirtualFile file = this.getVirtualFile();
        if (file == null || file.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            LocalFilePath.$$$reportNull$$$0(7);
        }
        return charset;
    }

    @Override
    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file = this.getVirtualFile();
        String path2 = this.myPath;
        while (!(file != null && file.isValid() || path2.isEmpty())) {
            path2 = PathUtil.getParentPath(path2);
            file = LocalFileSystem.getInstance().findFileByPath(path2);
        }
        if (file != null) {
            Charset charset = file.getCharset();
            if (charset == null) {
                LocalFilePath.$$$reportNull$$$0(8);
            }
            return charset;
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance(project);
        Charset charset = e.getDefaultCharset();
        if (charset == null) {
            LocalFilePath.$$$reportNull$$$0(9);
        }
        return charset;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        VirtualFile file = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = file != null ? manager.getFileTypeByFile(file) : manager.getFileTypeByFileName(this.getName());
        if (fileType == null) {
            LocalFilePath.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    @Override
    public boolean isNonLocal() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/LocalFilePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/LocalFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

