/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.signatureHelp;

import com.intellij.codeInsight.signatureHelp.ParameterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class SignatureInfo {
    @Nullable
    private final String myDocumentation;
    private final String myLabel;
    private final List<ParameterInfo> myParameterInfos;
    private final int myHighlightedParam;

    public SignatureInfo(@Nullable String documentation, String label, List<ParameterInfo> infos, int highlightedParamIndex) {
        this.myDocumentation = documentation;
        this.myLabel = label;
        this.myParameterInfos = Collections.unmodifiableList(new ArrayList<ParameterInfo>(infos));
        this.myHighlightedParam = highlightedParamIndex;
    }

    @Nullable
    public String getDocumentation() {
        return this.myDocumentation;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public List<ParameterInfo> getParameterInformation() {
        return this.myParameterInfos;
    }

    public int getHighlightedParam() {
        return this.myHighlightedParam;
    }

    public String toString() {
        return "SignatureInfo{doc='" + this.myDocumentation + "', label='" + this.myLabel + "', paramInfo=" + this.myParameterInfos + ", highlighted=" + this.myHighlightedParam + "}";
    }
}

