/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance(AnalysisScope.class);
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    protected static final int PACKAGE = 5;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private Set<VirtualFile> myVFiles;
    private Set<VirtualFile> myFilesSet;
    private boolean myIncludeTestSource;

    public AnalysisScope(@NotNull Project project) {
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(0);
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(1);
        }
        this.myIncludeTestSource = true;
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(Module @NotNull [] modules) {
        if (modules == null) {
            AnalysisScope.$$$reportNull$$$0(2);
        }
        this.myIncludeTestSource = true;
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AnalysisScope.$$$reportNull$$$0(3);
        }
        this.myIncludeTestSource = true;
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AnalysisScope.$$$reportNull$$$0(4);
        }
        this.myIncludeTestSource = true;
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            AnalysisScope.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(6);
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(7);
        }
        if (virtualFiles == null) {
            AnalysisScope.$$$reportNull$$$0(8);
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        CompactVirtualFileSet files = new CompactVirtualFileSet(virtualFiles);
        files.freeze();
        this.myVFiles = files;
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    @NotNull
    protected PsiElementVisitor createFileSearcher(final @NotNull Collection<? super VirtualFile> addTo) {
        ProgressIndicator indicator;
        if (addTo == null) {
            AnalysisScope.$$$reportNull$$$0(9);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText(AnalysisBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                VirtualFile virtualFile2;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) && (virtualFile2 = file.getVirtualFile()) != null && !AnalysisScope.this.isFilteredOut(virtualFile2) && AnalysisScope.shouldHighlightFile(file)) {
                    addTo.add(virtualFile2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope$1", "visitFile"));
            }
        };
    }

    private boolean isFilteredOut(@NotNull VirtualFile virtualFile2) {
        GlobalSearchScope filter;
        if (virtualFile2 == null) {
            AnalysisScope.$$$reportNull$$$0(10);
        }
        if ((filter = this.myFilter) != null && !filter.contains(virtualFile2)) {
            return true;
        }
        return !this.myIncludeTestSource && TestSourcesFilter.isTestSources(virtualFile2, this.myProject);
    }

    @NotNull
    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule == null ? ProjectRootManager.getInstance(this.myProject).getFileIndex() : ModuleRootManager.getInstance(this.myModule).getFileIndex();
        if (fileIndex == null) {
            AnalysisScope.$$$reportNull$$$0(11);
        }
        return fileIndex;
    }

    @NotNull
    private static String displayProjectRelativePath(@NotNull PsiFileSystemItem item) {
        VirtualFile virtualFile2;
        if (item == null) {
            AnalysisScope.$$$reportNull$$$0(12);
        }
        LOG.assertTrue((virtualFile2 = item.getVirtualFile()) != null, (Object)item);
        String string = ProjectUtilCore.displayUrlRelativeToProject(virtualFile2, virtualFile2.getPresentableUrl(), item.getProject(), true, false);
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        VirtualFile file;
        if (psiElement == null) {
            AnalysisScope.$$$reportNull$$$0(14);
        }
        return (file = psiElement.getContainingFile().getVirtualFile()) != null && this.contains(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Set<VirtualFile> fileSet;
        if (file == null) {
            AnalysisScope.$$$reportNull$$$0(15);
        }
        if ((fileSet = this.myFilesSet) == null) {
            if (this.myType == 8 && this.myScope != null) {
                return this.myScope.contains(file);
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && !this.isFilteredOut(file);
            }
        }
        return this.getFileSet().contains(file);
    }

    @NotNull
    protected Set<VirtualFile> createFilesSet() {
        final CompactVirtualFileSet fileSet = new CompactVirtualFileSet();
        switch (this.myType) {
            case 3: {
                fileSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
                fileSet.freeze();
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                this.accept(this.createFileSearcher(fileSet));
                fileSet.freeze();
                break;
            }
            case 9: {
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                for (VirtualFile vFile : this.myVFiles) {
                    VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                        @Override
                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                            boolean ignored;
                            if (file == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (!(ignored = ((Boolean)ReadAction.compute(() -> fileIndex.isExcluded(file))).booleanValue()) && !file.isDirectory()) {
                                fileSet.add(file);
                            }
                            VirtualFileVisitor.Result result = ignored ? SKIP_CHILDREN : CONTINUE;
                            if (result == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            return result;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/analysis/AnalysisScope$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/analysis/AnalysisScope$2";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFileEx";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFileEx";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.myType + "; can't create file set off it");
            }
        }
        CompactVirtualFileSet compactVirtualFileSet = fileSet;
        if (compactVirtualFileSet == null) {
            AnalysisScope.$$$reportNull$$$0(16);
        }
        return compactVirtualFileSet;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(17);
        }
        this.acceptImpl(visitor, false);
    }

    public void acceptIdempotentVisitor(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(18);
        }
        this.acceptImpl(visitor, true);
    }

    private void acceptImpl(@NotNull PsiElementVisitor visitor, boolean idempotent) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(19);
        }
        boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        FileIndex fileIndex = this.getFileIndex();
        this.accept((Processor<? super VirtualFile>)((Processor)file -> {
            if (file.isDirectory()) {
                return true;
            }
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file)) {
                return true;
            }
            if (fileIndex.isInContent((VirtualFile)file) && !this.isFilteredOut((VirtualFile)file) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
                return AnalysisScope.processFile(file, visitor, psiManager, needReadAction, idempotent);
            }
            return true;
        }));
    }

    public boolean accept(@NotNull Processor<? super VirtualFile> processor) {
        List<Module> modules;
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(20);
        }
        if (this.myType == 9) {
            return ((CompactVirtualFileSet)this.getFileSet()).process((Processor<? super VirtualFile>)((Processor)file -> this.isFilteredOut((VirtualFile)file) || processor.process(file)));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (PsiElement element : psiElements) {
                VirtualFile file2 = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile(element));
                if (file2 == null || !files.add(file2) || processor.process((Object)file2)) continue;
                return false;
            }
            return true;
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, null))) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file3 = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile(this.myElement));
            return file3 == null || processor.process((Object)file3);
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, null));
    }

    @NotNull
    private Collection<VirtualFile> getFileSet() {
        Set<VirtualFile> fileSet = this.myFilesSet;
        if (fileSet == null) {
            this.myFilesSet = fileSet = this.createFilesSet();
        }
        Set<VirtualFile> set = fileSet;
        if (set == null) {
            AnalysisScope.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    private ContentIterator createScopeIterator(@NotNull Processor<? super VirtualFile> processor, @Nullable SearchScope searchScope) {
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(22);
        }
        ContentIterator contentIterator = fileOrDir -> {
            boolean isInScope = (Boolean)ReadAction.compute(() -> {
                if (this.isFilteredOut(fileOrDir)) {
                    return false;
                }
                if (searchScope != null && !searchScope.contains(fileOrDir)) {
                    return false;
                }
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, this.myProject)) {
                    return false;
                }
                return true;
            });
            return !isInScope || processor.process((Object)fileOrDir);
        };
        if (contentIterator == null) {
            AnalysisScope.$$$reportNull$$$0(23);
        }
        return contentIterator;
    }

    private static boolean processFile(@NotNull VirtualFile vFile, @NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, boolean needReadAction, boolean idempotent) {
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(24);
        }
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(25);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(26);
        }
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            Project project = psiManager.getProject();
            if (idempotent) {
                ReadAction.nonBlocking(() -> AnalysisScope.doProcessFile(visitor, psiManager, vFile)).withDocumentsCommitted(project).inSmartMode(project).executeSynchronously();
            } else {
                AnalysisScope.commitAndRunInSmartMode(() -> AnalysisScope.doProcessFile(visitor, psiManager, vFile), project);
            }
        } else {
            AnalysisScope.doProcessFile(visitor, psiManager, vFile);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project);
            dumbService.waitForSmartMode();
        } while (!(passed = ((Boolean)PsiDocumentManager.getInstance(project).commitAndRunReadAction(() -> {
            if (dumbService.isDumb()) {
                return false;
            }
            runnable.run();
            return true;
        })).booleanValue()));
    }

    private static boolean shouldHighlightFile(@NotNull PsiFile file) {
        if (file == null) {
            AnalysisScope.$$$reportNull$$$0(27);
        }
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(@NotNull Module module) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(28);
        }
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
            case 8: {
                for (VirtualFile file : ModuleRootManager.getInstance(module).getSourceRoots()) {
                    if (!this.myScope.contains(file)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(29);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(30);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(31);
        }
        ProgressManager.checkCanceled();
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor);
        InjectedLanguageManager.getInstance(psiManager.getProject()).dropFileCaches(psiFile);
    }

    protected boolean accept(@NotNull PsiDirectory dir, @NotNull Processor<? super VirtualFile> processor) {
        if (dir == null) {
            AnalysisScope.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(33);
        }
        Project project = dir.getProject();
        boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, fileOrDir -> {
            if (this.isFilteredOut(fileOrDir)) {
                return true;
            }
            if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project)) {
                return true;
            }
            return fileOrDir.isDirectory() || processor.process((Object)fileOrDir);
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                String string = this.myScope.getDisplayName();
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(34);
                }
                return string;
            }
            case 4: {
                String string = AnalysisBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(35);
                }
                return string;
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, module -> AnalysisScope.pathToName(module.getModuleFilePath()), (String)", ");
                String string = AnalysisBundle.message("scope.module.list", modules, this.myModules.size());
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(36);
                }
                return string;
            }
            case 1: {
                String string = AnalysisBundle.message("scope.project", this.myProject.getName());
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(37);
                }
                return string;
            }
            case 3: {
                String string = AnalysisBundle.message("scope.file", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(38);
                }
                return string;
            }
            case 2: {
                String string = AnalysisBundle.message("scope.directory", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(39);
                }
                return string;
            }
            case 9: {
                String string = AnalysisBundle.message("scope.virtual.files", new Object[0]);
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(40);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    @Nls
    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                String string = this.myScope.getDisplayName();
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(41);
                }
                return string;
            }
            case 4: {
                String string = AnalysisBundle.message("scope.option.module", this.myModule.getName());
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(42);
                }
                return string;
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, Module::getName, (String)", ");
                String string = AnalysisBundle.message("scope.module.list", modules, this.myModules.size());
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(43);
                }
                return string;
            }
            case 1: {
                String string = AnalysisBundle.message("scope.project", this.myProject.getName());
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(44);
                }
                return string;
            }
            case 3: {
                String relativePath = this.getRelativePath();
                String string = AnalysisBundle.message("scope.file", relativePath);
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(45);
                }
                return string;
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                String string = AnalysisBundle.message("scope.directory", relativeDirPath);
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(46);
                }
                return string;
            }
            case 9: {
                String string = AnalysisBundle.message("scope.selected.files", new Object[0]);
                if (string == null) {
                    AnalysisScope.$$$reportNull$$$0(47);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(48);
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public List<Module> getModules() {
        List<Module> list = this.myModules == null ? Collections.emptyList() : Collections.unmodifiableList(this.myModules);
        if (list == null) {
            AnalysisScope.$$$reportNull$$$0(49);
        }
        return list;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public Set<VirtualFile> getFiles() {
        Set<Object> set = this.myVFiles == null ? Collections.emptySet() : this.myVFiles;
        if (set == null) {
            AnalysisScope.$$$reportNull$$$0(50);
        }
        return set;
    }

    @NotNull
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement);
        if (relativePath.length() > 100) {
            String string = ((PsiFileSystemItem)this.myElement).getName();
            if (string == null) {
                AnalysisScope.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = relativePath;
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static String pathToName(@NotNull String path2) {
        if (path2 == null) {
            AnalysisScope.$$$reportNull$$$0(53);
        }
        File file = new File(path2);
        String string = FileUtilRt.getNameWithoutExtension((String)file.getName());
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(54);
        }
        return string;
    }

    public int getFileCount() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.getFileSet().size();
    }

    public void invalidate() {
        if (this.myType == 9) {
            CompactVirtualFileSet files = new CompactVirtualFileSet(ContainerUtil.filter(this.myVFiles, virtualFile2 -> virtualFile2 != null && virtualFile2.isValid()));
            files.freeze();
            this.myVFiles = files;
        } else {
            this.myFilesSet = null;
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest == TestSourcesFilter.isTestSources(directory, this.myProject);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest == TestSourcesFilter.isTestSources(file, this.myProject);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(55);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull Set<? extends Module> modules) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(56);
        }
        if (modules == null) {
            AnalysisScope.$$$reportNull$$$0(57);
        }
        if (modules.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(Module.EMPTY_ARRAY));
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, Module @NotNull [] allModules) {
        if (fromModule == null) {
            AnalysisScope.$$$reportNull$$$0(58);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(59);
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(60);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, Module @NotNull [] allModules) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(61);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(62);
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance(dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            AnalysisScope.$$$reportNull$$$0(64);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(65);
        }
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrary(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(66);
        }
        return hashSet;
    }

    @NotNull
    public SearchScope toSearchScope() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        switch (this.myType) {
            case 8: {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(67);
                }
                return searchScope;
            }
            case 2: {
                GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(68);
                }
                return globalSearchScope;
            }
            case 3: {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this.myElement);
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(69);
                }
                return globalSearchScope;
            }
            case 6: {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(70);
                }
                return globalSearchScope;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(71);
                }
                return globalSearchScope;
            }
            case 7: {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])this.myModules.stream().map(m -> GlobalSearchScope.moduleScope(m)).toArray(GlobalSearchScope[]::new));
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(72);
                }
                return globalSearchScope;
            }
            case 1: {
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
                if (globalSearchScope == null) {
                    AnalysisScope.$$$reportNull$$$0(73);
                }
                return globalSearchScope;
            }
            case 9: {
                return new GlobalSearchScope(){

                    @Override
                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return AnalysisScope.this.getFileSet().contains(file);
                    }

                    @Override
                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "aModule";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/analysis/AnalysisScope$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contains";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSearchInModuleContent";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        }
        LOG.error("invalid type " + this.myType);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            AnalysisScope.$$$reportNull$$$0(74);
        }
        return globalSearchScope;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public void setFilter(@NotNull GlobalSearchScope filter) {
        if (filter == null) {
            AnalysisScope.$$$reportNull$$$0(75);
        }
        this.myFilter = filter;
    }

    public String toString() {
        return (String)ReadAction.compute(() -> this.toSearchScope().toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 60: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 60: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 28: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 60: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 20: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: 
            case 31: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProject";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModule";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModules";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "displayProjectRelativePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesSet";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSet";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeIterator";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToName";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportBackwardDependencies";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectBackwardDependencies";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterestingModules";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "toSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileSearcher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFilteredOut";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 60: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "displayProjectRelativePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 17: 
            case 20: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptIdempotentVisitor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "acceptImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createScopeIterator";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "containsModule";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doProcessFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "pathToName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedComplementaryScope";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getExportBackwardDependencies";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getDirectBackwardDependencies";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterestingModules";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 60: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface Type {
    }
}

