/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SmartList;
import com.intellij.util.io.CharSequenceBackedByChars;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"readCharSequence", "", "reader", "Ljava/io/InputStreamReader;", "decodeBase64", "", "", "encodeUrlQueryParameter", "Ljava/io/Reader;", "length", "", "toByteArray", "Ljava/nio/ByteBuffer;", "isClear", "", "intellij.platform.util.ex"})
public final class IoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$readCharSequence, (String)"$this$readCharSequence");
        Closeable closeable = $this$readCharSequence;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int count;
            int n;
            Reader it = (Reader)closeable;
            boolean bl3 = false;
            char[] chars = new char[length];
            for (count = 0; count < chars.length && (n = $this$readCharSequence.read(chars, count, chars.length - count)) > 0; count += n) {
            }
            CharSequence charSequence = (CharSequence)((Object)new CharSequenceBackedByChars(chars, 0, count));
            return charSequence;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Deprecated(message="For Java code only (Reader is accepted now instead of InputStreamReader and it breaks compatibility)", level=DeprecationLevel.ERROR, replaceWith=@ReplaceWith(imports={}, expression="reader.readCharSequence()"))
    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return IoKt.readCharSequence((Reader)reader);
    }

    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$readCharSequence, (String)"$this$readCharSequence");
        char[] chars = new char[8192];
        List buffers = null;
        int count = 0;
        int total = 0;
        while ((n = $this$readCharSequence.read(chars, count, chars.length - count)) > 0) {
            total += n;
            if ((count += n) != chars.length) continue;
            if (buffers == null) {
                buffers = (List)new SmartList();
            }
            buffers.add(chars);
            int n2 = 0x100000;
            int n3 = chars.length * 2;
            boolean bl = false;
            int newLength = Math.min(n2, n3);
            chars = new char[newLength];
            count = 0;
        }
        if (buffers == null) {
            return (CharSequence)((Object)new CharSequenceBackedByChars(chars, 0, total));
        }
        char[] result = new char[total];
        for (char[] buffer : buffers) {
            System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
            total -= buffer.length;
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        return (CharSequence)((Object)new CharSequenceBackedByChars(result));
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $this$toByteArray, boolean isClear) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"$this$toByteArray");
        if ($this$toByteArray.hasArray()) {
            int offset = $this$toByteArray.arrayOffset();
            byte[] array = $this$toByteArray.array();
            if (offset == 0 && array.length == $this$toByteArray.limit()) {
                Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
                return array;
            }
            Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
            byte[] byArray = array;
            int n = offset + $this$toByteArray.limit();
            boolean bl = false;
            byte[] result = ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)n);
            if (isClear) {
                ArraysKt.fill$default((byte[])array, (byte)0, (int)0, (int)0, (int)6, null);
            }
            return result;
        }
        byte[] bytes = new byte[$this$toByteArray.limit()];
        $this$toByteArray.get(bytes);
        return bytes;
    }

    public static /* synthetic */ byte[] toByteArray$default(ByteBuffer byteBuffer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IoKt.toByteArray(byteBuffer, bl);
    }

    @NotNull
    public static final String encodeUrlQueryParameter(@NotNull String $this$encodeUrlQueryParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUrlQueryParameter, (String)"$this$encodeUrlQueryParameter");
        String string = URLEncoder.encode($this$encodeUrlQueryParameter, Charsets.UTF_8.name());
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"$this$decodeBase64");
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(this)");
        return byArray;
    }
}

