/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public final class HTMLControls {
    private static final Logger LOG = Logger.getInstance(HTMLControls.class);
    private static Control[] ourControls;

    public static Control[] getControls() {
        if (ourControls == null) {
            ourControls = HTMLControls.loadControls();
        }
        return ourControls;
    }

    private static Control[] loadControls() {
        Element element;
        try {
            byte[] bytes;
            try (InputStream stream = HTMLControls.class.getResourceAsStream("HtmlControls.xml");){
                bytes = FileUtilRt.loadBytes((InputStream)stream);
            }
            try (UnsyncByteArrayInputStream bytesStream = new UnsyncByteArrayInputStream(bytes);){
                element = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)bytesStream));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new Control[0];
        }
        if (!element.getName().equals("htmlControls")) {
            LOG.error("HTMLControls storage is broken");
            return new Control[0];
        }
        return HTMLControls.deserialize(element);
    }

    private static Control[] deserialize(Element element) {
        ArrayList<Control> controls = new ArrayList<Control>();
        for (Element child : element.getChildren()) {
            if (!"control".equals(child.getName())) continue;
            Control control = new Control(child.getAttributeValue("name"), TagState.valueOf(StringUtil.toUpperCase((String)child.getAttributeValue("startTag"))), TagState.valueOf(StringUtil.toUpperCase((String)child.getAttributeValue("endTag"))), "true".equalsIgnoreCase(child.getAttributeValue("emptyAllowed")), HTMLControls.autoClosed(child.getAttributeValue("autoClosedBy")));
            controls.add(control);
        }
        return controls.toArray(new Control[0]);
    }

    private static Set<String> autoClosed(@Nullable String value) {
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String closingTag : StringUtil.split((String)value, (String)",")) {
            result.add(StringUtil.toLowerCase((String)closingTag.trim()));
        }
        return result;
    }

    public static class Control {
        public final String name;
        public final TagState startTag;
        public final TagState endTag;
        public final boolean emptyAllowed;
        public final Set<String> autoClosedBy;

        public Control(String name, TagState startTag, TagState endTag, boolean emptyAllowed, Set<String> autoClosedBy) {
            this.name = name;
            this.endTag = endTag;
            this.startTag = startTag;
            this.emptyAllowed = emptyAllowed;
            this.autoClosedBy = autoClosedBy;
        }
    }

    public static enum TagState {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

