/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwIntroBooleanProperty;
import com.intellij.uiDesigner.lw.LwIntroCharProperty;
import com.intellij.uiDesigner.lw.LwIntroColorProperty;
import com.intellij.uiDesigner.lw.LwIntroComponentProperty;
import com.intellij.uiDesigner.lw.LwIntroDimensionProperty;
import com.intellij.uiDesigner.lw.LwIntroEnumProperty;
import com.intellij.uiDesigner.lw.LwIntroFontProperty;
import com.intellij.uiDesigner.lw.LwIntroIconProperty;
import com.intellij.uiDesigner.lw.LwIntroInsetsProperty;
import com.intellij.uiDesigner.lw.LwIntroIntProperty;
import com.intellij.uiDesigner.lw.LwIntroListModelProperty;
import com.intellij.uiDesigner.lw.LwIntroPrimitiveTypeProperty;
import com.intellij.uiDesigner.lw.LwIntroRectangleProperty;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwRbIntroStringProperty;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListModel;

public final class CompiledClassPropertiesProvider
implements PropertiesProvider {
    private final ClassLoader myLoader;
    private final HashMap<String, Map<String, LwIntrospectedProperty>> myCache;

    public CompiledClassPropertiesProvider(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        this.myLoader = loader;
        this.myCache = new HashMap();
    }

    @Override
    public HashMap getLwProperties(String className) {
        PropertyDescriptor[] descriptors;
        BeanInfo beanInfo;
        Class<?> aClass;
        if (this.myCache.containsKey(className)) {
            return (HashMap)this.myCache.get(className);
        }
        if (Utils.validateJComponentClass(this.myLoader, className, false) != null) {
            return null;
        }
        try {
            aClass = Class.forName(className, false, this.myLoader);
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc.toString());
        }
        try {
            beanInfo = Introspector.getBeanInfo(aClass);
        }
        catch (Throwable e) {
            return null;
        }
        HashMap<String, LwIntrospectedProperty> result = new HashMap<String, LwIntrospectedProperty>();
        for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
            String name;
            LwIntrospectedProperty property;
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            Class<?> propertyType = descriptor.getPropertyType();
            if (writeMethod == null || readMethod == null || propertyType == null || (property = CompiledClassPropertiesProvider.propertyFromClass(propertyType, name = descriptor.getName())) == null) continue;
            property.setDeclaringClassName(descriptor.getReadMethod().getDeclaringClass().getName());
            result.put(name, property);
        }
        this.myCache.put(className, result);
        return result;
    }

    public static LwIntrospectedProperty propertyFromClass(Class propertyType, String name) {
        LwIntrospectedProperty property = CompiledClassPropertiesProvider.propertyFromClassName(propertyType.getName(), name);
        if (property == null) {
            if (Component.class.isAssignableFrom(propertyType)) {
                property = new LwIntroComponentProperty(name, propertyType.getName());
            } else if (ListModel.class.isAssignableFrom(propertyType)) {
                property = new LwIntroListModelProperty(name, propertyType.getName());
            } else if (propertyType.getSuperclass() != null && "java.lang.Enum".equals(propertyType.getSuperclass().getName())) {
                property = new LwIntroEnumProperty(name, propertyType);
            }
        }
        return property;
    }

    public static LwIntrospectedProperty propertyFromClassName(String propertyClassName, String name) {
        LwIntrospectedProperty property = Integer.TYPE.getName().equals(propertyClassName) ? new LwIntroIntProperty(name) : (Boolean.TYPE.getName().equals(propertyClassName) ? new LwIntroBooleanProperty(name) : (Double.TYPE.getName().equals(propertyClassName) ? new LwIntroPrimitiveTypeProperty(name, Double.class) : (Float.TYPE.getName().equals(propertyClassName) ? new LwIntroPrimitiveTypeProperty(name, Float.class) : (Long.TYPE.getName().equals(propertyClassName) ? new LwIntroPrimitiveTypeProperty(name, Long.class) : (Byte.TYPE.getName().equals(propertyClassName) ? new LwIntroPrimitiveTypeProperty(name, Byte.class) : (Short.TYPE.getName().equals(propertyClassName) ? new LwIntroPrimitiveTypeProperty(name, Short.class) : (Character.TYPE.getName().equals(propertyClassName) ? new LwIntroCharProperty(name) : (String.class.getName().equals(propertyClassName) ? new LwRbIntroStringProperty(name) : ("java.awt.Insets".equals(propertyClassName) ? new LwIntroInsetsProperty(name) : ("java.awt.Dimension".equals(propertyClassName) ? new LwIntroDimensionProperty(name) : ("java.awt.Rectangle".equals(propertyClassName) ? new LwIntroRectangleProperty(name) : ("java.awt.Color".equals(propertyClassName) ? new LwIntroColorProperty(name) : ("java.awt.Font".equals(propertyClassName) ? new LwIntroFontProperty(name) : ("javax.swing.Icon".equals(propertyClassName) ? new LwIntroIconProperty(name) : null))))))))))))));
        return property;
    }
}

