/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.bitmap;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.ocf.OCFZipPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.util.CheckUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class BitmapChecker
implements ContentChecker {
    private final OCFPackage ocf;
    private final Report report;
    private final String path;
    private final String mimeType;
    private static final int HEIGHT_MAX = 2160;
    private static final int WIDTH_MAX = 3840;
    private static final long IMAGESIZE_MAX = 0x400000L;

    BitmapChecker(OCFPackage ocf, Report report, String path, String mimeType) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.mimeType = mimeType;
    }

    private void checkHeader(byte[] header) {
        boolean passed;
        if (this.mimeType.equals("image/jpeg")) {
            passed = header[0] == -1 && header[1] == -40;
        } else if (this.mimeType.equals("image/gif")) {
            passed = header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56;
        } else {
            boolean bl = passed = !this.mimeType.equals("image/png") || header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71;
        }
        if (!passed) {
            this.report.message(MessageId.OPF_029, EPUBLocation.create(this.ocf.getName()), this.path, this.mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageHeuristics getImageSizes(String imgFileName) throws IOException {
        int pos = imgFileName.lastIndexOf(".");
        if (pos == -1) {
            throw new IOException("No extension for file: " + imgFileName);
        }
        String suffix = imgFileName.substring(pos + 1);
        File tempFile = null;
        if ("svg".compareToIgnoreCase(suffix) == 0) {
            tempFile = this.getImageFile(this.ocf, imgFileName);
            if (tempFile != null) {
                long tempFileLength = tempFile.length();
                if (this.ocf.getClass() == OCFZipPackage.class) {
                    tempFile.delete();
                }
                return new ImageHeuristics(0, 0, tempFileLength);
            }
            return null;
        }
        tempFile = this.getImageFile(this.ocf, imgFileName);
        String formatFromInputStream = null;
        String formatFromSuffix = null;
        ImageReader reader = null;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(tempFile);
        Iterator<ImageReader> imageReaderIteratorFromInputStream = ImageIO.getImageReaders(imageInputStream);
        while (imageReaderIteratorFromInputStream.hasNext()) {
            ImageReader imageReaderFromInputStream = imageReaderIteratorFromInputStream.next();
            formatFromInputStream = imageReaderFromInputStream.getFormatName();
            Iterator<ImageReader> imageReaderIteratorFromSuffix = ImageIO.getImageReadersBySuffix(suffix);
            while (imageReaderIteratorFromSuffix.hasNext() && ((formatFromSuffix = (reader = imageReaderIteratorFromSuffix.next()).getFormatName()) == null || !formatFromSuffix.equals(formatFromInputStream))) {
            }
            if (formatFromSuffix == null || !formatFromSuffix.equals(formatFromInputStream)) continue;
            break;
        }
        imageInputStream.close();
        if (formatFromSuffix != null && formatFromSuffix.equals(formatFromInputStream)) {
            try {
                ImageHeuristics imageHeuristics;
                FileImageInputStream stream = new FileImageInputStream(tempFile);
                try {
                    reader.setInput(stream);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    imageHeuristics = new ImageHeuristics(width, height, tempFile.length());
                }
                catch (Throwable throwable) {
                    ImageHeuristics imageHeuristics2;
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.report.message(MessageId.PKG_021, EPUBLocation.create(imgFileName), new Object[0]);
                        imageHeuristics2 = null;
                        return imageHeuristics2;
                    }
                    catch (RuntimeException argex) {
                        this.report.message(MessageId.PKG_021, EPUBLocation.create(imgFileName), new Object[0]);
                        imageHeuristics2 = null;
                        return imageHeuristics2;
                    }
                }
                stream.close();
                return imageHeuristics;
            }
            finally {
                if (this.ocf.getClass() == OCFZipPackage.class) {
                    tempFile.delete();
                }
            }
        }
        if (this.ocf.getClass() == OCFZipPackage.class) {
            tempFile.delete();
        }
        if (formatFromSuffix != null) {
            this.report.message(MessageId.PKG_022, EPUBLocation.create(imgFileName), formatFromInputStream, suffix);
            return null;
        }
        throw new IOException("Not a known image file: " + imgFileName);
    }

    private File getImageFile(OCFPackage ocf, String imgFileName) throws IOException {
        if (ocf.getClass() == OCFZipPackage.class) {
            return this.getTempImageFile((OCFZipPackage)ocf, imgFileName);
        }
        return new File(ocf.getPackagePath() + File.separator + imgFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getTempImageFile(OCFZipPackage ocf, String imgFileName) throws IOException {
        File file = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int read;
            int pos = imgFileName.lastIndexOf(".");
            if (pos == -1) {
                throw new IOException("No extension for file: " + imgFileName);
            }
            String suffix = imgFileName.substring(pos);
            String prefix = "img";
            file = File.createTempFile(prefix, suffix);
            os = new FileOutputStream(file);
            is = ocf.getInputStream(imgFileName);
            if (is == null) {
                File file2 = null;
                return file2;
            }
            byte[] bytes = new byte[32768];
            while ((read = is.read(bytes)) > 0) {
                ((FileOutputStream)os).write(bytes, 0, read);
            }
        }
        finally {
            if (os != null) {
                os.flush();
                ((FileOutputStream)os).close();
            }
            if (is != null) {
                is.close();
            }
        }
        return file;
    }

    private void checkImageDimensions(String imageFileName) {
        try {
            ImageHeuristics h = this.getImageSizes(imageFileName);
            if (h != null) {
                if (h.height >= 2160 || h.width >= 3840) {
                    this.report.message(MessageId.OPF_051, EPUBLocation.create(imageFileName), new Object[0]);
                }
                if (h.length >= 0x400000L) {
                    this.report.message(MessageId.OPF_057, EPUBLocation.create(imageFileName), new Object[0]);
                }
            }
        }
        catch (IOException ex) {
            this.report.message(MessageId.PKG_021, EPUBLocation.create(imageFileName), new Object[0]);
        }
        catch (LinkageError error) {
            this.report.message(MessageId.RSC_022, EPUBLocation.create(imageFileName), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(this.ocf.getName()), this.path);
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(this.ocf.getName()), this.path);
        } else {
            InputStream in = null;
            try {
                byte[] header;
                int rd;
                in = this.ocf.getInputStream(this.path);
                if (in == null) {
                    this.report.message(MessageId.RSC_001, EPUBLocation.create(this.ocf.getName()), this.path);
                }
                if ((rd = CheckUtil.readBytes(in, header = new byte[4], 0, 4)) < 4) {
                    this.report.message(MessageId.MED_004, EPUBLocation.create(this.path), new Object[0]);
                } else {
                    this.checkHeader(header);
                }
                this.checkImageDimensions(this.path);
            }
            catch (IOException e) {
                this.report.message(MessageId.PKG_021, EPUBLocation.create(this.path, this.path), new Object[0]);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public class ImageHeuristics {
        public int width;
        public int height;
        public long length;

        public ImageHeuristics(int width, int height, long length) {
            this.width = width;
            this.height = height;
            this.length = length;
        }
    }
}

