/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.phase.UserTreeVisitor;

public class ENewArray
extends AExpression {
    private final String canonicalTypeName;
    private final List<AExpression> valueNodes;
    private final boolean isInitializer;

    public ENewArray(int identifier, Location location, String canonicalTypeName, List<AExpression> valueNodes, boolean isInitializer) {
        super(identifier, location);
        this.canonicalTypeName = Objects.requireNonNull(canonicalTypeName);
        this.valueNodes = Collections.unmodifiableList(Objects.requireNonNull(valueNodes));
        this.isInitializer = isInitializer;
    }

    public String getCanonicalTypeName() {
        return this.canonicalTypeName;
    }

    public List<AExpression> getValueNodes() {
        return this.valueNodes;
    }

    public boolean isInitializer() {
        return this.isInitializer;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitNewArray(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        for (AExpression valueNode : this.valueNodes) {
            valueNode.visit(userTreeVisitor, scope);
        }
    }
}

