#!/bin/sh
#
# This file is part of sudognu.
#
# Copyright (C) 2007-2009 Jens Baaran, Germany.
#
# THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED
# BY APPLICABLE LAW.
#
# See the GPL Version 2 (http://www.gnu.org/licenses/gpl.html)
# or the file COPYING for details
# ******************************************************************************
set -f
TMPDIR=./tmp
CGISUDOKU=/usr/local/bin/sudognu

cat <<- END
	Content-type: text/html
	
	<html>
	<head>
	  <title>Printing sudokus ...</title>
	  <style type="text/css">
		body      { background-color:white; color:black; margin-top:4ex; }
	  </style>
	</head>
	<body>
END

PARAM_STRING=`echo $QUERY_STRING | egrep -o 'sudokus=[[:digit:]]+'`
SUDOKUS=`echo $PARAM_STRING | egrep -o '=[[:digit:]]+' | cut -b 2-`

echo "<p>"
rm -f `find $TMPDIR -mmin +60 -name *.pdf`
rm -f `find $TMPDIR -mmin +60 -name *.svg`
fn=$TMPDIR/`date +%M-%S`
echo "</p>"

echo "<h3>Sudokus are being solved and rated</h3>"
echo "<pre>"
echo $SUDOKUS | $CGISUDOKU -p -o "$fn"
echo "</pre>"

echo "<h3>Sudokus</h3>"
echo "<p><a href=\"$fn.pdf\">pdf file with sudokus</a></p>"
echo "<p><a href=\"$fn.svg\">svg file with sudokus</a></p>"

echo "</body>"
echo "</html>"

