function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { memo, useCallback, useMemo, useState, useEffect } from 'react';
import { isEqual } from 'lodash';
import { useKibana } from '../../../../kibana_react/public';
import { APP_NAME } from '../visualize_constants';
import { getTopNavConfig } from '../utils';

var TopNav = function TopNav(_ref) {
  var currentAppState = _ref.currentAppState,
      isChromeVisible = _ref.isChromeVisible,
      isEmbeddableRendered = _ref.isEmbeddableRendered,
      hasUnsavedChanges = _ref.hasUnsavedChanges,
      setHasUnsavedChanges = _ref.setHasUnsavedChanges,
      hasUnappliedChanges = _ref.hasUnappliedChanges,
      originatingApp = _ref.originatingApp,
      setOriginatingApp = _ref.setOriginatingApp,
      savedVisInstance = _ref.savedVisInstance,
      stateContainer = _ref.stateContainer,
      visualizationIdFromUrl = _ref.visualizationIdFromUrl;

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var TopNavMenu = services.navigation.ui.TopNavMenu;
  var embeddableHandler = savedVisInstance.embeddableHandler,
      vis = savedVisInstance.vis;

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      inspectorSession = _useState2[0],
      setInspectorSession = _useState2[1];

  var openInspector = useCallback(function () {
    var session = embeddableHandler.openInspector();
    setInspectorSession(session);
  }, [embeddableHandler]);
  var updateQuery = useCallback(function (_ref2) {
    var query = _ref2.query;

    if (!isEqual(currentAppState.query, query)) {
      stateContainer.transitions.set('query', query || currentAppState.query);
    } else {
      savedVisInstance.embeddableHandler.reload();
    }
  }, [currentAppState.query, savedVisInstance.embeddableHandler, stateContainer.transitions]);
  var config = useMemo(function () {
    if (isEmbeddableRendered) {
      return getTopNavConfig({
        hasUnsavedChanges: hasUnsavedChanges,
        setHasUnsavedChanges: setHasUnsavedChanges,
        hasUnappliedChanges: hasUnappliedChanges,
        openInspector: openInspector,
        originatingApp: originatingApp,
        setOriginatingApp: setOriginatingApp,
        savedVisInstance: savedVisInstance,
        stateContainer: stateContainer,
        visualizationIdFromUrl: visualizationIdFromUrl
      }, services);
    }
  }, [isEmbeddableRendered, hasUnsavedChanges, setHasUnsavedChanges, hasUnappliedChanges, openInspector, originatingApp, setOriginatingApp, savedVisInstance, stateContainer, visualizationIdFromUrl, services]);

  var _useState3 = useState(vis.data.indexPattern),
      _useState4 = _slicedToArray(_useState3, 2),
      indexPattern = _useState4[0],
      setIndexPattern = _useState4[1];

  var showDatePicker = function showDatePicker() {
    // tsvb loads without an indexPattern initially (TODO investigate).
    // hide timefilter only if timeFieldName is explicitly undefined.
    var hasTimeField = vis.data.indexPattern ? !!vis.data.indexPattern.timeFieldName : true;
    return vis.type.options.showTimePicker && hasTimeField;
  };

  var showFilterBar = vis.type.options.showFilterBar;
  var showQueryInput = vis.type.requiresSearch && vis.type.options.showQueryBar;
  useEffect(function () {
    return function () {
      if (inspectorSession) {
        // Close the inspector if this scope is destroyed (e.g. because the user navigates away).
        inspectorSession.close();
      }
    };
  }, [inspectorSession]);
  useEffect(function () {
    if (!vis.data.indexPattern) {
      services.data.indexPatterns.getDefault().then(function (index) {
        if (index) {
          setIndexPattern(index);
        }
      });
    }
  }, [services.data.indexPatterns, vis.data.indexPattern]);
  return isChromeVisible ?
  /*#__PURE__*/

  /**
   * Most visualizations have all search bar components enabled.
   * Some visualizations have fewer options, but all visualizations have the search bar.
   * That's is why the showSearchBar prop is set.
   * All visualizations also have the timepicker\autorefresh component,
   * it is enabled by default in the TopNavMenu component.
   */
  React.createElement(TopNavMenu, {
    appName: APP_NAME,
    config: config,
    query: currentAppState.query,
    onQuerySubmit: updateQuery,
    savedQueryId: currentAppState.savedQuery,
    onSavedQueryIdChange: stateContainer.transitions.updateSavedQuery,
    indexPatterns: indexPattern ? [indexPattern] : undefined,
    screenTitle: vis.title,
    showAutoRefreshOnly: !showDatePicker(),
    showDatePicker: showDatePicker(),
    showFilterBar: showFilterBar,
    showQueryInput: showQueryInput,
    showSaveQuery: services.visualizeCapabilities.saveQuery,
    showSearchBar: true,
    useDefaultBehaviors: true
  }) : showFilterBar ?
  /*#__PURE__*/

  /**
   * The top nav is hidden in embed mode, but the filter bar must still be present so
   * we show the filter bar on its own here if the chrome is not visible.
   */
  React.createElement(TopNavMenu, {
    appName: APP_NAME,
    indexPatterns: indexPattern ? [indexPattern] : undefined,
    showSearchBar: true,
    showSaveQuery: false,
    showDatePicker: false,
    showQueryInput: false
  }) : null;
};

export var VisualizeTopNav = /*#__PURE__*/memo(TopNav);