function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect, useCallback, useMemo } from 'react';
import { cloneDeep, uniq, get } from 'lodash';
import { EuiSpacer } from '@elastic/eui';
import { SeriesPanel } from './series_panel';
import { CategoryAxisPanel } from './category_axis_panel';
import { ValueAxesPanel } from './value_axes_panel';
import { makeSerie, isAxisHorizontal, countNextAxisNumber, getUpdatedAxisName, mapPositionOpposite, mapPosition } from './utils';
var VALUE_AXIS_PREFIX = 'ValueAxis-';

function MetricsAxisOptions(props) {
  var stateParams = props.stateParams,
      setValue = props.setValue,
      aggs = props.aggs,
      vis = props.vis,
      isTabSelected = props.isTabSelected;

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      isCategoryAxisHorizontal = _useState2[0],
      setIsCategoryAxisHorizontal = _useState2[1];

  var setParamByIndex = useCallback(function (axesName, index, paramName, value) {
    var items = stateParams[axesName];

    var array = _toConsumableArray(items);

    array[index] = _objectSpread(_objectSpread({}, array[index]), {}, _defineProperty({}, paramName, value));
    setValue(axesName, array);
  }, [stateParams, setValue]);
  var setCategoryAxis = useCallback(function (value) {
    var categoryAxes = _toConsumableArray(stateParams.categoryAxes);

    categoryAxes[0] = value;
    setValue('categoryAxes', categoryAxes);
  }, [setValue, stateParams.categoryAxes]); // stores previous aggs' custom labels

  var _useState3 = useState({}),
      _useState4 = _slicedToArray(_useState3, 2),
      lastCustomLabels = _useState4[0],
      setLastCustomLabels = _useState4[1]; // stores previous aggs' field and type


  var _useState5 = useState({}),
      _useState6 = _slicedToArray(_useState5, 2),
      lastSeriesAgg = _useState6[0],
      setLastSeriesAgg = _useState6[1];

  var updateAxisTitle = useCallback(function (seriesParams) {
    var series = seriesParams || stateParams.seriesParams;
    var isAxesChanged = false;
    var lastValuesChanged = false;

    var lastLabels = _objectSpread({}, lastCustomLabels);

    var lastMatchingSeriesAgg = _objectSpread({}, lastSeriesAgg);

    var axes = stateParams.valueAxes.map(function (axis, axisNumber) {
      var newCustomLabel = '';
      var updatedAxis;
      var matchingSeries = [];
      series.forEach(function (serie, seriesIndex) {
        if (axisNumber === 0 && !serie.valueAxis || serie.valueAxis === axis.id) {
          var aggByIndex = aggs.bySchemaName('metric')[seriesIndex];
          matchingSeries.push(aggByIndex);
        }
      });

      if (matchingSeries.length === 1) {
        // if several series matches to the axis, axis title is set according to the first serie.
        newCustomLabel = matchingSeries[0].makeLabel();
      }

      if (lastCustomLabels[axis.id] !== newCustomLabel && newCustomLabel !== '') {
        var lastSeriesAggType = get(lastSeriesAgg, "".concat(matchingSeries[0].id, ".type"));
        var lastSeriesAggField = get(lastSeriesAgg, "".concat(matchingSeries[0].id, ".field"));
        var matchingSeriesAggType = get(matchingSeries, '[0]type.name', '');
        var matchingSeriesAggField = get(matchingSeries, '[0]params.field.name', '');
        var aggTypeIsChanged = lastSeriesAggType !== matchingSeriesAggType;
        var aggFieldIsChanged = lastSeriesAggField !== matchingSeriesAggField;
        lastMatchingSeriesAgg[matchingSeries[0].id] = {
          type: matchingSeriesAggType,
          field: matchingSeriesAggField
        };
        lastLabels[axis.id] = newCustomLabel;
        lastValuesChanged = true;

        if (Object.keys(lastCustomLabels).length !== 0 && (aggTypeIsChanged || aggFieldIsChanged || axis.title.text === '' || lastCustomLabels[axis.id] === axis.title.text) && newCustomLabel !== axis.title.text) {
          // Override axis title with new custom label
          updatedAxis = _objectSpread(_objectSpread({}, axis), {}, {
            title: _objectSpread(_objectSpread({}, axis.title), {}, {
              text: newCustomLabel
            })
          });
          isAxesChanged = true;
        }
      }

      return updatedAxis || axis;
    });

    if (isAxesChanged) {
      setValue('valueAxes', axes);
    }

    if (lastValuesChanged) {
      setLastSeriesAgg(lastMatchingSeriesAgg);
      setLastCustomLabels(lastLabels);
    }
  }, [aggs, lastCustomLabels, lastSeriesAgg, setValue, stateParams.seriesParams, stateParams.valueAxes]);
  var onValueAxisPositionChanged = useCallback(function (index, value) {
    var valueAxes = _toConsumableArray(stateParams.valueAxes);

    var name = getUpdatedAxisName(value, valueAxes);
    valueAxes[index] = _objectSpread(_objectSpread({}, valueAxes[index]), {}, {
      name: name,
      position: value
    });
    setValue('valueAxes', valueAxes);
  }, [stateParams.valueAxes, setValue]);
  var onCategoryAxisPositionChanged = useCallback(function (chartPosition) {
    var isChartHorizontal = isAxisHorizontal(chartPosition);
    setIsCategoryAxisHorizontal(isAxisHorizontal(chartPosition));
    stateParams.valueAxes.forEach(function (axis, index) {
      if (isAxisHorizontal(axis.position) === isChartHorizontal) {
        var position = mapPosition(axis.position);
        onValueAxisPositionChanged(index, position);
      }
    });
  }, [stateParams.valueAxes, onValueAxisPositionChanged]);
  var addValueAxis = useCallback(function () {
    var nextAxisIdNumber = stateParams.valueAxes.reduce(countNextAxisNumber(VALUE_AXIS_PREFIX), 1);
    var newAxis = cloneDeep(stateParams.valueAxes[0]);
    newAxis.id = VALUE_AXIS_PREFIX + nextAxisIdNumber;
    newAxis.position = mapPositionOpposite(newAxis.position);
    newAxis.name = getUpdatedAxisName(newAxis.position, stateParams.valueAxes);
    setValue('valueAxes', [].concat(_toConsumableArray(stateParams.valueAxes), [newAxis]));
    return newAxis;
  }, [stateParams.valueAxes, setValue]);
  var removeValueAxis = useCallback(function (axis) {
    var newValueAxes = stateParams.valueAxes.filter(function (valAxis) {
      return valAxis.id !== axis.id;
    });
    setValue('valueAxes', newValueAxes);
    var isSeriesUpdated = false;
    var series = stateParams.seriesParams.map(function (ser) {
      if (axis.id === ser.valueAxis) {
        isSeriesUpdated = true;
        return _objectSpread(_objectSpread({}, ser), {}, {
          valueAxis: newValueAxes[0].id
        });
      }

      return ser;
    });

    if (isSeriesUpdated) {
      // if seriesParams have valueAxis equals to removed one, then we reset it to the first valueAxis
      setValue('seriesParams', series);
    }

    if (stateParams.grid.valueAxis === axis.id) {
      // reset Y-axis grid lines setting
      setValue('grid', _objectSpread(_objectSpread({}, stateParams.grid), {}, {
        valueAxis: undefined
      }));
    }
  }, [stateParams.seriesParams, stateParams.valueAxes, setValue, stateParams.grid]);
  var changeValueAxis = useCallback(function (index, paramName, selectedValueAxis) {
    var newValueAxis = selectedValueAxis;

    if (selectedValueAxis === 'new') {
      var axis = addValueAxis();
      newValueAxis = axis.id;
    }

    setParamByIndex('seriesParams', index, paramName, newValueAxis);
    updateAxisTitle();
  }, [addValueAxis, setParamByIndex, updateAxisTitle]);
  var schemaName = vis.type.schemas.metrics[0].name;
  var metrics = useMemo(function () {
    return aggs.bySchemaName(schemaName);
  }, [schemaName, aggs]);
  var firstValueAxesId = stateParams.valueAxes[0].id;
  useEffect(function () {
    var updatedSeries = metrics.map(function (agg) {
      var params = stateParams.seriesParams.find(function (param) {
        return param.data.id === agg.id;
      });
      var label = agg.makeLabel(); // update labels for existing params or create new one

      if (params) {
        return _objectSpread(_objectSpread({}, params), {}, {
          data: _objectSpread(_objectSpread({}, params.data), {}, {
            label: label
          })
        });
      } else {
        var series = makeSerie(agg.id, label, firstValueAxesId, stateParams.seriesParams[stateParams.seriesParams.length - 1]);
        return series;
      }
    });
    setValue('seriesParams', updatedSeries);
    updateAxisTitle(updatedSeries);
  }, [metrics, firstValueAxesId, setValue, stateParams.seriesParams, updateAxisTitle]);
  var visType = useMemo(function () {
    var types = uniq(stateParams.seriesParams.map(function (_ref) {
      var type = _ref.type;
      return type;
    }));
    return types.length === 1 ? types[0] : 'histogram';
  }, [stateParams.seriesParams]);
  useEffect(function () {
    vis.setState(_objectSpread(_objectSpread({}, vis.serialize()), {}, {
      type: visType
    }));
  }, [vis, visType]);
  return isTabSelected ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SeriesPanel, {
    changeValueAxis: changeValueAxis,
    setParamByIndex: setParamByIndex,
    seriesParams: stateParams.seriesParams,
    valueAxes: stateParams.valueAxes,
    vis: vis
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(ValueAxesPanel, {
    addValueAxis: addValueAxis,
    isCategoryAxisHorizontal: isCategoryAxisHorizontal,
    removeValueAxis: removeValueAxis,
    onValueAxisPositionChanged: onValueAxisPositionChanged,
    setParamByIndex: setParamByIndex,
    setMultipleValidity: props.setMultipleValidity,
    seriesParams: stateParams.seriesParams,
    valueAxes: stateParams.valueAxes,
    vis: vis
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(CategoryAxisPanel, {
    axis: stateParams.categoryAxes[0],
    onPositionChanged: onCategoryAxisPositionChanged,
    setCategoryAxis: setCategoryAxis,
    vis: vis
  })) : null;
}

export { MetricsAxisOptions };