function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useState } from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiFormRow, EuiSwitch } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { SavedObjectSaveModal } from '.';
export function SavedObjectSaveModalOrigin(props) {
  var _useState = useState(Boolean(props.originatingApp)),
      _useState2 = _slicedToArray(_useState, 2),
      returnToOriginMode = _useState2[0],
      setReturnToOriginMode = _useState2[1];

  var documentInfo = props.documentInfo;
  var returnLabel = i18n.translate('savedObjects.saveModalOrigin.returnToOriginLabel', {
    defaultMessage: 'Return'
  });
  var addLabel = i18n.translate('savedObjects.saveModalOrigin.addToOriginLabel', {
    defaultMessage: 'Add'
  });

  var getReturnToOriginSwitch = function getReturnToOriginSwitch(state) {
    if (!props.originatingApp) {
      return;
    }

    var origin = props.originatingApp; // TODO: Remove this after https://github.com/elastic/kibana/pull/63443

    if (origin.startsWith('kibana:')) {
      origin = origin.split(':')[1];
    }

    if (!state.copyOnSave || origin === 'dashboards' // dashboard supports adding a copied panel on save...
    ) {
        var originVerb = !documentInfo.id || state.copyOnSave ? addLabel : returnLabel;
        return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
          "data-test-subj": "returnToOriginModeSwitch",
          checked: returnToOriginMode,
          onChange: function onChange(event) {
            setReturnToOriginMode(event.target.checked);
          },
          label: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjects.saveModalOrigin.originAfterSavingSwitchLabel",
            defaultMessage: "{originVerb} to {origin} after saving",
            values: {
              originVerb: originVerb,
              origin: origin
            }
          })
        })));
      } else {
      setReturnToOriginMode(false);
    }
  };

  var onModalSave = function onModalSave(onSaveProps) {
    props.onSave(_objectSpread(_objectSpread({}, onSaveProps), {}, {
      returnToOrigin: returnToOriginMode
    }));
  };

  var confirmButtonLabel = returnToOriginMode ? i18n.translate('savedObjects.saveModalOrigin.saveAndReturnLabel', {
    defaultMessage: 'Save and return'
  }) : null;
  return /*#__PURE__*/React.createElement(SavedObjectSaveModal, {
    onSave: onModalSave,
    onClose: props.onClose,
    title: documentInfo.title,
    showCopyOnSave: documentInfo.id ? true : false,
    initialCopyOnSave: Boolean(documentInfo.id) && returnToOriginMode,
    confirmButtonLabel: confirmButtonLabel,
    objectType: props.objectType,
    options: getReturnToOriginSwitch,
    description: documentInfo.description,
    showDescription: true
  });
}