function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from 'react';
import { toMountPoint } from '../util';
export var createNotifications = function createNotifications(services) {
  var show = function show(_ref) {
    var title = _ref.title,
        body = _ref.body,
        color = _ref.color,
        iconType = _ref.iconType,
        toastLifeTimeMs = _ref.toastLifeTimeMs,
        onClose = _ref.onClose;

    if (!services.notifications) {
      throw new TypeError('Could not show notification as notifications service is not available.');
    }

    services.notifications.toasts.add({
      title: toMountPoint(title),
      text: toMountPoint( /*#__PURE__*/React.createElement(React.Fragment, null, body || null)),
      color: color,
      iconType: iconType,
      toastLifeTimeMs: toastLifeTimeMs,
      onClose: onClose
    });
  };

  var success = function success(input) {
    return show(_objectSpread({
      color: 'success',
      iconType: 'check'
    }, input));
  };

  var warning = function warning(input) {
    return show(_objectSpread({
      color: 'warning',
      iconType: 'help'
    }, input));
  };

  var danger = function danger(input) {
    return show(_objectSpread({
      color: 'danger',
      iconType: 'alert'
    }, input));
  };

  var notifications = {
    toasts: {
      show: show,
      success: success,
      warning: warning,
      danger: danger
    }
  };
  return notifications;
};