/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiCallOut, EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var ScriptingDisabledCallOut = function ScriptingDisabledCallOut(_ref) {
  var _ref$isVisible = _ref.isVisible,
      isVisible = _ref$isVisible === void 0 ? false : _ref$isVisible;
  return isVisible ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.disabledCallOutHeader",
      defaultMessage: "Scripting disabled",
      description: "Showing the status that scripting is disabled in Elasticsearch. Not an update message, that it JUST got disabled."
    }),
    color: "danger",
    iconType: "alert"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.disabledCallOutLabel",
    defaultMessage: "All inline scripting has been disabled in Elasticsearch. You must enable inline scripting for at least one language in order to use scripted fields in Kibana."
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  })) : null;
};
ScriptingDisabledCallOut.displayName = 'ScriptingDisabledCallOut';