function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiTitle, EuiFlexGroup, EuiFlexItem, EuiSpacer, EuiButton, EuiForm, EuiFormRow, EuiFieldText, EuiSwitch } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
export var Header = function Header(_ref) {
  var isInputInvalid = _ref.isInputInvalid,
      errors = _ref.errors,
      characterList = _ref.characterList,
      query = _ref.query,
      onQueryChanged = _ref.onQueryChanged,
      goToNextStep = _ref.goToNextStep,
      isNextStepDisabled = _ref.isNextStepDisabled,
      _ref$showSystemIndice = _ref.showSystemIndices,
      showSystemIndices = _ref$showSystemIndice === void 0 ? false : _ref$showSystemIndice,
      onChangeIncludingSystemIndices = _ref.onChangeIncludingSystemIndices,
      isIncludingSystemIndices = _ref.isIncludingSystemIndices,
      rest = _objectWithoutProperties(_ref, ["isInputInvalid", "errors", "characterList", "query", "onQueryChanged", "goToNextStep", "isNextStepDisabled", "showSystemIndices", "onChangeIncludingSystemIndices", "isIncludingSystemIndices"]);

  return /*#__PURE__*/React.createElement("div", rest, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "s"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.stepHeader",
    defaultMessage: "Step 1 of 2: Define index pattern"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiForm, {
    isInvalid: isInputInvalid
  }, /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.step.indexPatternLabel",
      defaultMessage: "Index pattern name"
    }),
    isInvalid: isInputInvalid,
    error: errors,
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.step.indexPattern.allowLabel",
      defaultMessage: "Use an asterisk ({asterisk}) to match multiple indices.",
      values: {
        asterisk: /*#__PURE__*/React.createElement("strong", null, "*")
      }
    }), ' ', /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.step.indexPattern.disallowLabel",
      defaultMessage: "Spaces and the characters {characterList} are not allowed.",
      values: {
        characterList: /*#__PURE__*/React.createElement("strong", null, characterList)
      }
    }))
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    name: "indexPattern",
    placeholder: i18n.translate('indexPatternManagement.createIndexPattern.step.indexPatternPlaceholder', {
      defaultMessage: 'index-name-*'
    }),
    value: query,
    isInvalid: isInputInvalid,
    onChange: onQueryChanged,
    "data-test-subj": "createIndexPatternNameInput",
    fullWidth: true
  })), showSystemIndices ? /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.includeSystemIndicesToggleSwitchLabel",
      defaultMessage: "Include system and hidden indices"
    }),
    id: "checkboxShowSystemIndices",
    checked: isIncludingSystemIndices,
    onChange: onChangeIncludingSystemIndices
  })) : null)), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/React.createElement(EuiButton, {
    fill: true,
    iconSide: "right",
    iconType: "arrowRight",
    onClick: function onClick() {
      return goToNextStep(query);
    },
    isDisabled: isNextStepDisabled,
    "data-test-subj": "createIndexPatternGoToStep2Button"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.step.nextStepButton",
    defaultMessage: "Next step"
  }))))));
};