function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiContextMenu, EuiPopover } from '@elastic/eui';
import classNames from 'classnames';
import React, { useState, useEffect } from 'react';
import { FilterEditor } from './filter_editor';
import { FilterView } from './filter_view';
import { isFilterPinned, getDisplayValueFromFilter, toggleFilterNegated, toggleFilterPinned, toggleFilterDisabled, getIndexPatternFromFilter } from '../../../common';
import { getIndexPatterns } from '../../services';
var FILTER_ITEM_OK = '';
var FILTER_ITEM_WARNING = 'warn';
var FILTER_ITEM_ERROR = 'error';
export function FilterItem(props) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var _useState3 = useState(undefined),
      _useState4 = _slicedToArray(_useState3, 2),
      indexPatternExists = _useState4[0],
      setIndexPatternExists = _useState4[1];

  var id = props.id,
      filter = props.filter,
      indexPatterns = props.indexPatterns;
  useEffect(function () {
    var index = props.filter.meta.index;

    if (index) {
      getIndexPatterns().get(index).then(function (indexPattern) {
        setIndexPatternExists(!!indexPattern);
      }).catch(function () {
        setIndexPatternExists(false);
      });
    } else {
      // Allow filters without an index pattern and don't validate them.
      setIndexPatternExists(true);
    }
  }, [props.filter.meta.index]);

  function handleBadgeClick(e) {
    if (e.shiftKey) {
      onToggleDisabled();
    } else {
      setIsPopoverOpen(!isPopoverOpen);
    }
  }

  function onSubmit(f) {
    setIsPopoverOpen(false);
    props.onUpdate(f);
  }

  function onTogglePinned() {
    var f = toggleFilterPinned(filter);
    props.onUpdate(f);
  }

  function onToggleNegated() {
    var f = toggleFilterNegated(filter);
    props.onUpdate(f);
  }

  function onToggleDisabled() {
    var f = toggleFilterDisabled(filter);
    props.onUpdate(f);
  }

  function isValidLabel(labelConfig) {
    return labelConfig.status === FILTER_ITEM_OK;
  }

  function isDisabled(labelConfig) {
    var disabled = filter.meta.disabled;
    return disabled || labelConfig.status === FILTER_ITEM_ERROR;
  }

  function getClasses(negate, labelConfig) {
    return classNames('globalFilterItem', {
      'globalFilterItem-isDisabled': isDisabled(labelConfig),
      'globalFilterItem-isError': labelConfig.status === FILTER_ITEM_ERROR,
      'globalFilterItem-isWarning': labelConfig.status === FILTER_ITEM_WARNING,
      'globalFilterItem-isPinned': isFilterPinned(filter),
      'globalFilterItem-isExcluded': negate
    }, props.className);
  }

  function getDataTestSubj(labelConfig) {
    var dataTestSubjKey = filter.meta.key ? "filter-key-".concat(filter.meta.key) : '';
    var dataTestSubjValue = filter.meta.value ? "filter-value-".concat(isValidLabel(labelConfig) ? labelConfig.title : labelConfig.status) : '';
    var dataTestSubjNegated = filter.meta.negate ? 'filter-negated' : '';
    var dataTestSubjDisabled = "filter-".concat(isDisabled(labelConfig) ? 'disabled' : 'enabled');
    var dataTestSubjPinned = "filter-".concat(isFilterPinned(filter) ? 'pinned' : 'unpinned');
    return "filter ".concat(dataTestSubjDisabled, " ").concat(dataTestSubjKey, " ").concat(dataTestSubjValue, " ").concat(dataTestSubjPinned, " ").concat(dataTestSubjNegated);
  }

  function getPanels() {
    var _filter$meta = filter.meta,
        negate = _filter$meta.negate,
        disabled = _filter$meta.disabled;
    return [{
      id: 0,
      items: [{
        name: isFilterPinned(filter) ? props.intl.formatMessage({
          id: 'data.filter.filterBar.unpinFilterButtonLabel',
          defaultMessage: 'Unpin'
        }) : props.intl.formatMessage({
          id: 'data.filter.filterBar.pinFilterButtonLabel',
          defaultMessage: 'Pin across all apps'
        }),
        icon: 'pin',
        onClick: function onClick() {
          setIsPopoverOpen(false);
          onTogglePinned();
        },
        'data-test-subj': 'pinFilter'
      }, {
        name: props.intl.formatMessage({
          id: 'data.filter.filterBar.editFilterButtonLabel',
          defaultMessage: 'Edit filter'
        }),
        icon: 'pencil',
        panel: 1,
        'data-test-subj': 'editFilter'
      }, {
        name: negate ? props.intl.formatMessage({
          id: 'data.filter.filterBar.includeFilterButtonLabel',
          defaultMessage: 'Include results'
        }) : props.intl.formatMessage({
          id: 'data.filter.filterBar.excludeFilterButtonLabel',
          defaultMessage: 'Exclude results'
        }),
        icon: negate ? 'plusInCircle' : 'minusInCircle',
        onClick: function onClick() {
          setIsPopoverOpen(false);
          onToggleNegated();
        },
        'data-test-subj': 'negateFilter'
      }, {
        name: disabled ? props.intl.formatMessage({
          id: 'data.filter.filterBar.enableFilterButtonLabel',
          defaultMessage: 'Re-enable'
        }) : props.intl.formatMessage({
          id: 'data.filter.filterBar.disableFilterButtonLabel',
          defaultMessage: 'Temporarily disable'
        }),
        icon: "".concat(disabled ? 'eye' : 'eyeClosed'),
        onClick: function onClick() {
          setIsPopoverOpen(false);
          onToggleDisabled();
        },
        'data-test-subj': 'disableFilter'
      }, {
        name: props.intl.formatMessage({
          id: 'data.filter.filterBar.deleteFilterButtonLabel',
          defaultMessage: 'Delete'
        }),
        icon: 'trash',
        onClick: function onClick() {
          setIsPopoverOpen(false);
          props.onRemove();
        },
        'data-test-subj': 'deleteFilter'
      }]
    }, {
      id: 1,
      width: 420,
      content: /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(FilterEditor, {
        filter: filter,
        indexPatterns: indexPatterns,
        onSubmit: onSubmit,
        onCancel: function onCancel() {
          setIsPopoverOpen(false);
        }
      }))
    }];
  }
  /**
   * Checks if filter field exists in any of the index patterns provided,
   * Because if so, a filter for the wrong index pattern may still be applied.
   * This function makes this behavior explicit, but it needs to be revised.
   */


  function isFilterApplicable() {
    var _filter$meta2;

    // Any filter is applicable if no index patterns were provided to FilterBar.
    if (!props.indexPatterns.length) return true;
    var ip = getIndexPatternFromFilter(filter, indexPatterns);
    if (ip) return true;
    var allFields = indexPatterns.map(function (indexPattern) {
      return indexPattern.fields.map(function (field) {
        return field.name;
      });
    });
    var flatFields = allFields.reduce(function (acc, it) {
      return [].concat(_toConsumableArray(acc), _toConsumableArray(it));
    }, []);
    return flatFields.includes(((_filter$meta2 = filter.meta) === null || _filter$meta2 === void 0 ? void 0 : _filter$meta2.key) || '');
  }

  function getValueLabel() {
    var label = {
      title: '',
      message: '',
      status: FILTER_ITEM_OK
    };

    if (indexPatternExists === false) {
      label.status = FILTER_ITEM_ERROR;
      label.title = props.intl.formatMessage({
        id: 'data.filter.filterBar.labelErrorText',
        defaultMessage: "Error"
      });
      label.message = props.intl.formatMessage({
        id: 'data.filter.filterBar.labelErrorInfo',
        defaultMessage: 'Index pattern {indexPattern} not found'
      }, {
        indexPattern: filter.meta.index
      });
    } else if (isFilterApplicable()) {
      try {
        label.title = getDisplayValueFromFilter(filter, indexPatterns);
      } catch (e) {
        label.status = FILTER_ITEM_ERROR;
        label.title = props.intl.formatMessage({
          id: 'data.filter.filterBar.labelErrorText',
          defaultMessage: "Error"
        });
        label.message = e.message;
      }
    } else {
      label.status = FILTER_ITEM_WARNING;
      label.title = props.intl.formatMessage({
        id: 'data.filter.filterBar.labelWarningText',
        defaultMessage: "Warning"
      });
      label.message = props.intl.formatMessage({
        id: 'data.filter.filterBar.labelWarningInfo',
        defaultMessage: 'Field {fieldName} does not exist in current view'
      }, {
        fieldName: filter.meta.key
      });
    }

    return label;
  } // Don't render until we know if the index pattern is valid


  if (indexPatternExists === undefined) return null;
  var valueLabelConfig = getValueLabel(); // Disable errored filters and re-render

  if (valueLabelConfig.status === FILTER_ITEM_ERROR && !filter.meta.disabled) {
    filter.meta.disabled = true;
    props.onUpdate(filter);
    return null;
  }

  var badge = /*#__PURE__*/React.createElement(FilterView, {
    filter: filter,
    valueLabel: valueLabelConfig.title,
    errorMessage: valueLabelConfig.message,
    className: getClasses(filter.meta.negate, valueLabelConfig),
    iconOnClick: function iconOnClick() {
      return props.onRemove();
    },
    onClick: handleBadgeClick,
    "data-test-subj": getDataTestSubj(valueLabelConfig)
  });
  return /*#__PURE__*/React.createElement(EuiPopover, {
    id: "popoverFor_filter".concat(id),
    className: "globalFilterItem__popover",
    anchorClassName: "globalFilterItem__popoverAnchor",
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setIsPopoverOpen(false);
    },
    button: badge,
    anchorPosition: "downLeft",
    withTitle: true,
    panelPaddingSize: "none"
  }, /*#__PURE__*/React.createElement(EuiContextMenu, {
    initialPanelId: 0,
    panels: getPanels()
  }));
}