function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiHorizontalRule, EuiNavDrawer, EuiNavDrawerGroup } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React from 'react';
import { useObservable } from 'react-use';
import { createEuiListItem, createRecentNavLink } from './nav_link';
import { RecentLinks } from './recent_links';

function NavDrawerRenderer(_ref, ref) {
  var isLocked = _ref.isLocked,
      onIsLockedUpdate = _ref.onIsLockedUpdate,
      basePath = _ref.basePath,
      legacyMode = _ref.legacyMode,
      navigateToApp = _ref.navigateToApp,
      observables = _objectWithoutProperties(_ref, ["isLocked", "onIsLockedUpdate", "basePath", "legacyMode", "navigateToApp"]);

  var appId = useObservable(observables.appId$, '');
  var navLinks = useObservable(observables.navLinks$, []).filter(function (link) {
    return !link.hidden;
  });
  var recentNavLinks = useObservable(observables.recentlyAccessed$, []).map(function (link) {
    return createRecentNavLink(link, navLinks, basePath);
  });
  return /*#__PURE__*/React.createElement(EuiNavDrawer, {
    ref: ref,
    "data-test-subj": "navDrawer",
    isLocked: isLocked,
    onIsLockedUpdate: onIsLockedUpdate,
    "aria-label": i18n.translate('core.ui.primaryNav.screenReaderLabel', {
      defaultMessage: 'Primary'
    })
  }, RecentLinks({
    recentNavLinks: recentNavLinks
  }), /*#__PURE__*/React.createElement(EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/React.createElement(EuiNavDrawerGroup, {
    "data-test-subj": "navDrawerAppsMenu",
    listItems: navLinks.map(function (link) {
      return createEuiListItem({
        link: link,
        legacyMode: legacyMode,
        appId: appId,
        basePath: basePath,
        navigateToApp: navigateToApp,
        dataTestSubj: 'navDrawerAppsMenuLink'
      });
    }),
    "aria-label": i18n.translate('core.ui.primaryNavList.screenReaderLabel', {
      defaultMessage: 'Primary navigation links'
    })
  }));
}

export var NavDrawer = /*#__PURE__*/React.forwardRef(NavDrawerRenderer);