function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useLayoutEffect, useRef, useState } from 'react';
import { EuiLoadingSpinner } from '@elastic/eui';
import { AppStatus } from '../types';
import { AppNotFound } from './app_not_found_screen';
import './app_container.scss';
export var AppContainer = function AppContainer(_ref) {
  var mounter = _ref.mounter,
      appId = _ref.appId,
      appPath = _ref.appPath,
      setAppLeaveHandler = _ref.setAppLeaveHandler,
      createScopedHistory = _ref.createScopedHistory,
      appStatus = _ref.appStatus,
      setIsMounting = _ref.setIsMounting;

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      showSpinner = _useState2[0],
      setShowSpinner = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      appNotFound = _useState4[0],
      setAppNotFound = _useState4[1];

  var elementRef = useRef(null);
  var unmountRef = useRef(null);
  useLayoutEffect(function () {
    var unmount = function unmount() {
      if (unmountRef.current) {
        unmountRef.current();
        unmountRef.current = null;
      }
    };

    if (!mounter || appStatus !== AppStatus.accessible) {
      return setAppNotFound(true);
    }

    setAppNotFound(false);
    setIsMounting(true);

    if (mounter.unmountBeforeMounting) {
      unmount();
    }

    var mount = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                setShowSpinner(true);
                _context.prev = 1;
                _context.next = 4;
                return mounter.mount({
                  appBasePath: mounter.appBasePath,
                  history: createScopedHistory(appPath),
                  element: elementRef.current,
                  onAppLeave: function onAppLeave(handler) {
                    return setAppLeaveHandler(appId, handler);
                  }
                });

              case 4:
                _context.t0 = _context.sent;

                if (_context.t0) {
                  _context.next = 7;
                  break;
                }

                _context.t0 = null;

              case 7:
                unmountRef.current = _context.t0;
                _context.next = 13;
                break;

              case 10:
                _context.prev = 10;
                _context.t1 = _context["catch"](1);
                // TODO: add error UI
                // eslint-disable-next-line no-console
                console.error(_context.t1);

              case 13:
                _context.prev = 13;
                setShowSpinner(false);
                setIsMounting(false);
                return _context.finish(13);

              case 17:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[1, 10, 13, 17]]);
      }));

      return function mount() {
        return _ref2.apply(this, arguments);
      };
    }();

    mount();
    return unmount;
  }, [appId, appStatus, mounter, createScopedHistory, setAppLeaveHandler, appPath, setIsMounting]);
  return /*#__PURE__*/React.createElement(Fragment, null, appNotFound && /*#__PURE__*/React.createElement(AppNotFound, null), showSpinner && /*#__PURE__*/React.createElement("div", {
    className: "appContainer__loading"
  }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
    size: "l"
  })), /*#__PURE__*/React.createElement("div", {
    key: appId,
    ref: elementRef
  }));
};