(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/etc#libcrypto-error::t
    (make-struct-type
     'std/crypto/etc#libcrypto-error::t
     error::t
     '0
     'libcrypto-error
     '()
     ':init!
     '()))
  (define std/crypto/etc#libcrypto-error?
    (make-struct-predicate std/crypto/etc#libcrypto-error::t))
  (define std/crypto/etc#make-libcrypto-error
    (lambda _$args116876_
      (apply make-struct-instance
             std/crypto/etc#libcrypto-error::t
             _$args116876_)))
  (define std/crypto/etc#libcrypto-error:::init!
    (lambda (_self116863_ _errno116864_ _irritants116865_)
      (if (##fx< '3 (##vector-length _self116863_))
          (begin
            (##vector-set!
             _self116863_
             '1
             (let ((_$e116867_
                    (std/crypto/libcrypto#ERR_reason_error_string
                     _errno116864_)))
               (if _$e116867_ _$e116867_ '"Unknown error")))
            (##vector-set!
             _self116863_
             '2
             (cons _errno116864_ _irritants116865_))
            (##vector-set!
             _self116863_
             '3
             (string-append
              (let ((_$e116870_
                     (std/crypto/libcrypto#ERR_lib_error_string
                      _errno116864_)))
                (if _$e116870_ _$e116870_ '"?"))
              '":"
              (let ((_$e116873_
                     (std/crypto/libcrypto#ERR_func_error_string
                      _errno116864_)))
                (if _$e116873_ _$e116873_ '"?")))))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self116863_))))
  (bind-method!
   std/crypto/etc#libcrypto-error::t
   ':init!
   std/crypto/etc#libcrypto-error:::init!
   '#f)
  (define std/crypto/etc#libcrypto-error::display-exception
    (lambda (_self116738_ _port116739_)
      (std/format#fprintf
       _port116739_
       '"Libcrypto error [~a]: ~a ~a~n"
       (error-trace _self116738_)
       (error-message _self116738_)
       (error-irritants _self116738_))))
  (bind-method!
   std/crypto/etc#libcrypto-error::t
   'display-exception
   std/crypto/etc#libcrypto-error::display-exception
   '#f)
  (define std/crypto/etc#raise-libcrypto-error
    (lambda _irritants116614_
      (raise (make-struct-instance
              std/crypto/etc#libcrypto-error::t
              (std/crypto/libcrypto#ERR_get_error)
              _irritants116614_))))
  (define std/crypto/etc#call-with-binary-input
    (lambda (_proc116610_ _in116611_ . _args116612_)
      (if (u8vector? _in116611_)
          (apply std/crypto/etc#call-with-binary-input-u8vector
                 _proc116610_
                 _in116611_
                 _args116612_)
          (if (string? _in116611_)
              (apply std/crypto/etc#call-with-binary-input-string
                     _proc116610_
                     _in116611_
                     _args116612_)
              (if (input-port? _in116611_)
                  (apply std/crypto/etc#call-with-binary-input-port
                         _proc116610_
                         _in116611_
                         _args116612_)
                  (error '"Unexpected input source" _in116611_))))))
  (define std/crypto/etc#call-with-binary-input-u8vector__0
    (lambda (_proc116598_ _in116599_)
      (_proc116598_ _in116599_ '0 (##u8vector-length _in116599_))))
  (define std/crypto/etc#call-with-binary-input-u8vector__1
    (lambda (_proc116601_ _in116602_ _start116603_)
      (_proc116601_ _in116602_ _start116603_ (##u8vector-length _in116602_))))
  (define std/crypto/etc#call-with-binary-input-u8vector__2
    (lambda (_proc116605_ _in116606_ _start116607_ _end116608_)
      (_proc116605_ _in116606_ _start116607_ _end116608_)))
  (define std/crypto/etc#call-with-binary-input-u8vector
    (lambda _g116879_
      (let ((_g116878_ (length _g116879_)))
        (cond ((##fx= _g116878_ 2)
               (apply std/crypto/etc#call-with-binary-input-u8vector__0
                      _g116879_))
              ((##fx= _g116878_ 3)
               (apply std/crypto/etc#call-with-binary-input-u8vector__1
                      _g116879_))
              ((##fx= _g116878_ 4)
               (apply std/crypto/etc#call-with-binary-input-u8vector__2
                      _g116879_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-u8vector
                _g116879_))))))
  (define std/crypto/etc#call-with-binary-input-string__0
    (lambda (_proc116586_ _in116587_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc116586_
       (std/text/utf8#string->utf8__0 _in116587_))))
  (define std/crypto/etc#call-with-binary-input-string__1
    (lambda (_proc116589_ _in116590_ _start116591_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc116589_
       (std/text/utf8#utf8-encode
        _in116590_
        _start116591_
        (##string-length _in116590_)))))
  (define std/crypto/etc#call-with-binary-input-string__2
    (lambda (_proc116593_ _in116594_ _start116595_ _end116596_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc116593_
       (std/text/utf8#utf8-encode _in116594_ _start116595_ _end116596_))))
  (define std/crypto/etc#call-with-binary-input-string
    (lambda _g116881_
      (let ((_g116880_ (length _g116881_)))
        (cond ((##fx= _g116880_ 2)
               (apply std/crypto/etc#call-with-binary-input-string__0
                      _g116881_))
              ((##fx= _g116880_ 3)
               (apply std/crypto/etc#call-with-binary-input-string__1
                      _g116881_))
              ((##fx= _g116880_ 4)
               (apply std/crypto/etc#call-with-binary-input-string__2
                      _g116881_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-string
                _g116881_))))))
  (define std/crypto/etc#call-with-binary-input-port__%
    (lambda (_proc116570_ _in116571_ _fill?116572_)
      (if (macro-byte-input-port? _in116571_)
          (std/crypto/etc#call-with-binary-input-byte-port
           _proc116570_
           _in116571_
           _fill?116572_)
          (if (macro-character-input-port? _in116571_)
              (std/crypto/etc#call-with-binary-input-character-port
               _proc116570_
               _in116571_
               _fill?116572_)
              (error '"Unusable input-port; need a character or byte port"
                     _in116571_)))))
  (define std/crypto/etc#call-with-binary-input-port__0
    (lambda (_proc116577_ _in116578_)
      (let ((_fill?116580_ '#t))
        (std/crypto/etc#call-with-binary-input-port__%
         _proc116577_
         _in116578_
         _fill?116580_))))
  (define std/crypto/etc#call-with-binary-input-port
    (lambda _g116883_
      (let ((_g116882_ (length _g116883_)))
        (cond ((##fx= _g116882_ 2)
               (apply std/crypto/etc#call-with-binary-input-port__0 _g116883_))
              ((##fx= _g116882_ 3)
               (apply std/crypto/etc#call-with-binary-input-port__% _g116883_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-port
                _g116883_))))))
  (define std/crypto/etc#call-with-binary-input-byte-port
    (lambda (_proc116555_ _in116556_ _fill?116557_)
      (let ((_bytes116559_
             (std/crypto/etc#drain-input-character-buffer _in116556_)))
        (if _bytes116559_
            (_proc116555_ _bytes116559_ '0 (##u8vector-length _bytes116559_))
            '#!void))
      (let ((_buf116561_ (##make-u8vector '1024))
            (_need116562_ (if _fill?116557_ '1 absent-obj)))
        (let _lp116564_ ()
          (let ((_rd116567_
                 (##read-subu8vector
                  _buf116561_
                  '0
                  '1024
                  _in116556_
                  _need116562_)))
            (if (##fxzero? _rd116567_)
                '#!void
                (begin
                  (_proc116555_ _buf116561_ '0 _rd116567_)
                  (_lp116564_))))))))
  (define std/crypto/etc#call-with-binary-input-character-port
    (lambda (_proc116541_ _in116542_ _fill?116543_)
      (let ((_buf116545_ (##make-string '512))
            (_need116546_ (if _fill?116543_ '1 absent-obj)))
        (let _lp116548_ ()
          (let ((_rd116551_
                 (##read-substring
                  _buf116545_
                  '0
                  '512
                  _in116542_
                  _need116546_)))
            (if (##fxzero? _rd116551_)
                '#!void
                (let ((_bytes116553_
                       (std/text/utf8#utf8-encode _buf116545_ '0 _rd116551_)))
                  (_proc116541_
                   _bytes116553_
                   '0
                   (##u8vector-length _bytes116553_))
                  (_lp116548_))))))))
  (define std/crypto/etc#drain-input-character-buffer
    (lambda (_port116536_)
      (gerbil/gambit/threads#with-lock
       (macro-port-mutex _port116536_)
       (lambda ()
         (if (##fx< (macro-character-port-rlo _port116536_)
                    (macro-character-port-rhi _port116536_))
             (let ((_buf116539_
                    (std/text/utf8#utf8-encode
                     (macro-character-port-rbuf _port116536_)
                     (macro-character-port-rlo _port116536_)
                     (macro-character-port-rhi _port116536_))))
               (macro-character-port-rlo-set!
                _port116536_
                (macro-character-port-rhi _port116536_))
               _buf116539_)
             '#f)))))
  (define std/crypto/etc#*urandom* (open-input-file '"/dev/urandom"))
  (define std/crypto/etc#random-bytes
    (lambda (_len116532_)
      (let ((_bytes116534_ (make-u8vector _len116532_)))
        (std/crypto/etc#random-bytes!__% _bytes116534_ '0 _len116532_)
        _bytes116534_)))
  (define std/crypto/etc#random-bytes!__%
    (lambda (_bytes116508_ _start116509_ _end116510_)
      (let ((_count116512_
             (read-subu8vector
              _bytes116508_
              _start116509_
              _end116510_
              std/crypto/etc#*urandom*)))
        (if (eq? _count116512_ (##fx- _end116510_ _start116509_))
            '#!void
            (error '"Could not read enough random bytes"
                   _count116512_
                   _start116509_
                   _end116510_)))))
  (define std/crypto/etc#random-bytes!__0
    (lambda (_bytes116517_)
      (let* ((_start116519_ '0) (_end116521_ (u8vector-length _bytes116517_)))
        (std/crypto/etc#random-bytes!__%
         _bytes116517_
         _start116519_
         _end116521_))))
  (define std/crypto/etc#random-bytes!__1
    (lambda (_bytes116523_ _start116524_)
      (let ((_end116526_ (u8vector-length _bytes116523_)))
        (std/crypto/etc#random-bytes!__%
         _bytes116523_
         _start116524_
         _end116526_))))
  (define std/crypto/etc#random-bytes!
    (lambda _g116885_
      (let ((_g116884_ (length _g116885_)))
        (cond ((##fx= _g116884_ 1)
               (apply std/crypto/etc#random-bytes!__0 _g116885_))
              ((##fx= _g116884_ 2)
               (apply std/crypto/etc#random-bytes!__1 _g116885_))
              ((##fx= _g116884_ 3)
               (apply std/crypto/etc#random-bytes!__% _g116885_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#random-bytes!
                _g116885_)))))))
