// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESDraw_PerspectiveView_HeaderFile
#define _IGESDraw_PerspectiveView_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESDraw_PerspectiveView.hxx>

#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <gp_XYZ.hxx>
#include <gp_XY.hxx>
#include <IGESData_ViewKindEntity.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_IGESData_ViewKindEntity.hxx>
#include <Handle_IGESData_TransfEntity.hxx>
class Standard_OutOfRange;
class gp_XYZ;
class gp_XY;
class IGESData_ViewKindEntity;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class IGESData_TransfEntity;


//! defines IGESPerspectiveView, Type <410> Form <1>
//! in package IGESDraw
//!
//! Supports a perspective view.
//! Any geometric projection is defined by a view plane
//! and the projectors that pass through the view plane.
//! Projectors can be visualized as rays of light that
//! form an image by passing through the viewed object
//! and striking the view plane.
//! The projectors are defined via a point called the
//! Centre-of-Projection or the eye-point.
//! A perspective view is formed by all projectors that
//! emanate from the Centre-of-Projection and pass
//! through the view plane.
class IGESDraw_PerspectiveView : public IGESData_ViewKindEntity
{

public:

  
  Standard_EXPORT IGESDraw_PerspectiveView();
  
  //! This method is used to set the fields of the class
  //! PerspectiveView
  //! - aViewNumber         : The desired view
  //! - aScaleFactor        : Scale factor
  //! - aViewNormalVector   : View plane normal vector (model space)
  //! - aViewReferencePoint : View reference point     (model space)
  //! - aCenterOfProjection : Center Of Projection     (model space)
  //! - aViewUpVector       : View up vector           (model space)
  //! - aViewPlaneDistance  : View plane distance      (model space)
  //! - aTopLeft            : Top-left point of clipping window
  //! - aBottomRight        : Bottom-right point of clipping window
  //! - aDepthClip          : Depth clipping indicator
  //! - aBackPlaneDistance  : Distance of back clipping plane
  //! - aFrontPlaneDistance : Distance of front clipping plane
  Standard_EXPORT   void Init (const Standard_Integer aViewNumber, const Standard_Real aScaleFactor, const gp_XYZ& aViewNormalVector, const gp_XYZ& aViewReferencePoint, const gp_XYZ& aCenterOfProjection, const gp_XYZ& aViewUpVector, const Standard_Real aViewPlaneDistance, const gp_XY& aTopLeft, const gp_XY& aBottomRight, const Standard_Integer aDepthClip, const Standard_Real aBackPlaneDistance, const Standard_Real aFrontPlaneDistance) ;
  
  //! Returns True (for a single view)
  Standard_EXPORT   Standard_Boolean IsSingle()  const;
  
  //! Returns 1 (single view)
  Standard_EXPORT   Standard_Integer NbViews()  const;
  
  //! For a single view, returns <me> whatever <num>
  Standard_EXPORT   Handle(IGESData_ViewKindEntity) ViewItem (const Standard_Integer num)  const;
  
  //! returns the view number associated with <me>
  Standard_EXPORT   Standard_Integer ViewNumber()  const;
  
  //! returns the scale factor associated with <me>
  Standard_EXPORT   Standard_Real ScaleFactor()  const;
  
  //! returns the View plane normal vector (model space)
  Standard_EXPORT   gp_Vec ViewNormalVector()  const;
  
  //! returns the View reference point (model space)
  Standard_EXPORT   gp_Pnt ViewReferencePoint()  const;
  
  //! returns the Center Of Projection (model space)
  Standard_EXPORT   gp_Pnt CenterOfProjection()  const;
  
  //! returns the View up vector (model space)
  Standard_EXPORT   gp_Vec ViewUpVector()  const;
  
  //! returns the View plane distance (model space)
  Standard_EXPORT   Standard_Real ViewPlaneDistance()  const;
  
  //! returns the top left point of the clipping window
  Standard_EXPORT   gp_Pnt2d TopLeft()  const;
  
  //! returns the bottom right point of the clipping window
  Standard_EXPORT   gp_Pnt2d BottomRight()  const;
  
  //! returns the Depth clipping indicator
  //! 0 = No depth clipping
  //! 1 = Back clipping plane ON
  //! 2 = Front clipping plane ON
  //! 3 = Back and front clipping planes ON
  Standard_EXPORT   Standard_Integer DepthClip()  const;
  
  //! returns the View coordinate denoting the location of
  //! the back clipping plane
  Standard_EXPORT   Standard_Real BackPlaneDistance()  const;
  
  //! returns the View coordinate denoting the location of
  //! the front clipping plane
  Standard_EXPORT   Standard_Real FrontPlaneDistance()  const;
  
  //! returns the Transformation Matrix
  Standard_EXPORT   Handle(IGESData_TransfEntity) ViewMatrix()  const;
  
  //! returns XYX from the Model space to the View space by
  //! applying the View Matrix
  Standard_EXPORT   gp_XYZ ModelToView (const gp_XYZ& coords)  const;




  DEFINE_STANDARD_RTTI(IGESDraw_PerspectiveView)

protected:




private: 


  Standard_Integer theViewNumber;
  Standard_Real theScaleFactor;
  gp_XYZ theViewNormalVector;
  gp_XYZ theViewReferencePoint;
  gp_XYZ theCenterOfProjection;
  gp_XYZ theViewUpVector;
  Standard_Real theViewPlaneDistance;
  gp_XY theTopLeft;
  gp_XY theBottomRight;
  Standard_Integer theDepthClip;
  Standard_Real theBackPlaneDistance;
  Standard_Real theFrontPlaneDistance;


};







#endif // _IGESDraw_PerspectiveView_HeaderFile
