/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelloMessageParser<T extends HelloMessage>
extends HandshakeMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloMessageParser(int pointer, byte[] array, HandshakeMessageType type, ProtocolVersion version, Config config) {
        super(pointer, array, type, version, config);
    }

    protected boolean hasSessionID(HelloMessage message) {
        return (Integer)message.getSessionIdLength().getValue() > 0;
    }

    protected void parseProtocolVersion(HelloMessage message) {
        message.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
    }

    protected void parseRandom(HelloMessage message) {
        message.setRandom(this.parseByteArrayField(32));
        LOGGER.debug("Random:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getRandom().getValue())));
        message.setUnixTime(Arrays.copyOf((byte[])message.getRandom().getValue(), 4));
        LOGGER.debug("UnixTime:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getUnixTime().getValue())));
    }

    protected void parseSessionIDLength(HelloMessage message) {
        message.setSessionIdLength(this.parseIntField(1));
        LOGGER.debug("SessionIDLength:" + message.getSessionIdLength().getValue());
    }

    protected void parseSessionID(HelloMessage message) {
        message.setSessionId(this.parseByteArrayField(message.getSessionIdLength().getOriginalValue()));
        LOGGER.debug("SessionID:" + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSessionId().getValue())));
    }
}

