/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import org.carrot2.text.preprocessing.PreprocessingContext;

final class SuffixSorter {
    SuffixSorter() {
    }

    void suffixSort(PreprocessingContext context) {
        int[] intCodes = new int[context.allTokens.wordIndex.length];
        System.arraycopy(context.allTokens.wordIndex, 0, intCodes, 0, intCodes.length);
        int currentSeparatorCode = -1;
        for (int i = 0; i < intCodes.length; ++i) {
            if (intCodes[i] >= 0) continue;
            intCodes[i] = currentSeparatorCode--;
        }
        int[] suffixOrder = IndirectSort.mergesort((int)0, (int)intCodes.length, (IndirectComparator)new SuffixComparator(intCodes));
        context.allTokens.suffixOrder = suffixOrder;
        context.allTokens.lcp = this.calculateLcp(intCodes, suffixOrder);
    }

    private int[] calculateLcp(int[] intCodes, int[] suffixOrder) {
        int[] lcpArray = new int[intCodes.length];
        lcpArray[0] = 0;
        for (int i = 1; i < lcpArray.length - 1; ++i) {
            int lcp = 0;
            while (intCodes[suffixOrder[i - 1] + lcp] == intCodes[suffixOrder[i] + lcp]) {
                ++lcp;
            }
            lcpArray[i] = lcp;
        }
        return lcpArray;
    }

    private static class SuffixComparator
    implements IndirectComparator {
        private int[] suffixData;

        public SuffixComparator(int[] suffixData) {
            this.suffixData = suffixData;
        }

        public int compare(int suffixA, int suffixB) {
            if (suffixA == suffixB) {
                return 0;
            }
            while (this.suffixData[suffixA] == this.suffixData[suffixB]) {
                ++suffixA;
                ++suffixB;
            }
            return this.suffixData[suffixB] - this.suffixData[suffixA];
        }
    }
}

