/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.ControllerContextImpl;
import org.carrot2.core.ControllerStatistics;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.Document;
import org.carrot2.core.HttpAuthHub;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.SimpleProcessingComponentManager;
import org.carrot2.shaded.guava.common.collect.ImmutableMap;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.RollingWindowAverage;

public final class Controller
implements Closeable {
    private volatile boolean closed = false;
    private ControllerContextImpl context = new ControllerContextImpl();
    IProcessingComponentManager componentManager;
    private Map<String, Object> initAttributes;
    private Map<String, ProcessingComponentConfiguration> componentIdToConfiguration;
    private ProcessingStatistics statistics = new ProcessingStatistics();

    Controller() {
        this(new SimpleProcessingComponentManager());
    }

    public Controller(IProcessingComponentManager componentManager) {
        HttpAuthHub.setupAuthenticator();
        this.componentManager = componentManager;
    }

    public synchronized Controller init() throws ComponentInitializationException {
        return this.init((Map<String, Object>)ImmutableMap.of());
    }

    public synchronized Controller init(Map<String, Object> attributes) throws ComponentInitializationException {
        return this.init(attributes, new ProcessingComponentConfiguration[0]);
    }

    public synchronized Controller init(Map<String, Object> attributes, ProcessingComponentConfiguration ... configurations) throws ComponentInitializationException {
        this.checkClosed();
        if (this.componentIdToConfiguration != null) {
            throw new IllegalStateException("This controller is already initialized.");
        }
        this.initAttributes = Collections.unmodifiableMap(Maps.newHashMap(attributes));
        this.componentIdToConfiguration = ProcessingComponentConfiguration.indexByComponentId(configurations);
        this.componentManager.init(this.context, attributes, configurations);
        return this;
    }

    public ProcessingResult process(String query, Integer results, Class<?> ... processingComponentClasses) throws ProcessingException {
        HashMap attributes = Maps.newHashMap();
        attributes.put("query", query);
        if (results != null) {
            attributes.put("results", results);
        }
        return this.process((Map<String, Object>)attributes, processingComponentClasses);
    }

    public ProcessingResult process(List<Document> documents, String queryHint, Class<?> ... processingComponentClasses) throws ProcessingException {
        HashMap attributes = Maps.newHashMap();
        attributes.put("documents", documents);
        if (StringUtils.isNotBlank((CharSequence)queryHint)) {
            attributes.put("query", queryHint);
        }
        return this.process((Map<String, Object>)attributes, processingComponentClasses);
    }

    public ProcessingResult process(Map<String, Object> attributes, Class<?> ... processingComponentClasses) throws ProcessingException {
        return this.process(attributes, (Object[])processingComponentClasses);
    }

    public ProcessingResult process(Map<String, Object> attributes, String ... processingComponentIdsOrClassNames) throws ProcessingException {
        return this.process(attributes, (Object[])processingComponentIdsOrClassNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(Map<String, Object> attributes, Object ... processingComponentClassesOrIds) throws ProcessingException {
        ProcessingResult processingResult;
        this.checkClosed();
        Controller controller = this;
        synchronized (controller) {
            if (this.componentIdToConfiguration == null) {
                this.init();
            }
        }
        IProcessingComponent[] components = new IProcessingComponent[processingComponentClassesOrIds.length];
        ProcessingComponentConfiguration[] configurations = new ProcessingComponentConfiguration[components.length];
        ProcessingResult processingResult2 = null;
        try {
            HashMap inputAttributes = Maps.newHashMap();
            for (int i = 0; i < processingComponentClassesOrIds.length; ++i) {
                configurations[i] = this.resolveComponent(processingComponentClassesOrIds[i]);
                inputAttributes.putAll(this.initAttributes);
                inputAttributes.putAll(configurations[i].attributes);
                inputAttributes.putAll(attributes);
            }
            HashMap attributesCopy = Maps.newHashMap(attributes);
            HashMap resultAttributes = Maps.newHashMap(attributes);
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.componentManager.prepare(configurations[i].componentClass, configurations[i].componentId, inputAttributes, resultAttributes);
                long componentStart = System.currentTimeMillis();
                try {
                    ControllerUtils.performProcessing(components[i], attributesCopy, resultAttributes);
                    attributesCopy.putAll(resultAttributes);
                    continue;
                }
                finally {
                    long componentStop = System.currentTimeMillis();
                    long time = componentStop - componentStart;
                    if (IDocumentSource.class.isAssignableFrom(configurations[i].componentClass)) {
                        Controller.addTime("processing-time-source", time, resultAttributes);
                    }
                    if (IClusteringAlgorithm.class.isAssignableFrom(configurations[i].componentClass)) {
                        Controller.addTime("processing-time-algorithm", time, resultAttributes);
                    }
                    Controller.addTime("processing-time-total", time, resultAttributes);
                }
            }
            try {
                processingResult2 = new ProcessingResult(resultAttributes);
            }
            catch (IllegalArgumentException e) {
                throw new ProcessingException(e);
            }
            processingResult = processingResult2;
            this.statistics.update(processingResult2);
        }
        catch (Throwable throwable) {
            this.statistics.update(processingResult2);
            for (int i = 0; i < components.length; ++i) {
                IProcessingComponent component = components[i];
                if (component == null) continue;
                this.componentManager.recycle(component, configurations[i].componentId);
            }
            throw throwable;
        }
        for (int i = 0; i < components.length; ++i) {
            IProcessingComponent component = components[i];
            if (component == null) continue;
            this.componentManager.recycle(component, configurations[i].componentId);
        }
        return processingResult;
    }

    public void dispose() {
        if (this.closed) {
            return;
        }
        try {
            if (this.context != null) {
                this.componentManager.dispose();
                this.context.dispose();
                this.context = null;
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Controller closed.");
        }
    }

    private ProcessingComponentConfiguration resolveComponent(Object classOrId) {
        if (classOrId instanceof String) {
            ProcessingComponentConfiguration configuration = this.componentIdToConfiguration.get(classOrId);
            if (configuration != null) {
                return configuration;
            }
            try {
                classOrId = ReflectionUtils.classForName((String)((Object)classOrId));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unknown component id: " + classOrId);
            }
        }
        if (classOrId instanceof Class) {
            Class clazz = classOrId;
            if (!IProcessingComponent.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Expected a Class<? extends " + IProcessingComponent.class.getSimpleName() + "> but got: " + clazz.getName());
            }
            return new ProcessingComponentConfiguration(clazz.asSubclass(IProcessingComponent.class), null);
        }
        throw new IllegalArgumentException("Expected a String or a Class<? extends " + IProcessingComponent.class.getSimpleName() + ">");
    }

    private static void addTime(String key, Long timeToAdd, Map<String, Object> attributes) {
        Long time = (Long)attributes.get(key);
        if (time == null) {
            attributes.put(key, timeToAdd);
        } else {
            attributes.put(key, time + timeToAdd);
        }
    }

    public ControllerStatistics getStatistics() {
        return this.statistics.getStatistics();
    }

    final class ProcessingStatistics {
        long totalQueries = 0L;
        long goodQueries = 0L;
        RollingWindowAverage sourceTimeAverage = new RollingWindowAverage(300000L, 10000L);
        RollingWindowAverage algorithmTimeAverage = new RollingWindowAverage(300000L, 10000L);
        RollingWindowAverage totalTimeAverage = new RollingWindowAverage(300000L, 10000L);

        ProcessingStatistics() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(ProcessingResult processingResult) {
            ProcessingStatistics processingStatistics = this;
            synchronized (processingStatistics) {
                ++this.totalQueries;
                if (processingResult != null) {
                    ++this.goodQueries;
                    Map<String, Object> attributes = processingResult.getAttributes();
                    this.addTimeToAverage(attributes, "processing-time-source", this.sourceTimeAverage);
                    this.addTimeToAverage(attributes, "processing-time-algorithm", this.algorithmTimeAverage);
                    this.addTimeToAverage(attributes, "processing-time-total", this.totalTimeAverage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ControllerStatistics getStatistics() {
            Map<Object, Object> extraStats = Controller.this.componentManager instanceof IControllerStatisticsProvider ? ((IControllerStatisticsProvider)((Object)Controller.this.componentManager)).getStatistics() : Collections.emptyMap();
            ProcessingStatistics processingStatistics = this;
            synchronized (processingStatistics) {
                return new ControllerStatistics(this.totalQueries, this.goodQueries, this.algorithmTimeAverage.getCurrentAverage(), this.algorithmTimeAverage.getUpdatesInWindow(), this.algorithmTimeAverage.getWindowSizeMillis(), this.sourceTimeAverage.getCurrentAverage(), this.sourceTimeAverage.getUpdatesInWindow(), this.sourceTimeAverage.getWindowSizeMillis(), this.totalTimeAverage.getCurrentAverage(), this.totalTimeAverage.getUpdatesInWindow(), this.totalTimeAverage.getWindowSizeMillis(), (Long)extraStats.get("cache.misses"), (Long)extraStats.get("cache.hits.total"));
            }
        }

        private void addTimeToAverage(Map<String, Object> attributes, String key, RollingWindowAverage average) {
            Long time = (Long)attributes.get(key);
            if (time != null) {
                average.add(System.currentTimeMillis(), time);
            }
        }
    }

    static interface IControllerStatisticsProvider {
        public Map<String, Object> getStatistics();
    }
}

