/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLValidationException;

class XMLUtil {
    XMLUtil() {
    }

    static void skipComment(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (iXMLReader.read() != '-') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "<!--");
        }
        int n = 0;
        block4: while (true) {
            char c = iXMLReader.read();
            switch (c) {
                case '-': {
                    ++n;
                    continue block4;
                }
                case '>': {
                    if (n != 2) break;
                    return;
                }
            }
            n = 0;
        }
    }

    static void skipTag(IXMLReader iXMLReader) throws IOException, XMLParseException {
        int n = 1;
        while (n > 0) {
            char c = iXMLReader.read();
            switch (c) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer stringBuffer, IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        stringBuffer.append(XMLUtil.scanString(iXMLReader, '\u0000', null));
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanSystemID(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanIdentifier(IXMLReader iXMLReader) throws IOException, XMLParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = iXMLReader.read()) == '_' || c == ':' || c == '-' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c > '~') {
            stringBuffer.append(c);
        }
        iXMLReader.unread(c);
        return stringBuffer.toString();
    }

    static String scanString(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = iXMLReader.getStreamLevel();
        char c2 = iXMLReader.read();
        if (c2 != '\'' && c2 != '\"') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "delimited string");
        }
        while (true) {
            String string;
            char c3;
            if ((c3 = (string = XMLUtil.read(iXMLReader, c)).charAt(0)) == c) {
                if (string.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string));
                    continue;
                }
                XMLUtil.processEntity(string, iXMLReader, iXMLEntityResolver);
                continue;
            }
            if (c3 == '&') {
                iXMLReader.unread(c3);
                string = XMLUtil.read(iXMLReader, '&');
                if (string.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string));
                    continue;
                }
                stringBuffer.append(string);
                continue;
            }
            if (iXMLReader.getStreamLevel() == n) {
                if (c3 == c2) break;
                if (c3 == '\t' || c3 == '\n' || c3 == '\r') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    static void processEntity(String string, IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        boolean bl;
        Reader reader = iXMLEntityResolver.getEntity(iXMLReader, string = string.substring(1, string.length() - 1));
        if (reader == null) {
            XMLUtil.errorInvalidEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string);
        }
        iXMLReader.startNewStream(reader, !(bl = iXMLEntityResolver.isExternalEntity(string)));
    }

    static char processCharLiteral(String string) throws IOException, XMLParseException {
        if (string.charAt(2) == 'x') {
            string = string.substring(3, string.length() - 1);
            return (char)Integer.parseInt(string, 16);
        }
        string = string.substring(2, string.length() - 1);
        return (char)Integer.parseInt(string, 10);
    }

    static void skipWhitespace(IXMLReader iXMLReader, StringBuffer stringBuffer) throws IOException {
        char c;
        if (stringBuffer == null) {
            while ((c = iXMLReader.read()) == ' ' || c == '\t' || c == '\n') {
            }
        } else {
            while ((c = iXMLReader.read()) == ' ' || c == '\t' || c == '\n') {
                if (c == '\n') {
                    stringBuffer.append('\n');
                    continue;
                }
                stringBuffer.append(' ');
            }
        }
        iXMLReader.unread(c);
    }

    static String read(IXMLReader iXMLReader, char c) throws IOException, XMLParseException {
        char c2 = iXMLReader.read();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c2);
        if (c2 == c) {
            while (c2 != ';') {
                c2 = iXMLReader.read();
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    static char readChar(IXMLReader iXMLReader, char c) throws IOException, XMLParseException {
        String string = XMLUtil.read(iXMLReader, c);
        char c2 = string.charAt(0);
        if (c2 == c) {
            XMLUtil.errorUnexpectedEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string);
        }
        return c2;
    }

    static boolean checkLiteral(IXMLReader iXMLReader, String string) throws IOException, XMLParseException {
        int n = 0;
        while (n < string.length()) {
            if (iXMLReader.read() != string.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static void errorExpectedInput(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Expected: " + string2);
    }

    static void errorInvalidEntity(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Invalid entity: `&" + string2 + ";'");
    }

    static void errorUnexpectedEntity(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "No entity reference is expected here (" + string2 + ")");
    }

    static void errorUnexpectedCDATA(String string, int n) throws XMLParseException {
        throw new XMLParseException(string, n, "No CDATA section is expected here");
    }

    static void errorInvalidInput(String string, int n, String string2) throws XMLParseException {
        throw new XMLParseException(string, n, "Invalid input: " + string2);
    }

    static void errorWrongClosingTag(String string, int n, String string2, String string3) throws XMLParseException {
        throw new XMLParseException(string, n, "Closing tag does not match opening tag: `" + string3 + "' != `" + string2 + "'");
    }

    static void errorClosingTagNotEmpty(String string, int n) throws XMLParseException {
        throw new XMLParseException(string, n, "Closing tag must be empty");
    }

    static void errorMissingElement(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(1, string, n, string3, null, null, "Element " + string2 + " expects to have a " + string3);
    }

    static void errorUnexpectedElement(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(2, string, n, string3, null, null, "Unexpected " + string3 + " in a " + string2);
    }

    static void errorMissingAttribute(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(3, string, n, string2, string3, null, "Element " + string2 + " expects an attribute named " + string3);
    }

    static void errorUnexpectedAttribute(String string, int n, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(4, string, n, string2, string3, null, "Element " + string2 + " did not expect an attribute " + "named " + string3);
    }

    static void errorInvalidAttributeValue(String string, int n, String string2, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(5, string, n, string2, string3, string4, "Invalid value for attribute " + string3);
    }

    static void errorMissingPCData(String string, int n, String string2) throws XMLValidationException {
        throw new XMLValidationException(6, string, n, null, null, null, "Missing #PCDATA in element " + string2);
    }

    static void errorUnexpectedPCData(String string, int n, String string2) throws XMLValidationException {
        throw new XMLValidationException(7, string, n, null, null, null, "Unexpected #PCDATA in element " + string2);
    }

    static void validationError(String string, int n, String string2, String string3, String string4, String string5) throws XMLValidationException {
        throw new XMLValidationException(0, string, n, string3, string4, string5, string2);
    }
}

