/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.doctest;

import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PythonDocTestUtil {
    private PythonDocTestUtil() {
    }

    public static List<PyElement> getDocTestCasesFromFile(PyFile file) {
        PyStringLiteralExpression docString;
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyClass pyClass : file.getTopLevelClasses()) {
            if (!PythonDocTestUtil.isDocTestClass(pyClass)) continue;
            result.add(pyClass);
        }
        for (PyFunction pyFunction : file.getTopLevelFunctions()) {
            if (!PythonDocTestUtil.isDocTestFunction(pyFunction)) continue;
            result.add(pyFunction);
        }
        if (file.getDocStringExpression() != null && (docString = file.getDocStringExpression()) != null && PythonDocTestUtil.hasExample(docString.getStringValue())) {
            result.add(file);
        }
        return result;
    }

    public static boolean isDocTestFunction(PyFunction pyFunction) {
        if (pyFunction.getDocStringExpression() == null) {
            return false;
        }
        PyStringLiteralExpression docString = pyFunction.getDocStringExpression();
        return docString == null || PythonDocTestUtil.hasExample(docString.getStringValue());
    }

    public static boolean isDocTestClass(PyClass pyClass) {
        PyStringLiteralExpression docString;
        for (PyFunction cls : pyClass.getMethods()) {
            if (!PythonDocTestUtil.isDocTestFunction(cls)) continue;
            return true;
        }
        return pyClass.getDocStringExpression() != null && (docString = pyClass.getDocStringExpression()) != null && PythonDocTestUtil.hasExample(docString.getStringValue());
    }

    public static boolean hasExample(String docString) {
        boolean hasExample = false;
        StringTokenizer tokenizer = new StringTokenizer(docString, "\n");
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken().trim();
            if (!str.startsWith(">>>")) continue;
            hasExample = true;
            break;
        }
        return hasExample;
    }
}

