/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyInheritorRenameFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyInheritorRenameFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PyClass;
    }

    public String getOptionName() {
        return PyBundle.message("refactoring.rename.inheritors", new Object[0]);
    }

    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_CLASS_INHERITORS;
    }

    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_CLASS_INHERITORS = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new PyInheritorRenamer((PyClass)element, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/rename/PyInheritorRenameFactory", "isApplicable"));
    }

    public static class PyInheritorRenamer
    extends AutomaticRenamer {
        public PyInheritorRenamer(PyClass element, String newName) {
            this.myElements.addAll(PyClassInheritorsSearch.search(element, false).findAll());
            this.suggestAllNames(element.getName(), newName);
        }

        public String getDialogTitle() {
            return PyBundle.message("refactoring.rename.inheritors.title", new Object[0]);
        }

        public String getDialogDescription() {
            return PyBundle.message("refactoring.rename.inheritor.classes.with.the.following.names.to", new Object[0]);
        }

        public String entityName() {
            return "Inheritor Class";
        }
    }
}

