/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.NotificationUniqueType;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerKt;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerKt$sam$java_lang_Runnable$0;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrameUpdater;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.StringKt;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0081\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0007JJ\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0:2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010>\u001a\u00020\"H\u0002J6\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020)2\u0006\u00103\u001a\u0002042\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0007JF\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020)2\u0006\u00103\u001a\u0002042\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0:2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010B2\b\u0010;\u001a\u0004\u0018\u00010<H\u0007J(\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\u0006\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\b\u0010;\u001a\u0004\u0018\u00010<H\u0007J\u0010\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020KH\u0007J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020HH\u0002J\u001e\u0010O\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010P\u001a\u0004\u0018\u000108H\u0002J\u0016\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001060:H\u0002JF\u0010R\u001a\u00020/2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020\"2\u0006\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010X\u001a\u0004\u0018\u00010YH\u0002JD\u0010Z\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010B2\b\u0010P\u001a\u0004\u0018\u0001082\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001060:2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0:H\u0002J\u0010\u0010\\\u001a\u00020\u000f2\u0006\u0010]\u001a\u00020^H\u0007J\b\u0010_\u001a\u00020\u0006H\u0007J\u0010\u0010`\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010DH\u0007J\n\u0010a\u001a\u0004\u0018\u00010bH\u0007J*\u0010c\u001a\b\u0012\u0004\u0012\u0002060d2\f\u0010e\u001a\b\u0012\u0004\u0012\u0002060d2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002060dH\u0007J\u0010\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020hH\u0002J\b\u0010j\u001a\u00020/H\u0007J\u0018\u0010k\u001a\u00020/2\u0006\u0010V\u001a\u00020\"2\u0006\u0010l\u001a\u00020\u000fH\u0002JV\u0010m\u001a\u00020/2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010n\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020\u000f2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020/0p2\u0014\u0010q\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020/\u0018\u00010r2\u0006\u0010s\u001a\u00020%2\u0006\u0010t\u001a\u00020\u000fH\u0002JJ\u0010u\u001a\u00020/2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010v\u001a\u00020M2\u0006\u0010w\u001a\u00020\u00042\u000e\u0010x\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010D2\u0006\u0010U\u001a\u00020\"2\u0006\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020\"H\u0002J,\u0010y\u001a\u00020/2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010z\u001a\u00020\u000f2\b\u0010{\u001a\u0004\u0018\u00010\u000f2\u0006\u0010|\u001a\u00020\"H\u0007J\b\u0010}\u001a\u00020YH\u0007J\u001c\u0010}\u001a\u00020/2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010~\u001a\u0004\u0018\u00010HH\u0007J\u0010\u0010\u007f\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0007JO\u0010\u0080\u0001\u001a\u00020/2\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u0001060:2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0:2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00103\u001a\u0002042\b\u0010;\u001a\u0004\u0018\u00010<H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\rR'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0013j\b\u0012\u0004\u0012\u00020\u000f`\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0(j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006\u0082\u0001"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "EMPTY_CHECK_UPDATE_RESULT", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$CheckPluginsUpdateResult;", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "NOTIFICATIONS$annotations", "disabledToUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "disabledToUpdate$annotations", "getDisabledToUpdate", "()Ljava/util/Set;", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "excludedFromUpdateCheckPlugins$annotations", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "notificationGroupRef", "getNotificationGroupRef", "()Lcom/intellij/notification/NotificationGroup;", "notificationGroupRef$delegate", "Lkotlin/Lazy;", "ourAdditionalRequestOptions", "Lgnu/trove/THashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/updateSettings/impl/NotificationUniqueType;", "Lcom/intellij/notification/Notification;", "ourUpdatedPlugins", "Ljava/util/HashMap;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "Lkotlin/collections/HashMap;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "addUpdateRequestParameter", "", "name", "value", "buildDownloaderAndPrepareToInstall", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "toUpdate", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "host", "canEnableNotifications", "checkAndPrepareToInstall", "downloader", "incompatiblePlugins", "", "checkExternalUpdates", "", "Lcom/intellij/openapi/updateSettings/impl/ExternalUpdate;", "manualCheck", "updateSettings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "checkPluginsUpdate", "newBuildNumber", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "showSettingsLink", "showDialog", "showEmptyNotification", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "getIncompatiblePlugins", "updateable", "getInstallationUID", "c", "Lcom/intellij/ide/util/PropertiesComponent;", "getNotificationGroup", "getPluginUpdates", "getUpdatesInfo", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "mergePluginsFromRepositories", "", "marketplaceUpdates", "customPlugins", "prepareUpdateCheckArgs", "Lcom/intellij/util/Url;", "url", "saveDisabledToUpdatePlugins", "showErrorMessage", "message", "showNotification", "title", "action", "Lkotlin/Function0;", "extraBuilder", "Lkotlin/Function1;", "notificationType", "notificationDisplayId", "showUpdateResult", "checkForUpdateResult", "checkPluginsUpdateResult", "externalUpdates", "testPlatformUpdate", "updateInfoText", "patchFilePath", "forceUpdate", "updateAndShowResult", "customSettings", "updateDescriptorsForInstalledPlugins", "validateCompatibleUpdatesForCurrentPlugins", "CheckPluginsUpdateResult", "intellij.platform.ide.impl"})
public final class UpdateChecker {
    private static final Lazy notificationGroupRef$delegate;
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static Set<PluginId> ourDisabledToUpdatePlugins;
    private static final THashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<PluginId, PluginDownloader> ourUpdatedPlugins;
    private static final MultiMap<NotificationUniqueType, Notification> ourShownNotifications;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static final CheckPluginsUpdateResult EMPTY_CHECK_UPDATE_RESULT;
    private static boolean ourHasFailedPlugins;
    public static final UpdateChecker INSTANCE;

    private final NotificationGroup getNotificationGroupRef() {
        Lazy lazy = notificationGroupRef$delegate;
        UpdateChecker updateChecker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationGroup)lazy.getValue();
    }

    @Deprecated(level=DeprecationLevel.ERROR, replaceWith=@ReplaceWith(imports={}, expression="getNotificationGroup()"), message="Use getNotificationGroup()")
    public static /* synthetic */ void NOTIFICATIONS$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        return INSTANCE.getNotificationGroupRef();
    }

    public static /* synthetic */ void excludedFromUpdateCheckPlugins$annotations() {
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            ApplicationInfoEx.UpdateUrls updateUrls = applicationInfoEx.getUpdateUrls();
            if (updateUrls == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)updateUrls, (String)"ApplicationInfoEx.getInstanceEx().updateUrls!!");
            String string2 = updateUrls.getCheckingUrl();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApplicationInfoEx.getIns\u2026.updateUrls!!.checkingUrl");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback2 = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback2){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, null, true, false, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback2;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project, project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                boolean bl = !this.$fromSettings;
                boolean bl2 = this.$fromSettings || WelcomeFrame.getInstance() != null;
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project, bl, bl2, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final Collection<PluginDownloader> getPluginUpdates() {
        return UpdateChecker.checkPluginsUpdate$default(INSTANCE, (ProgressIndicator)new EmptyProgressIndicator(), null, 2, null).getAvailableUpdates();
    }

    private final void doUpdateAndShowResult(Project project, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (result2.getState() == UpdateStrategy.State.CONNECTION_ERROR) {
            Exception e = result2.getError();
            if (e != null) {
                UpdateCheckerKt.access$getLOG$p().debug((Throwable)e);
            }
            Object[] objectArray = new Object[1];
            Object object = e;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            objectArray[0] = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
            this.showErrorMessage(showDialog, string);
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        BuildInfo buildInfo = result2.getNewBuild();
        BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
        CheckPluginsUpdateResult checkPluginsUpdateResult = null;
        Collection<ExternalUpdate> externalUpdates = null;
        try {
            checkPluginsUpdateResult = this.checkPluginsUpdate(indicator, buildNumber);
            externalUpdates = this.checkExternalUpdates(showDialog, updateSettings, indicator);
        }
        catch (IOException e) {
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
            this.showErrorMessage(showDialog, string);
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        UpdateSettings.getInstance().saveLastCheckedInfo();
        ApplicationManager.getApplication().invokeLater(new Runnable(project, result2, checkPluginsUpdateResult, externalUpdates, showSettingsLink, showDialog, showEmptyNotification, callback2){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ CheckPluginsUpdateResult $checkPluginsUpdateResult;
            final /* synthetic */ Collection $externalUpdates;
            final /* synthetic */ boolean $showSettingsLink;
            final /* synthetic */ boolean $showDialog;
            final /* synthetic */ boolean $showEmptyNotification;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                block0: {
                    UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$checkPluginsUpdateResult, this.$externalUpdates, this.$showSettingsLink, this.$showDialog, this.$showEmptyNotification);
                    ActionCallback actionCallback = this.$callback;
                    if (actionCallback == null) break block0;
                    actionCallback.setDone();
                }
            }
            {
                this.$project = project;
                this.$result = checkForUpdateResult;
                this.$checkPluginsUpdateResult = checkPluginsUpdateResult;
                this.$externalUpdates = collection;
                this.$showSettingsLink = bl;
                this.$showDialog = bl2;
                this.$showEmptyNotification = bl3;
                this.$callback = actionCallback;
            }
        });
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        Object updateUrl;
        try {
            updateUrl = Urls.newFromEncoded((String)this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)updateUrl.getScheme(), (Object)"file") ^ true) {
                updateUrl = this.prepareUpdateCheckArgs((Url)updateUrl);
            }
            LogUtil.debug((Logger)UpdateCheckerKt.access$getLOG$p(), (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateUrl = (UpdatesInfo)HttpRequests.request((Url)updateUrl).connect((HttpRequests.RequestProcessor)checkPlatformUpdate.updateInfo.1.INSTANCE);
        }
        catch (JDOMException e) {
            UpdateCheckerKt.access$getLOG$p().info((Throwable)e);
            updateUrl = null;
        }
        catch (Exception e) {
            UpdateCheckerKt.access$getLOG$p().info((Throwable)e);
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        Url updateInfo2 = updateUrl;
        if (updateInfo2 == null || !settings.isPlatformUpdateEnabled()) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        UpdateStrategy strategy = new UpdateStrategy(buildNumber, (UpdatesInfo)updateInfo2, settings);
        return strategy.checkForUpdates();
    }

    @JvmStatic
    @Nullable
    public static final UpdatesInfo getUpdatesInfo() throws IOException, JDOMException {
        Url updateUrl = Urls.newFromEncoded((String)INSTANCE.getUpdateUrl());
        return (UpdatesInfo)HttpRequests.request((Url)updateUrl).connect((HttpRequests.RequestProcessor)getUpdatesInfo.1.INSTANCE);
    }

    private final CheckPluginsUpdateResult checkPluginsUpdate(ProgressIndicator indicator, BuildNumber newBuildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = this.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return EMPTY_CHECK_UPDATE_RESULT;
        }
        boolean bl = false;
        Map toUpdate = new LinkedHashMap();
        HashMap latestCustomPluginsAsMap = new HashMap();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> list2;
                if (host == null && ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                    this.validateCompatibleUpdatesForCurrentPlugins(updateable, toUpdate, newBuildNumber, installedPluginsState, indicator);
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull(RepositoryHelper.loadPlugins(host, newBuildNumber, indicator), (String)"RepositoryHelper.loadPlu\u2026ewBuildNumber, indicator)");
                Iterator<IdeaPluginDescriptor> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    IdeaPluginDescriptor storedDescriptor;
                    IdeaPluginDescriptor descriptor2;
                    IdeaPluginDescriptor ideaPluginDescriptor = descriptor2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"descriptor");
                    PluginId id2 = ideaPluginDescriptor.getPluginId();
                    if (updateable.containsKey(id2)) {
                        updateable.remove(id2);
                        InstalledPluginsState installedPluginsState = state;
                        Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                        this.buildDownloaderAndPrepareToInstall(installedPluginsState, descriptor2, newBuildNumber, toUpdate, indicator, host);
                    }
                    if ((storedDescriptor = (IdeaPluginDescriptor)latestCustomPluginsAsMap.get(id2)) != null && StringUtil.compareVersionNumbers((String)descriptor2.getVersion(), (String)storedDescriptor.getVersion()) <= 0) continue;
                    Map map2 = latestCustomPluginsAsMap;
                    PluginId pluginId = id2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"id");
                    map2.put(pluginId, descriptor2);
                }
            }
            catch (IOException e) {
                UpdateCheckerKt.access$getLOG$p().debug((Throwable)e);
                Logger logger = UpdateCheckerKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("failed to load plugin descriptions from ");
                String string = host;
                if (string == null) {
                    string = "default repository";
                }
                logger.info(stringBuilder.append(string).append(": ").append(e.getMessage()).toString());
            }
        }
        Collection<IdeaPluginDescriptor> incompatiblePlugins = this.getIncompatiblePlugins(newBuildNumber, updateable, toUpdate);
        Collection<PluginDownloader> collection = toUpdate.isEmpty() ? null : toUpdate.values();
        Collection collection2 = latestCustomPluginsAsMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"latestCustomPluginsAsMap.values");
        return new CheckPluginsUpdateResult(collection, collection2, incompatiblePlugins);
    }

    static /* synthetic */ CheckPluginsUpdateResult checkPluginsUpdate$default(UpdateChecker updateChecker, ProgressIndicator progressIndicator2, BuildNumber buildNumber, int n, Object object) {
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return updateChecker.checkPluginsUpdate(progressIndicator2, buildNumber);
    }

    private final Collection<IdeaPluginDescriptor> getIncompatiblePlugins(BuildNumber newBuildNumber, Map<PluginId, IdeaPluginDescriptor> updateable, Map<PluginId, PluginDownloader> toUpdate) {
        if (newBuildNumber == null) {
            return null;
        }
        Collection incompatiblePlugins = new HashSet();
        Map<PluginId, IdeaPluginDescriptor> map2 = updateable;
        boolean bl = false;
        for (Map.Entry<PluginId, IdeaPluginDescriptor> entry : map2.entrySet()) {
            Object object = entry;
            boolean bl2 = false;
            IdeaPluginDescriptor installedPlugin = object.getValue();
            if (installedPlugin == null || !installedPlugin.isEnabled() || toUpdate.containsKey(installedPlugin.getPluginId()) || PluginManagerCore.isCompatible(installedPlugin, newBuildNumber)) continue;
            object = incompatiblePlugins;
            bl2 = false;
            object.add(installedPlugin);
        }
        return incompatiblePlugins;
    }

    @JvmStatic
    public static final void updateDescriptorsForInstalledPlugins(@NotNull InstalledPluginsState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Map<PluginId, IdeaPluginDescriptor> updateable = INSTANCE.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return;
        }
        Map<PluginId, IdeaPluginDescriptor> map2 = updateable;
        UpdateChecker updateChecker = INSTANCE;
        boolean bl = false;
        Map map3 = new LinkedHashMap();
        updateChecker.validateCompatibleUpdatesForCurrentPlugins(map2, map3, null, state, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateCompatibleUpdatesForCurrentPlugins(Map<PluginId, IdeaPluginDescriptor> updateable, Map<PluginId, PluginDownloader> toUpdate, BuildNumber buildNumber, InstalledPluginsState state, ProgressIndicator indicator) {
        Iterator $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        List<String> marketplacePluginIds = MarketplaceRequests.Companion.getInstance().getMarketplacePlugins(indicator);
        Map<PluginId, IdeaPluginDescriptor> $this$map$iv = updateable;
        boolean $i$f$map = false;
        Map<PluginId, IdeaPluginDescriptor> map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Map.Entry entry = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = entry.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = ((PluginId)it2.getKey()).getIdString();
            collection.add(string);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        entry = $this$filterTo$iv$iv.iterator();
        while (entry.hasNext()) {
            Object element$iv$iv22 = entry.next();
            String it = (String)element$iv$iv22;
            boolean bl3 = false;
            if (!marketplacePluginIds.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        List idsToUpdate = (List)destination$iv$iv;
        List<IdeCompatibleUpdate> updates = MarketplaceRequests.Companion.getInstance().getLastCompatiblePluginUpdate(idsToUpdate, buildNumber);
        destination$iv$iv = updateable;
        $i$f$filterTo = false;
        $this$filterTo$iv$iv = destination$iv$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            IdeCompatibleUpdate lastUpdate;
            Object v0;
            void id2;
            Object object;
            IdeaPluginDescriptor descriptor2;
            block8: {
                entry = $i$f$filter = $this$filterTo$iv$iv.next();
                boolean element$iv$iv22 = false;
                destination$iv$iv = (PluginId)entry.getKey();
                entry = $i$f$filter;
                element$iv$iv22 = false;
                descriptor2 = (IdeaPluginDescriptor)entry.getValue();
                Iterable element$iv$iv22 = updates;
                boolean it = false;
                object = element$iv$iv22;
                boolean it2 = false;
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object t = iterator3.next();
                    IdeCompatibleUpdate it3 = (IdeCompatibleUpdate)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it3.getPluginId(), (Object)id2.getIdString())) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            if ((IdeCompatibleUpdate)v0 == null) {
                continue;
            }
            boolean isOutdated = descriptor2 == null || VersionComparatorUtil.compare((String)lastUpdate.getVersion(), (String)descriptor2.getVersion()) > 0;
            if (!isOutdated) continue;
            try {
                MarketplaceRequests marketplaceRequests = MarketplaceRequests.Companion.getInstance();
                String string = id2.getIdString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.idString");
                object = marketplaceRequests.loadPluginDescriptor(string, lastUpdate, indicator);
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 404) continue;
                throw (Throwable)e;
            }
            Object newDescriptor = object;
            this.buildDownloaderAndPrepareToInstall(state, (IdeaPluginDescriptor)newDescriptor, buildNumber, toUpdate, indicator, null);
        }
        Iterable $this$forEach$iv = toUpdate.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginId it = (PluginId)element$iv;
            boolean bl5 = false;
            updateable.remove(it);
        }
    }

    private final void buildDownloaderAndPrepareToInstall(InstalledPluginsState state, IdeaPluginDescriptor descriptor2, BuildNumber buildNumber, Map<PluginId, PluginDownloader> toUpdate, ProgressIndicator indicator, String host) {
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader(descriptor2, host, buildNumber);
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"PluginDownloader.createD\u2026iptor, host, buildNumber)");
        PluginDownloader downloader = pluginDownloader;
        state.onDescriptorDownload(descriptor2);
        UpdateChecker.checkAndPrepareToInstall(downloader, state, toUpdate, indicator);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        Object it;
        Object element$iv;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Map updateable;
        boolean bl = false;
        Map map2 = updateable = (Map)new LinkedHashMap();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
        IdeaPluginDescriptor[] $this$filter$iv = ideaPluginDescriptorArray;
        boolean $i$f$filter = false;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (IdeaPluginDescriptor element$iv$iv2 : $this$filterTo$iv$iv) {
            void it2 = element$iv$iv2;
            boolean bl2 = false;
            void v1 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!(!v1.isBundled() || it2.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Object $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it3;
            IdeaPluginDescriptor element$iv$iv2;
            element$iv$iv2 = (IdeaPluginDescriptor)element$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl3 = false;
            void v2 = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            PluginId pluginId = v2.getPluginId();
            map3.put(pluginId, element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv2;
        $i$f$associateBy = false;
        map2.putAll($this$associateBy$iv);
        Path onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                List<String> list2 = Files.readAllLines(onceInstalled);
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Files.readAllLines(onceInstalled)");
                $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)collectUpdateablePlugins.3.INSTANCE), (Function1)((Function1)new Function1<PluginId, Boolean>(updateable){
                    final /* synthetic */ Map $updateable;

                    public final boolean invoke(@NotNull PluginId it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Map map2 = this.$updateable;
                        boolean bl = false;
                        Map map3 = map2;
                        boolean bl2 = false;
                        return !map3.containsKey(it);
                    }
                    {
                        this.$updateable = map2;
                        super(1);
                    }
                }));
                $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (PluginId)element$iv;
                    boolean bl4 = false;
                    Object object = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                    updateable.put(object, null);
                }
            }
            catch (IOException e) {
                UpdateCheckerKt.access$getLOG$p().error(((Object)onceInstalled).toString(), (Throwable)e);
            }
            onceInstalled.toFile().deleteOnExit();
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            Collection e = excludedFromUpdateCheckPlugins;
            $i$f$forEach = false;
            if (!e.isEmpty()) {
                $this$forEach$iv = excludedFromUpdateCheckPlugins;
                $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    PluginId excluded;
                    element$iv = iterator3.next();
                    it = (String)element$iv;
                    boolean bl5 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)PluginId.getId((String)it), (String)"PluginId.getId(it)");
                    IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)updateable.get(excluded);
                    if (plugin == null || !plugin.isBundled()) continue;
                    updateable.remove(excluded);
                }
            }
        }
        return updateable;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Collection<ExternalUpdate> checkExternalUpdates(boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        boolean bl = false;
        ArrayList result2 = new ArrayList();
        ExternalComponentManager externalComponentManager = ExternalComponentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)externalComponentManager, (String)"ExternalComponentManager.getInstance()");
        ExternalComponentManager manager = externalComponentManager;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.external.progress", (Object[])new Object[0]));
        }
        for (ExternalComponentSource source : manager.getEnabledComponentSources(updateSettings)) {
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.checkCanceled();
            }
            List<String> list2 = updateSettings.getEnabledExternalUpdateSources();
            ExternalComponentSource externalComponentSource = source;
            Intrinsics.checkExpressionValueIsNotNull((Object)externalComponentSource, (String)"source");
            if (!list2.contains(externalComponentSource.getName())) continue;
            try {
                void $this$filterTo$iv$iv;
                Collection<UpdatableExternalComponent> collection = source.getAvailableVersions(indicator, updateSettings);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"source.getAvailableVersi\u2026ndicator, updateSettings)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UpdatableExternalComponent it = (UpdatableExternalComponent)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.isUpdateFor(manager.findExistingComponentMatching(it, source))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List siteResult = (List)destination$iv$iv;
                Collection collection2 = siteResult;
                boolean bl3 = false;
                if (!(!collection2.isEmpty())) continue;
                collection2 = result2;
                ExternalUpdate externalUpdate = new ExternalUpdate(siteResult, source);
                boolean bl4 = false;
                collection2.add(externalUpdate);
            }
            catch (Exception e) {
                UpdateCheckerKt.access$getLOG$p().warn((Throwable)e);
                Object[] objectArray = new Object[2];
                objectArray[0] = source.getName();
                String string = e.getMessage();
                if (string == null) {
                    string = "internal error";
                }
                objectArray[1] = string;
                String string2 = IdeBundle.message((String)"updates.external.error.message", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
                this.showErrorMessage(manualCheck, string2);
            }
        }
        return result2;
    }

    @Deprecated(message="Use `checkAndPrepareToInstall` without `incompatiblePlugins` parameter", level=DeprecationLevel.ERROR)
    @JvmStatic
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        UpdateChecker.checkAndPrepareToInstall(downloader, state, toUpdate, indicator);
        PluginId pluginId = downloader.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"downloader.id");
        PluginId pluginId2 = pluginId;
        if (PluginManagerCore.isDisabled(pluginId2)) {
            return;
        }
        IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginId2);
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && !PluginManagerCore.isCompatible(installedPlugin, downloader.getBuildNumber())) {
            Collection<IdeaPluginDescriptor> collection = incompatiblePlugins;
            boolean bl = false;
            collection.add(installedPlugin);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<IdeaPluginDescriptor> mergePluginsFromRepositories(@NotNull List<? extends IdeaPluginDescriptor> marketplaceUpdates, @NotNull List<? extends IdeaPluginDescriptor> customPlugins) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(marketplaceUpdates, (String)"marketplaceUpdates");
        Intrinsics.checkParameterIsNotNull(customPlugins, (String)"customPlugins");
        Iterable iterable = marketplaceUpdates;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            PluginId pluginId = it.getPluginId();
            map2.put(pluginId, element$iv$iv);
        }
        Map compatiblePluginMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        for (IdeaPluginDescriptor ideaPluginDescriptor : customPlugins) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)compatiblePluginMap.get(pluginId);
            if (plugin != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(ideaPluginDescriptor.getVersion(), plugin) <= 0) continue;
            compatiblePluginMap.put(pluginId, ideaPluginDescriptor);
        }
        return CollectionsKt.toList((Iterable)compatiblePluginMap.values());
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        PluginId pluginId = downloader2.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"downloader.id");
        PluginId pluginId2 = pluginId;
        if (PluginManagerCore.isDisabled(pluginId2)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginId2);
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginVersion, installedPlugin) > 0) {
            IdeaPluginDescriptor descriptor2 = null;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId2);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor2 = downloader2.getDescriptor();
                if (descriptor2 instanceof PluginNode && ((PluginNode)descriptor2).isIncomplete()) {
                    ProgressIndicator progressIndicator2 = indicator;
                    if (progressIndicator2 == null) {
                        progressIndicator2 = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator2)) {
                        descriptor2 = downloader2.getDescriptor();
                    }
                    ((Map)ourUpdatedPlugins).put(pluginId2, downloader2);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor2 = oldDownloader.getDescriptor();
            }
            if (PluginManagerCore.isCompatible(descriptor2, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor2.getPluginId())) {
                toUpdate.put(pluginId2, downloader2);
            }
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        UpdateCheckerKt.access$getLOG$p().info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showUpdateResult(Project project, CheckForUpdateResult checkForUpdateResult, CheckPluginsUpdateResult checkPluginsUpdateResult, Collection<? extends ExternalUpdate> externalUpdates, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification) {
        Notification it;
        List updatedPlugins;
        List list2;
        Function0 destination$iv$iv;
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        Collection<PluginDownloader> collection = checkPluginsUpdateResult.getAvailableUpdates();
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean bl = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginDownloader downloader = (PluginDownloader)element$iv$iv;
                boolean bl2 = false;
                if (!(!PluginUpdateDialog.isIgnored(downloader.getDescriptor()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = updatedPlugins = null;
        }
        if (updatedChannel != null && newBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(updatedChannel, newBuild, checkForUpdateResult, showSettingsLink, updatedPlugins, checkPluginsUpdateResult){
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $newBuild;
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ boolean $showSettingsLink;
                final /* synthetic */ List $updatedPlugins;
                final /* synthetic */ CheckPluginsUpdateResult $checkPluginsUpdateResult;

                public final void invoke() {
                    new UpdateInfoDialog(this.$updatedChannel, this.$newBuild, this.$checkForUpdateResult.getPatches(), this.$showSettingsLink, this.$updatedPlugins, this.$checkPluginsUpdateResult.getIncompatiblePlugins()).show();
                }
                {
                    this.$updatedChannel = updateChannel;
                    this.$newBuild = buildInfo;
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$showSettingsLink = bl;
                    this.$updatedPlugins = list2;
                    this.$checkPluginsUpdateResult = checkPluginsUpdateResult;
                    super(0);
                }
            };
            Collection collection2 = ourShownNotifications.remove((Object)NotificationUniqueType.PLATFORM);
            if (collection2 != null) {
                Iterable iterable = collection2;
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            if (showDialog) {
                runnable2.invoke();
            } else {
                String string;
                IdeUpdateUsageTriggerCollector.trigger("notification.shown");
                Object[] objectArray = new Object[2];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                objectArray[1] = newBuild.getVersion();
                String string2 = string = IdeBundle.message((String)"updates.new.build.notification.title", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"title");
                this.showNotification(project, string2, "", (Function0<Unit>)((Function0)new Function0<Unit>(runnable2){
                    final /* synthetic */ Function0 $runnable;

                    public final void invoke() {
                        IdeUpdateUsageTriggerCollector.trigger("notification.clicked");
                        this.$runnable.invoke();
                    }
                    {
                        this.$runnable = function0;
                        super(0);
                    }
                }), null, NotificationUniqueType.PLATFORM, "ide.update.available");
            }
            return;
        }
        boolean updateFound = false;
        if (updatedPlugins != null) {
            Collection collection3 = updatedPlugins;
            boolean $i$f$forEach = false;
            if (!collection3.isEmpty()) {
                updateFound = true;
                Collection collection4 = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
                if (collection4 != null) {
                    Iterable iterable = collection4;
                    $i$f$forEach = false;
                    for (Object element$iv : iterable) {
                        it = (Notification)element$iv;
                        boolean bl = false;
                        it.expire();
                    }
                }
                if (showDialog || !this.canEnableNotifications()) {
                    new PluginUpdateDialog(updatedPlugins, checkPluginsUpdateResult.getCustomRepositoryPlugins()).show();
                } else {
                    Function0 function0 = (Function0)new Function0<Unit>(project, updatedPlugins){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ List $updatedPlugins;

                        public final void invoke() {
                            PluginManagerConfigurable.showPluginConfigurable(this.$project, this.$updatedPlugins);
                        }
                        {
                            this.$project = project;
                            this.$updatedPlugins = list2;
                            super(0);
                        }
                    };
                    IdeFrame ideFrame = WelcomeFrame.getInstance();
                    if (ideFrame instanceof WelcomeFrameUpdater) {
                        destination$iv$iv = function0;
                        ((WelcomeFrameUpdater)ideFrame).showPluginUpdates(new UpdateCheckerKt$sam$java_lang_Runnable$0(destination$iv$iv));
                    } else {
                        String names2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.names.1.INSTANCE, (int)31, null);
                        String title2 = updatedPlugins.size() == 1 ? IdeBundle.message((String)"updates.plugin.ready.short.title.available", (Object[])new Object[]{names2}) : IdeBundle.message((String)"updates.plugins.ready.short.title.available", (Object[])new Object[0]);
                        Object message = updatedPlugins.size() == 1 ? "" : names2;
                        String string = title2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"title");
                        this.showNotification(project, string, (String)message, (Function0<Unit>)function0, (Function1<? super Notification, Unit>)((Function1)new Function1<Notification, Unit>(updatedPlugins){
                            final /* synthetic */ List $updatedPlugins;

                            public final void invoke(@NotNull Notification notification) {
                                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                                E e = notification.getActions().get(0);
                                Intrinsics.checkExpressionValueIsNotNull(e, (String)"notification.actions[0]");
                                Presentation presentation2 = ((AnAction)e).getTemplatePresentation();
                                Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"notification.actions[0].templatePresentation");
                                presentation2.setText(IdeBundle.message((String)"plugin.settings.link.title", (Object[])new Object[0]));
                                notification.getActions().add(0, new NotificationAction(this, IdeBundle.message((String)(this.$updatedPlugins.size() == 1 ? "plugins.configurable.update.button" : "plugin.manager.update.all"), (Object[])new Object[0])){
                                    final /* synthetic */ showUpdateResult.4 this$0;

                                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                                        notification.expire();
                                        PluginUpdateDialog.runUpdateAll(this.this$0.$updatedPlugins, (JComponent)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
                                    }
                                    {
                                        this.this$0 = $outer;
                                        super($super_call_param$1);
                                    }
                                });
                                notification.addAction((AnAction)new NotificationAction(this, IdeBundle.message((String)(this.$updatedPlugins.size() == 1 ? "updates.ignore.update.link" : "updates.ignore.updates.link"), (Object[])new Object[0])){
                                    final /* synthetic */ showUpdateResult.4 this$0;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                        void $this$mapTo$iv$iv;
                                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                                        notification.expire();
                                        Iterable $this$map$iv = this.this$0.$updatedPlugins;
                                        boolean $i$f$map = false;
                                        Iterable iterable = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void downloader;
                                            PluginDownloader pluginDownloader = (PluginDownloader)item$iv$iv;
                                            Collection collection = destination$iv$iv;
                                            boolean bl = false;
                                            IdeaPluginDescriptor ideaPluginDescriptor = downloader.getDescriptor();
                                            collection.add(ideaPluginDescriptor);
                                        }
                                        PluginUpdateDialog.ignorePlugins((List)destination$iv$iv);
                                    }
                                    {
                                        this.this$0 = $outer;
                                        super($super_call_param$1);
                                    }
                                });
                            }
                            {
                                this.$updatedPlugins = list2;
                                super(1);
                            }
                        }), NotificationUniqueType.PLUGINS, "plugins.update.available");
                    }
                }
            }
        }
        if (externalUpdates != null && !externalUpdates.isEmpty()) {
            updateFound = true;
            Collection collection5 = ourShownNotifications.remove((Object)NotificationUniqueType.EXTERNAL);
            if (collection5 != null) {
                Iterable iterable = collection5;
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            for (ExternalUpdate externalUpdate : externalUpdates) {
                Function0 runnable4 = (Function0)new Function0<Unit>(externalUpdate){
                    final /* synthetic */ ExternalUpdate $update;

                    public final void invoke() {
                        this.$update.getSource().installUpdates(this.$update.getComponents());
                    }
                    {
                        this.$update = externalUpdate;
                        super(0);
                    }
                };
                if (showDialog) {
                    runnable4.invoke();
                    continue;
                }
                Object[] objectArray = new Object[1];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                String title = IdeBundle.message((String)"updates.plugins.ready.title.available", (Object[])objectArray);
                Collection<UpdatableExternalComponent> collection6 = externalUpdate.getComponents();
                Intrinsics.checkExpressionValueIsNotNull(collection6, (String)"update.components");
                String updates = CollectionsKt.joinToString$default((Iterable)collection6, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String message = IdeBundle.message((String)"updates.external.ready.message", (Object[])new Object[]{externalUpdate.getComponents().size(), updates});
                String string = title;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"title");
                String string3 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message");
                this.showNotification(project, string, string3, (Function0<Unit>)runnable4, null, NotificationUniqueType.EXTERNAL, "external.components.available");
            }
        }
        if (!updateFound) {
            if (showDialog) {
                new NoUpdatesDialog(showSettingsLink).show();
            } else if (showEmptyNotification) {
                String string;
                Collection collection7 = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
                if (collection7 != null) {
                    Iterable iterable = collection7;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : iterable) {
                        it = (Notification)element$iv;
                        boolean bl = false;
                        it.expire();
                    }
                }
                String string4 = string = IdeBundle.message((String)"updates.no.updates.notification", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"title");
                this.showNotification(project, string4, "", (Function0<Unit>)((Function0)showUpdateResult.7.INSTANCE), (Function1<? super Notification, Unit>)((Function1)showUpdateResult.8.INSTANCE), NotificationUniqueType.PLUGINS, "no.updates.available");
            }
        }
    }

    private final boolean canEnableNotifications() {
        if (WelcomeFrame.getInstance() instanceof WelcomeFrameUpdater) {
            return true;
        }
        return NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS && NotificationsConfigurationImpl.getSettings(UpdateChecker.getNotificationGroup().getDisplayId()).getDisplayType() != NotificationDisplayType.NONE;
    }

    private final void showNotification(Project project, String title, String message, Function0<Unit> action2, Function1<? super Notification, Unit> extraBuilder, NotificationUniqueType notificationType, String notificationDisplayId) {
        String string;
        boolean bl;
        CharSequence charSequence = message;
        String string2 = title;
        NotificationGroup notificationGroup = UpdateChecker.getNotificationGroup();
        boolean bl2 = false;
        boolean bl3 = bl = charSequence.length() == 0;
        if (bl) {
            string = "";
        } else {
            String string3 = XmlStringUtil.wrapInHtml((CharSequence)message);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"XmlStringUtil.wrapInHtml(message)");
        }
        Notification notification = notificationGroup.createNotification(string2, string, NotificationType.INFORMATION, null, notificationDisplayId);
        notification.setCollapseActionsDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)new NotificationAction(action2, IdeBundle.message((String)"updates.notification.update.action", (Object[])new Object[0])){
            final /* synthetic */ Function0 $action;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
        Function1<? super Notification, Unit> function1 = extraBuilder;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)notification);
        }
        notification.whenExpired(new Runnable(notificationType, notification){
            final /* synthetic */ NotificationUniqueType $notificationType;
            final /* synthetic */ Notification $notification;

            public final void run() {
                UpdateChecker.access$getOurShownNotifications$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType), (Object)this.$notification);
            }
            {
                this.$notificationType = notificationUniqueType;
                this.$notification = notification;
            }
        });
        notification.notify(project);
        ourShownNotifications.putValue((Object)notificationType, (Object)notification);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        ((Map)ourAdditionalRequestOptions).put(name, value2);
    }

    private final Url prepareUpdateCheckArgs(Url url) {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getBuild().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        UpdateChecker.addUpdateRequestParameter("build", string);
        String string2 = PermanentInstallationID.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
        UpdateChecker.addUpdateRequestParameter("uid", string2);
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ExternalUpdateManager.ACTUAL != null) {
            String string3 = ExternalUpdateManager.ACTUAL.toolName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ExternalUpdateManager.ACTUAL.toolName");
            UpdateChecker.addUpdateRequestParameter("manager", string3);
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        if (applicationInfoEx.isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Url url2 = url.addParameters((Map)ourAdditionalRequestOptions);
        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"url.addParameters(ourAdditionalRequestOptions)");
        return url2;
    }

    @Deprecated(message="Replaced", replaceWith=@ReplaceWith(imports={"com.intellij.openapi.application.PermanentInstallationID"}, expression="PermanentInstallationID.get()"))
    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        String string = PermanentInstallationID.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PermanentInstallationID.get()");
        return string;
    }

    @Deprecated(message="Use disabledToUpdate", replaceWith=@ReplaceWith(imports={}, expression="disabledToUpdate"))
    @JvmStatic
    public static /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        void var1_1;
        void $this$mapTo$iv;
        Iterable iterable = UpdateChecker.getDisabledToUpdate();
        Collection destination$iv = new TreeSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PluginId pluginId = (PluginId)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string = it.getIdString();
            collection.add(string);
        }
        return (Set)var1_1;
    }

    @JvmStatic
    public static /* synthetic */ void disabledToUpdate$annotations() {
    }

    @NotNull
    public static final Set<PluginId> getDisabledToUpdate() {
        Set result2 = ourDisabledToUpdatePlugins;
        if (result2 == null) {
            block5: {
                result2 = new TreeSet();
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    try {
                        File file2 = new File(PathManager.getConfigPath(), "disabled_update.txt");
                        if (!file2.isFile()) break block5;
                        String string = FileUtil.loadFile((File)file2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadFile(file)");
                        CharSequence charSequence = string;
                        String string2 = "[\\s]";
                        int n = 0;
                        string2 = new Regex(string2);
                        n = 0;
                        boolean bl = false;
                        for (String line : string2.split(charSequence, n)) {
                            if (StringKt.nullize((String)line, (boolean)true) == null) continue;
                            boolean bl2 = false;
                            n = 0;
                            CharSequence it = charSequence;
                            boolean bl3 = false;
                            PluginId pluginId = PluginId.getId((String)it);
                            Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"PluginId.getId(it)");
                            result2.add(pluginId);
                        }
                    }
                    catch (IOException e) {
                        UpdateCheckerKt.access$getLOG$p().error((Throwable)e);
                    }
                }
            }
            ourDisabledToUpdatePlugins = result2;
        }
        return result2;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        Path plugins = Paths.get(PathManager.getConfigPath(), "disabled_update.txt");
        try {
            PluginManagerCore.savePluginsList((Collection<PluginId>)UpdateChecker.getDisabledToUpdate(), plugins, false);
        }
        catch (IOException e) {
            UpdateCheckerKt.access$getLOG$p().error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        Application app;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!ourHasFailedPlugins && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            IdeaPluginDescriptor pluginDescriptor;
            UpdateSettings updateSettings = UpdateSettings.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
            if (updateSettings.isCheckNeeded() && (pluginDescriptor = PluginManagerCore.getPlugin(PluginUtil.getInstance().findPluginId(event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
                ourHasFailedPlugins = true;
                UpdateChecker.updateAndShowResult();
            }
        }
    }

    @ApiStatus.Internal
    public final void testPlatformUpdate(@Nullable Project project, @NotNull String updateInfoText, @Nullable String patchFilePath, boolean forceUpdate) {
        Intrinsics.checkParameterIsNotNull((Object)updateInfoText, (String)"updateInfoText");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            throw (Throwable)new IllegalStateException();
        }
        UpdateChannel channel = null;
        BuildInfo newBuild = null;
        UpdateChain patches2 = null;
        if (forceUpdate) {
            UpdateChain updateChain;
            Element element2 = JDOMUtil.load((CharSequence)updateInfoText).getChild("product");
            if (element2 == null || (element2 = element2.getChild("channel")) == null) {
                throw (Throwable)new IllegalArgumentException("//channel missing");
            }
            Element node = element2;
            channel = new UpdateChannel(node);
            BuildInfo buildInfo = (BuildInfo)CollectionsKt.firstOrNull(channel.getBuilds());
            if (buildInfo == null) {
                throw (Throwable)new IllegalArgumentException("//build missing");
            }
            newBuild = buildInfo;
            PatchInfo patchInfo = (PatchInfo)CollectionsKt.firstOrNull(newBuild.getPatches());
            if (patchInfo != null) {
                PatchInfo patchInfo2 = patchInfo;
                boolean bl = false;
                boolean bl2 = false;
                PatchInfo it = patchInfo2;
                boolean bl3 = false;
                updateChain = new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{it.getFromBuild(), newBuild.getNumber()}), it.getSize());
            } else {
                updateChain = null;
            }
            patches2 = updateChain;
        } else {
            Element element3 = JDOMUtil.load((CharSequence)updateInfoText);
            Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"JDOMUtil.load(updateInfoText)");
            UpdatesInfo updateInfo2 = new UpdatesInfo(element3);
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            BuildNumber buildNumber = applicationInfo.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
            UpdateStrategy strategy = new UpdateStrategy(buildNumber, updateInfo2);
            CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
            channel = checkForUpdateResult.getUpdatedChannel();
            newBuild = checkForUpdateResult.getNewBuild();
            patches2 = checkForUpdateResult.getPatches();
        }
        if (channel != null && newBuild != null) {
            File patchFile = patchFilePath != null ? new File(FileUtil.toSystemDependentName((String)patchFilePath)) : null;
            new UpdateInfoDialog(project, channel, newBuild, patches2, patchFile).show();
        } else {
            new NoUpdatesDialog(true).show();
        }
    }

    private UpdateChecker() {
    }

    static {
        UpdateChecker updateChecker;
        INSTANCE = updateChecker = new UpdateChecker();
        notificationGroupRef$delegate = LazyKt.lazy((Function0)notificationGroupRef.2.INSTANCE);
        NOTIFICATIONS = updateChecker.getNotificationGroupRef();
        ourAdditionalRequestOptions = new THashMap();
        boolean bl = false;
        ourUpdatedPlugins = new HashMap();
        ourShownNotifications = new MultiMap();
        bl = false;
        excludedFromUpdateCheckPlugins = new HashSet();
        EMPTY_CHECK_UPDATE_RESULT = new CheckPluginsUpdateResult(null, CollectionsKt.emptyList(), null);
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, Project project, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        $this.doUpdateAndShowResult(project, showSettingsLink, showDialog, showEmptyNotification, updateSettings, indicator, callback2);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, Project project, CheckForUpdateResult checkForUpdateResult, CheckPluginsUpdateResult checkPluginsUpdateResult, Collection externalUpdates, boolean showSettingsLink, boolean showDialog, boolean showEmptyNotification) {
        $this.showUpdateResult(project, checkForUpdateResult, checkPluginsUpdateResult, externalUpdates, showSettingsLink, showDialog, showEmptyNotification);
    }

    public static final /* synthetic */ MultiMap access$getOurShownNotifications$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotifications;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u0011\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003H\u00c6\u0003J=\u0010\u0010\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$CheckPluginsUpdateResult;", "", "availableUpdates", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "customRepositoryPlugins", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "incompatiblePlugins", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getAvailableUpdates", "()Ljava/util/Collection;", "getCustomRepositoryPlugins", "getIncompatiblePlugins", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    private static final class CheckPluginsUpdateResult {
        @Nullable
        private final Collection<PluginDownloader> availableUpdates;
        @NotNull
        private final Collection<IdeaPluginDescriptor> customRepositoryPlugins;
        @Nullable
        private final Collection<IdeaPluginDescriptor> incompatiblePlugins;

        @Nullable
        public final Collection<PluginDownloader> getAvailableUpdates() {
            return this.availableUpdates;
        }

        @NotNull
        public final Collection<IdeaPluginDescriptor> getCustomRepositoryPlugins() {
            return this.customRepositoryPlugins;
        }

        @Nullable
        public final Collection<IdeaPluginDescriptor> getIncompatiblePlugins() {
            return this.incompatiblePlugins;
        }

        public CheckPluginsUpdateResult(@Nullable Collection<PluginDownloader> availableUpdates, @NotNull Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
            Intrinsics.checkParameterIsNotNull(customRepositoryPlugins, (String)"customRepositoryPlugins");
            this.availableUpdates = availableUpdates;
            this.customRepositoryPlugins = customRepositoryPlugins;
            this.incompatiblePlugins = incompatiblePlugins;
        }

        @Nullable
        public final Collection<PluginDownloader> component1() {
            return this.availableUpdates;
        }

        @NotNull
        public final Collection<IdeaPluginDescriptor> component2() {
            return this.customRepositoryPlugins;
        }

        @Nullable
        public final Collection<IdeaPluginDescriptor> component3() {
            return this.incompatiblePlugins;
        }

        @NotNull
        public final CheckPluginsUpdateResult copy(@Nullable Collection<PluginDownloader> availableUpdates, @NotNull Collection<? extends IdeaPluginDescriptor> customRepositoryPlugins, @Nullable Collection<? extends IdeaPluginDescriptor> incompatiblePlugins) {
            Intrinsics.checkParameterIsNotNull(customRepositoryPlugins, (String)"customRepositoryPlugins");
            return new CheckPluginsUpdateResult(availableUpdates, customRepositoryPlugins, incompatiblePlugins);
        }

        public static /* synthetic */ CheckPluginsUpdateResult copy$default(CheckPluginsUpdateResult checkPluginsUpdateResult, Collection collection, Collection collection2, Collection collection3, int n, Object object) {
            if ((n & 1) != 0) {
                collection = checkPluginsUpdateResult.availableUpdates;
            }
            if ((n & 2) != 0) {
                collection2 = checkPluginsUpdateResult.customRepositoryPlugins;
            }
            if ((n & 4) != 0) {
                collection3 = checkPluginsUpdateResult.incompatiblePlugins;
            }
            return checkPluginsUpdateResult.copy(collection, collection2, collection3);
        }

        @NotNull
        public String toString() {
            return "CheckPluginsUpdateResult(availableUpdates=" + this.availableUpdates + ", customRepositoryPlugins=" + this.customRepositoryPlugins + ", incompatiblePlugins=" + this.incompatiblePlugins + ")";
        }

        public int hashCode() {
            Collection<PluginDownloader> collection = this.availableUpdates;
            Collection<IdeaPluginDescriptor> collection2 = this.customRepositoryPlugins;
            Collection<IdeaPluginDescriptor> collection3 = this.incompatiblePlugins;
            return ((collection != null ? ((Object)collection).hashCode() : 0) * 31 + (collection2 != null ? ((Object)collection2).hashCode() : 0)) * 31 + (collection3 != null ? ((Object)collection3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CheckPluginsUpdateResult)) break block3;
                    CheckPluginsUpdateResult checkPluginsUpdateResult = (CheckPluginsUpdateResult)object;
                    if (!Intrinsics.areEqual(this.availableUpdates, checkPluginsUpdateResult.availableUpdates) || !Intrinsics.areEqual(this.customRepositoryPlugins, checkPluginsUpdateResult.customRepositoryPlugins) || !Intrinsics.areEqual(this.incompatiblePlugins, checkPluginsUpdateResult.incompatiblePlugins)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

