/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class InlineInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, InlineInlayImpl<?>> {
    private static final Key<Integer> ORDER_BEFORE_DISPOSAL = Key.create((String)"inlay.order.before.disposal");

    InlineInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer) {
        if (editor == null) {
            InlineInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            InlineInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor, offset, relatesToPrecedingText, renderer);
    }

    @Override
    RangeMarkerTree<InlineInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myInlineElementsTree;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            InlineInlayImpl.$$$reportNull$$$0(2);
        }
        this.myEditor.getInlayModel().myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getOffset();
        super.changedUpdateImpl(e);
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.intervalStart())) {
            this.invalidate(e);
        }
    }

    @Override
    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            InlineInlayImpl.$$$reportNull$$$0(3);
        }
        InlayModelImpl inlayModel = this.myEditor.getInlayModel();
        boolean bl = inlayModel.myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getMoveOffset() + e.getNewLength();
        if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), this.getOffset())) {
            inlayModel.myMoveInProgress = true;
            try {
                this.invalidate("moved inside surrogate pair on retarget");
            }
            finally {
                inlayModel.myMoveInProgress = false;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            int offset = this.getOffset();
            List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
            this.putUserData(ORDER_BEFORE_DISPOSAL, inlays.indexOf(this));
        }
        super.dispose();
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw PluginException.createByClass((String)("Positive width should be defined for an inline element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = Inlay.Placement.INLINE;
        if (placement == null) {
            InlineInlayImpl.$$$reportNull$$$0(4);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        VisualPosition pos = this.myEditor.offsetToVisualPosition(offset);
        List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
        int order = inlays.indexOf(this);
        return new VisualPosition(pos.line, pos.column + order, true);
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    int getOrder() {
        Integer value2 = (Integer)this.getUserData(ORDER_BEFORE_DISPOSAL);
        return value2 == null ? -1 : value2;
    }

    @Override
    public String toString() {
        return "[Inline inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + this.myRenderer + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlineInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlineInlayImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

