/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BidiContentNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"bidi.content.notification.panel");
    private static final Key<Boolean> DISABLE_NOTIFICATION = Key.create((String)"bidi.content.notification.disable");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        if (!Boolean.TRUE.equals(editor.getUserData(EditorImpl.CONTAINS_BIDI_TEXT)) || Boolean.TRUE.equals(editor.getUserData(DISABLE_NOTIFICATION)) || PropertiesComponent.getInstance().isTrueValue(DISABLE_NOTIFICATION.toString())) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(EditorBundle.message((String)"bidi.content.message", (Object[])new Object[0]));
        panel2.createActionLabel(EditorBundle.message((String)"bidi.content.choose.message", (Object[])new Object[0]), () -> BidiContentNotificationProvider.showChooserPopup(editor));
        panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
            editor.putUserData(DISABLE_NOTIFICATION, (Object)Boolean.TRUE);
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        });
        panel2.createActionLabel(EditorBundle.message((String)"notification.dont.show.again.message", (Object[])new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DISABLE_NOTIFICATION.toString(), "true");
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        });
        return panel2;
    }

    private static void showChooserPopup(Editor editor) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group = actionManager.getAction("EditorBidiTextDirection");
        if (group instanceof ActionGroup) {
            int y;
            int x;
            Component invoker;
            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
            if (event instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                invoker = mouseEvent.getComponent();
                x = mouseEvent.getX();
                y = mouseEvent.getY();
            } else {
                invoker = editor.getContentComponent();
                Point caretPoint = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
                x = caretPoint.x;
                y = caretPoint.y;
            }
            actionManager.createActionPopupMenu("MainMenu", (ActionGroup)group).getComponent().show(invoker, x, y);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/BidiContentNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/BidiContentNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

