/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.codeInsight.folding.impl.GenericElementSignatureProvider;
import com.intellij.ide.favoritesTreeView.InvalidUsageNoteNode;
import com.intellij.ide.favoritesTreeView.WorkingSetSerializable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class UsageSerializable
implements WorkingSetSerializable<UsageInfo, InvalidUsageNoteNode> {
    private static final String separator = "<>";

    @Override
    public String getId() {
        return UsageInfo.class.getName();
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void serializeMe(UsageInfo info, StringBuilder os) throws IOException {
        GenericElementSignatureProvider provider = new GenericElementSignatureProvider();
        PsiElement element2 = info.getElement();
        VirtualFile virtualFile = info.getVirtualFile();
        if (element2 == null || virtualFile == null) {
            throw new IOException(info + " is invalid");
        }
        String signature = provider.getSignature(element2);
        UsageSerializable.append(os, virtualFile.getPath());
        os.append(separator);
        UsageSerializable.append(os, StringUtil.notNullize((String)signature));
        os.append(separator);
        ProperTextRange rangeInElement = info.getRangeInElement();
        if (rangeInElement == null) {
            UsageSerializable.append(os, "-1");
            os.append(separator);
            UsageSerializable.append(os, "-1");
        } else {
            UsageSerializable.append(os, String.valueOf(rangeInElement.getStartOffset()));
            os.append(separator);
            UsageSerializable.append(os, String.valueOf(rangeInElement.getEndOffset()));
        }
        os.append(separator);
        UsageSerializable.append(os, String.valueOf(info.isNonCodeUsage()));
        os.append(separator);
        UsageSerializable.append(os, String.valueOf(info.isDynamicUsage()));
        os.append(separator);
        String text = new UsageInfo2UsageAdapter(info).getPlainText();
        UsageSerializable.append(os, text);
        os.append(separator);
    }

    private static void append(StringBuilder sb, @NotNull String s) {
        if (s == null) {
            UsageSerializable.$$$reportNull$$$0(0);
        }
        sb.append(StringUtil.escapeXmlEntities((String)s));
    }

    @Override
    public UsageInfo deserializeMe(Project project, String is) throws IOException {
        return new Reader(is).execute(project);
    }

    @Override
    public InvalidUsageNoteNode deserializeMeInvalid(Project project, String is) throws IOException {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ide/favoritesTreeView/UsageSerializable", "append"));
    }

    private static class Reader {
        private int idx = 0;
        private final String is;

        private Reader(String is) {
            this.is = is;
        }

        private String readNext(boolean allowEnd) {
            int idxNext = this.is.indexOf(UsageSerializable.separator, this.idx);
            if (idxNext == -1 && allowEnd) {
                return StringUtil.unescapeXmlEntities((String)this.is.substring(this.idx));
            }
            String s = this.is.substring(this.idx, idxNext);
            this.idx = idxNext + UsageSerializable.separator.length();
            return s;
        }

        public UsageInfo execute(Project project) {
            GenericElementSignatureProvider provider = new GenericElementSignatureProvider();
            String path = this.readNext(false);
            if (path == null) {
                return null;
            }
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
            if (file2 == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile == null) {
                return null;
            }
            String signature = this.readNext(false);
            PsiElement element2 = provider.restoreBySignature(psiFile, signature, new StringBuilder());
            if (element2 == null) {
                return null;
            }
            String startStr = this.readNext(false);
            if (startStr == null) {
                return null;
            }
            String endStr = this.readNext(false);
            if (endStr == null) {
                return null;
            }
            String nonCodeUsageStr = this.readNext(false);
            if (nonCodeUsageStr == null) {
                return null;
            }
            String dynamicUsageStr = this.readNext(false);
            if (dynamicUsageStr == null) {
                return null;
            }
            String text = this.readNext(true);
            if (text == null) {
                return null;
            }
            boolean nonCodeUsage = Boolean.parseBoolean(nonCodeUsageStr);
            int start2 = Integer.parseInt(startStr);
            int end = Integer.parseInt(endStr);
            UsageInfo info = new UsageInfo(element2, start2, end, nonCodeUsage);
            boolean dynamicUsage = Boolean.parseBoolean(dynamicUsageStr);
            info.setDynamicUsage(dynamicUsage);
            return info;
        }
    }
}

