/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplateEP;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import kotlin.Lazy;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TemplateSettings", storages={@Storage(value="templates.xml")}, additionalExportFile="templates")
public final class TemplateSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(TemplateSettings.class);
    @NonNls
    public static final String USER_GROUP_NAME = "user";
    @NonNls
    private static final String TEMPLATE_SET = "templateSet";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    public static final String TEMPLATE = "template";
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    public static final char ENTER_CHAR = '\n';
    public static final char DEFAULT_CHAR = 'D';
    public static final char CUSTOM_CHAR = 'C';
    public static final char NONE_CHAR = 'N';
    @NonNls
    private static final String SPACE = "SPACE";
    @NonNls
    private static final String TAB = "TAB";
    @NonNls
    private static final String ENTER = "ENTER";
    @NonNls
    private static final String CUSTOM = "CUSTOM";
    @NonNls
    private static final String NONE = "NONE";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String EXPRESSION = "expression";
    @NonNls
    private static final String DEFAULT_VALUE = "defaultValue";
    @NonNls
    private static final String ALWAYS_STOP_AT = "alwaysStopAt";
    @NonNls
    static final String CONTEXT = "context";
    @NonNls
    private static final String TO_REFORMAT = "toReformat";
    @NonNls
    private static final String TO_SHORTEN_FQ_NAMES = "toShortenFQNames";
    @NonNls
    private static final String USE_STATIC_IMPORT = "useStaticImport";
    @NonNls
    private static final String DEACTIVATED = "deactivated";
    @NonNls
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String ID = "id";
    static final String TEMPLATES_DIR_PATH = "templates";
    private final MultiMap<String, TemplateImpl> myTemplates;
    private final Map<String, Template> myTemplatesById;
    private final Map<TemplateKey, TemplateImpl> myDefaultTemplates;
    private int myMaxKeyLength;
    private final SchemeManager<TemplateGroup> mySchemeManager;
    private State myState;
    private final Map<Pair<String, String>, PluginInfo> myPredefinedTemplates;
    private TemplateKey myLastSelectedTemplate;

    public TemplateSettings() {
        this(SchemeManagerFactory.getInstance());
    }

    @NonInjectable
    public TemplateSettings(@NotNull SchemeManagerFactory factory2) {
        if (factory2 == null) {
            TemplateSettings.$$$reportNull$$$0(0);
        }
        this.myTemplates = MultiMap.createLinked();
        this.myTemplatesById = new LinkedHashMap<String, Template>();
        this.myDefaultTemplates = new LinkedHashMap<TemplateKey, TemplateImpl>();
        this.myMaxKeyLength = 0;
        this.myState = new State();
        this.myPredefinedTemplates = new HashMap<Pair<String, String>, PluginInfo>();
        this.mySchemeManager = factory2.create(TEMPLATES_DIR_PATH, new BaseSchemeProcessor<TemplateGroup, TemplateGroup>(){

            @Override
            @Nullable
            public TemplateGroup readScheme(@NotNull Element element2, boolean duringLoad) {
                TemplateGroup readGroup;
                TemplateGroup group;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                TemplateGroup templateGroup = group = (readGroup = TemplateSettings.parseTemplateGroup(element2, element2.getAttributeValue(TemplateSettings.GROUP), this.getClass().getClassLoader())) == null ? null : TemplateSettings.this.mergeParsedGroup(element2, false, false, readGroup);
                if (group != null) {
                    group.setModified(false);
                }
                return group;
            }

            @Override
            public void beforeReloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (TemplateGroup group : schemeManager2.getAllSchemes()) {
                    schemeManager2.removeScheme(group);
                }
                TemplateSettings.this.myTemplates.clear();
                TemplateSettings.this.myDefaultTemplates.clear();
            }

            @Override
            public void reloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2, @NotNull Collection<? extends TemplateGroup> groups) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (groups == null) {
                    1.$$$reportNull$$$0(3);
                }
                TemplateSettings.this.doLoadTemplates(groups);
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (template.isModified()) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return schemeState;
                }
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(t)) continue;
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return schemeState;
                }
                SchemeState schemeState = SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(7);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(8);
                }
                Element templateSetElement = new Element(TemplateSettings.TEMPLATE_SET);
                List elements2 = template.getElements();
                if (!elements2.isEmpty()) {
                    boolean isGroupAttributeAdded = false;
                    Lazy<Map<String, TemplateContextType>> idToType2 = TemplateContext.getIdToType();
                    for (TemplateImpl t : elements2) {
                        TemplateImpl defaultTemplate = TemplateSettings.this.getDefaultTemplate(t);
                        if (defaultTemplate != null && t.equals(defaultTemplate) && t.contextsEqual(defaultTemplate)) continue;
                        if (!isGroupAttributeAdded) {
                            isGroupAttributeAdded = true;
                            templateSetElement.setAttribute(TemplateSettings.GROUP, template.getName());
                        }
                        templateSetElement.addContent(TemplateSettings.serializeTemplate(t, defaultTemplate, idToType2));
                    }
                }
                template.setModified(false);
                Element element2 = templateSetElement;
                if (element2 == null) {
                    1.$$$reportNull$$$0(9);
                }
                return element2;
            }

            @Override
            public void onSchemeAdded(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(10);
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            @Override
            public void onSchemeDeleted(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(11);
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.removeTemplate(template);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemeManager";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "groups";
                        break;
                    }
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = TemplateSettings.TEMPLATE;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeReloaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reloaded";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeAdded";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.doLoadTemplates(this.mySchemeManager.loadSchemes());
        Macro.EP_NAME.addChangeListener(() -> {
            for (TemplateImpl template : this.myTemplates.values()) {
                template.dropParsedData();
            }
            for (TemplateImpl template : this.myDefaultTemplates.values()) {
                template.dropParsedData();
            }
        }, (Disposable)ApplicationManager.getApplication());
        DefaultLiveTemplateEP.EP_NAME.addChangeListener(this.mySchemeManager::reload, (Disposable)ApplicationManager.getApplication());
    }

    private void doLoadTemplates(@NotNull Collection<? extends TemplateGroup> groups) {
        if (groups == null) {
            TemplateSettings.$$$reportNull$$$0(1);
        }
        for (TemplateGroup templateGroup : groups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                this.addTemplateImpl(template);
            }
        }
        this.loadDefaultLiveTemplates();
    }

    public static TemplateSettings getInstance() {
        return (TemplateSettings)ServiceManager.getService(TemplateSettings.class);
    }

    boolean differsFromDefault(@NotNull TemplateImpl t) {
        TemplateImpl def;
        if (t == null) {
            TemplateSettings.$$$reportNull$$$0(2);
        }
        return (def = this.getDefaultTemplate(t)) == null || !t.equals(def) || !t.contextsEqual(def);
    }

    @Nullable
    public TemplateImpl getDefaultTemplate(@NotNull TemplateImpl t) {
        if (t == null) {
            TemplateSettings.$$$reportNull$$$0(3);
        }
        return this.myDefaultTemplates.get(TemplateKey.keyOf(t));
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TemplateSettings.$$$reportNull$$$0(4);
        }
        this.myState = state;
        this.applyNewDeletedTemplates();
    }

    void applyNewDeletedTemplates() {
        for (TemplateKey templateKey : this.myState.deletedKeys) {
            if (templateKey.groupName == null) {
                for (TemplateImpl template : new ArrayList(this.myTemplates.get((Object)templateKey.key))) {
                    this.removeTemplate(template);
                }
                continue;
            }
            TemplateImpl toDelete = this.getTemplate(templateKey.key, templateKey.groupName);
            if (toDelete == null) continue;
            this.removeTemplate(toDelete);
        }
    }

    @Nullable
    public String getLastSelectedTemplateKey() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.key : null;
    }

    @Nullable
    public String getLastSelectedTemplateGroup() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.groupName : null;
    }

    public void setLastSelectedTemplate(@Nullable String group, @Nullable String key) {
        this.myLastSelectedTemplate = group == null ? null : new TemplateKey(group, key);
    }

    public Collection<? extends TemplateImpl> getTemplatesAsList() {
        return this.myTemplates.values();
    }

    public TemplateImpl[] getTemplates() {
        Collection all = this.myTemplates.values();
        return all.toArray(new TemplateImpl[0]);
    }

    public char getDefaultShortcutChar() {
        return this.myState.defaultShortcut;
    }

    public void setDefaultShortcutChar(char defaultShortcutChar) {
        this.myState.defaultShortcut = defaultShortcutChar;
    }

    @NotNull
    public Collection<TemplateImpl> getTemplates(@NotNull String key) {
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(5);
        }
        Collection collection = this.myTemplates.get((Object)key);
        if (collection == null) {
            TemplateSettings.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public TemplateImpl getTemplate(@NonNls String key, String group) {
        Collection templates = this.myTemplates.get((Object)key);
        for (TemplateImpl template : templates) {
            if (!template.getGroupName().equals(group)) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateById(@NonNls String id2) {
        return this.myTemplatesById.get(id2);
    }

    public int getMaxKeyLength() {
        return this.myMaxKeyLength;
    }

    public void addTemplate(Template template) {
        this.clearPreviouslyRegistered(template);
        this.addTemplateImpl(template);
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group = this.mySchemeManager.findSchemeByName(groupName);
        if (group == null) {
            group = new TemplateGroup(groupName);
            this.mySchemeManager.addScheme(group);
        }
        group.addElement(templateImpl);
    }

    private void clearPreviouslyRegistered(Template template) {
        TemplateImpl existing = this.getTemplate(template.getKey(), ((TemplateImpl)template).getGroupName());
        if (existing != null) {
            LOG.info("Template with key " + template.getKey() + " and id " + template.getId() + " already registered");
            TemplateGroup group = this.mySchemeManager.findSchemeByName(existing.getGroupName());
            if (group != null) {
                group.removeElement(existing);
                if (group.isEmpty()) {
                    this.mySchemeManager.removeScheme(group);
                }
            }
            this.myTemplates.remove((Object)template.getKey(), (Object)existing);
        }
    }

    private void addTemplateImpl(@NotNull Template template) {
        TemplateImpl templateImpl;
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(7);
        }
        if (this.getTemplate((templateImpl = (TemplateImpl)template).getKey(), templateImpl.getGroupName()) == null) {
            this.myTemplates.putValue((Object)template.getKey(), (Object)templateImpl);
        }
        this.myMaxKeyLength = Math.max(this.myMaxKeyLength, template.getKey().length());
        this.myState.deletedKeys.remove(TemplateKey.keyOf((TemplateImpl)template));
    }

    private void addTemplateById(Template template) {
        String id2;
        if (!this.myTemplatesById.containsKey(template.getId()) && (id2 = template.getId()) != null) {
            this.myTemplatesById.put(id2, template);
        }
    }

    public void removeTemplate(@NotNull Template template) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(8);
        }
        this.myTemplates.remove((Object)template.getKey(), (Object)((TemplateImpl)template));
        TemplateGroup group = this.mySchemeManager.findSchemeByName(((TemplateImpl)template).getGroupName());
        if (group != null) {
            group.removeElement((TemplateImpl)template);
            if (group.isEmpty()) {
                this.mySchemeManager.removeScheme(group);
            }
        }
    }

    @NotNull
    private static TemplateImpl createTemplate(@NotNull String key, String string, @NotNull String group, String description, @Nullable String shortcut, String id2) {
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(9);
        }
        if (group == null) {
            TemplateSettings.$$$reportNull$$$0(10);
        }
        TemplateImpl template = new TemplateImpl(key, string, group, false);
        template.setId(id2);
        template.setDescription(description);
        if (TAB.equals(shortcut)) {
            template.setShortcutChar('\t');
        } else if (ENTER.equals(shortcut)) {
            template.setShortcutChar('\n');
        } else if (SPACE.equals(shortcut)) {
            template.setShortcutChar(' ');
        } else if (NONE.equals(shortcut)) {
            template.setShortcutChar('N');
        } else {
            template.setShortcutChar('D');
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateSettings.$$$reportNull$$$0(11);
        }
        return templateImpl;
    }

    private void loadDefaultLiveTemplates() {
        try {
            this.myPredefinedTemplates.clear();
            for (DefaultLiveTemplatesProvider provider : DefaultLiveTemplatesProvider.EP_NAME.getExtensionList()) {
                this.loadDefaultLiveTemplatesFromProvider(provider);
            }
            for (DefaultLiveTemplateEP ep : DefaultLiveTemplateEP.EP_NAME.getExtensionList()) {
                String file2 = ep.getFile();
                if (file2 == null) continue;
                ClassLoader pluginClassLoader = ep.getPluginDescriptor().getPluginClassLoader();
                this.readDefTemplate(pluginClassLoader, file2, !ep.getHidden(), pluginClassLoader, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)ep.getPluginDescriptor()));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadDefaultLiveTemplatesFromProvider(DefaultLiveTemplatesProvider provider) throws JDOMException, IOException {
        for (String defTemplate : provider.getDefaultLiveTemplateFiles()) {
            this.readDefTemplate(provider, defTemplate, true, provider.getClass().getClassLoader(), PluginInfoDetectorKt.getPluginInfo(provider.getClass()));
        }
        try {
            String[] hidden = provider.getHiddenLiveTemplateFiles();
            if (hidden != null) {
                for (String s : hidden) {
                    this.readDefTemplate(provider, s, false, provider.getClass().getClassLoader(), PluginInfoDetectorKt.getPluginInfo(provider.getClass()));
                }
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    private void readDefTemplate(@NotNull Object requestor, @NotNull String defTemplate, boolean registerTemplate, ClassLoader loader, PluginInfo info) throws JDOMException, InvalidDataException, IOException {
        InputStream inputStream;
        if (requestor == null) {
            TemplateSettings.$$$reportNull$$$0(12);
        }
        if (defTemplate == null) {
            TemplateSettings.$$$reportNull$$$0(13);
        }
        if ((inputStream = DecodeDefaultsUtil.getDefaultsInputStream(requestor, defTemplate)) == null) {
            LOG.error("Unable to find template resource: " + defTemplate + "; classLoader: " + loader + "; plugin: " + info);
            return;
        }
        Element element2 = JDOMUtil.load((InputStream)inputStream);
        TemplateGroup defGroup = TemplateSettings.parseTemplateGroup(element2, TemplateSettings.getDefaultTemplateName(defTemplate), loader);
        if (defGroup != null) {
            for (TemplateImpl template : defGroup.getElements()) {
                String key = template.getKey();
                String groupName = template.getGroupName();
                if (!StringUtil.isNotEmpty((String)key) || !StringUtil.isNotEmpty((String)groupName)) continue;
                this.myPredefinedTemplates.put((Pair<String, String>)Pair.create((Object)key, (Object)groupName), info);
            }
            TemplateGroup group = this.mergeParsedGroup(element2, true, registerTemplate, defGroup);
            if (group != null && group.getReplace() != null) {
                for (TemplateImpl template : this.myTemplates.get((Object)group.getReplace())) {
                    this.removeTemplate(template);
                }
            }
        }
    }

    @Nullable
    public PluginInfo findPluginForPredefinedTemplate(TemplateImpl template) {
        return this.myPredefinedTemplates.get(Pair.create((Object)template.getKey(), (Object)template.getGroupName()));
    }

    private static String getDefaultTemplateName(String defTemplate) {
        return defTemplate.substring(defTemplate.lastIndexOf(47) + 1);
    }

    @Nullable
    private static TemplateGroup parseTemplateGroup(@NotNull Element element2, @NonNls String defGroupName, @NotNull ClassLoader classLoader) {
        if (element2 == null) {
            TemplateSettings.$$$reportNull$$$0(14);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(15);
        }
        if (!TEMPLATE_SET.equals(element2.getName())) {
            LOG.error("Ignore invalid template scheme: " + JDOMUtil.writeElement((Element)element2));
            return null;
        }
        String groupName = element2.getAttributeValue(GROUP);
        if (StringUtil.isEmpty((String)groupName)) {
            groupName = defGroupName;
        }
        TemplateGroup result2 = new TemplateGroup(groupName, element2.getAttributeValue("REPLACE"));
        for (Element child2 : element2.getChildren(TEMPLATE)) {
            try {
                result2.addElement(TemplateSettings.readTemplateFromElement(groupName, child2, classLoader));
            }
            catch (Exception e) {
                LOG.warn("failed to load template " + element2.getAttributeValue(NAME), (Throwable)e);
            }
        }
        return result2;
    }

    @Nullable
    private TemplateGroup mergeParsedGroup(@NotNull Element element2, boolean isDefault, boolean registerTemplate, TemplateGroup parsedGroup) {
        Object existingScheme;
        if (element2 == null) {
            TemplateSettings.$$$reportNull$$$0(16);
        }
        Object result2 = new TemplateGroup(parsedGroup.getName(), element2.getAttributeValue("REPLACE"));
        LinkedHashMap<String, TemplateImpl> created = new LinkedHashMap<String, TemplateImpl>();
        for (TemplateImpl template : parsedGroup.getElements()) {
            boolean defaultTemplateModified;
            if (isDefault) {
                this.myDefaultTemplates.put(TemplateKey.keyOf(template), template);
            }
            TemplateImpl existing = this.getTemplate(template.getKey(), template.getGroupName());
            boolean bl = defaultTemplateModified = isDefault && (this.myState.deletedKeys.contains(TemplateKey.keyOf(template)) || this.myTemplatesById.containsKey(template.getId()) || existing != null);
            if (!defaultTemplateModified) {
                created.put(template.getKey(), template);
            }
            if (!isDefault || existing == null) continue;
            existing.getTemplateContext().setDefaultContext(template.getTemplateContext());
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) != null) {
            result2 = existingScheme;
        }
        existingScheme = created.values().iterator();
        while (existingScheme.hasNext()) {
            TemplateImpl template;
            template = (TemplateImpl)existingScheme.next();
            if (registerTemplate) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
            this.addTemplateById(template);
            ((CompoundScheme)result2).addElement(template);
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) == null && !((CompoundScheme)result2).isEmpty()) {
            this.mySchemeManager.addScheme((TemplateGroup)result2, false);
        }
        return ((CompoundScheme)result2).isEmpty() ? null : result2;
    }

    public static TemplateImpl readTemplateFromElement(String groupName, @NotNull Element element2, @NotNull ClassLoader classLoader) {
        String description;
        if (element2 == null) {
            TemplateSettings.$$$reportNull$$$0(17);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(18);
        }
        String name = element2.getAttributeValue(NAME);
        String value2 = element2.getAttributeValue(VALUE);
        String resourceBundle = element2.getAttributeValue(RESOURCE_BUNDLE);
        String key = element2.getAttributeValue(KEY);
        String id2 = element2.getAttributeValue(ID);
        if (resourceBundle != null && key != null) {
            ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(resourceBundle, classLoader);
            description = bundle.getString(key);
        } else {
            description = element2.getAttributeValue(DESCRIPTION);
        }
        String shortcut = element2.getAttributeValue(SHORTCUT);
        TemplateImpl template = TemplateSettings.createTemplate(name, value2, groupName, description, shortcut, id2);
        template.setToReformat(Boolean.parseBoolean(element2.getAttributeValue(TO_REFORMAT)));
        template.setToShortenLongNames(Boolean.parseBoolean(element2.getAttributeValue(TO_SHORTEN_FQ_NAMES)));
        template.setDeactivated(Boolean.parseBoolean(element2.getAttributeValue(DEACTIVATED)));
        String useStaticImport = element2.getAttributeValue(USE_STATIC_IMPORT);
        if (useStaticImport != null) {
            template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, Boolean.parseBoolean(useStaticImport));
        }
        for (Element e : element2.getChildren(VARIABLE)) {
            String variableName = e.getAttributeValue(NAME);
            String expression = e.getAttributeValue(EXPRESSION);
            String defaultValue = e.getAttributeValue(DEFAULT_VALUE);
            boolean isAlwaysStopAt = Boolean.parseBoolean(e.getAttributeValue(ALWAYS_STOP_AT));
            template.addVariable(variableName, expression, defaultValue, isAlwaysStopAt);
        }
        Element context = element2.getChild(CONTEXT);
        if (context != null) {
            template.getTemplateContext().readTemplateContext(context);
        }
        return template;
    }

    @NotNull
    public static Element serializeTemplate(@NotNull TemplateImpl template, @Nullable TemplateImpl defaultTemplate, @NotNull Lazy<Map<String, TemplateContextType>> idToType2) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(19);
        }
        if (idToType2 == null) {
            TemplateSettings.$$$reportNull$$$0(20);
        }
        Element element2 = new Element(TEMPLATE);
        String id2 = template.getId();
        if (id2 != null) {
            element2.setAttribute(ID, id2);
        }
        element2.setAttribute(NAME, template.getKey());
        element2.setAttribute(VALUE, template.getString());
        if (template.getShortcutChar() == '\t') {
            element2.setAttribute(SHORTCUT, TAB);
        } else if (template.getShortcutChar() == '\n') {
            element2.setAttribute(SHORTCUT, ENTER);
        } else if (template.getShortcutChar() == ' ') {
            element2.setAttribute(SHORTCUT, SPACE);
        } else if (template.getShortcutChar() == 'N') {
            element2.setAttribute(SHORTCUT, NONE);
        }
        if (template.getDescription() != null) {
            element2.setAttribute(DESCRIPTION, template.getDescription());
        }
        element2.setAttribute(TO_REFORMAT, Boolean.toString(template.isToReformat()));
        element2.setAttribute(TO_SHORTEN_FQ_NAMES, Boolean.toString(template.isToShortenLongNames()));
        if (template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE) != Template.getDefaultValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            element2.setAttribute(USE_STATIC_IMPORT, Boolean.toString(template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)));
        }
        if (template.isDeactivated()) {
            element2.setAttribute(DEACTIVATED, Boolean.toString(true));
        }
        for (int i2 = 0; i2 < template.getVariableCount(); ++i2) {
            Element variableElement = new Element(VARIABLE);
            variableElement.setAttribute(NAME, template.getVariableNameAt(i2));
            variableElement.setAttribute(EXPRESSION, template.getExpressionStringAt(i2));
            variableElement.setAttribute(DEFAULT_VALUE, template.getDefaultValueStringAt(i2));
            variableElement.setAttribute(ALWAYS_STOP_AT, Boolean.toString(template.isAlwaysStopAt(i2)));
            element2.addContent(variableElement);
        }
        Element contextElement = template.getTemplateContext().writeTemplateContext(defaultTemplate == null ? null : defaultTemplate.getTemplateContext(), idToType2);
        if (contextElement != null) {
            element2.addContent(contextElement);
        }
        Element element3 = element2;
        if (element3 == null) {
            TemplateSettings.$$$reportNull$$$0(21);
        }
        return element3;
    }

    public void setTemplates(@NotNull List<? extends TemplateGroup> newGroups) {
        if (newGroups == null) {
            TemplateSettings.$$$reportNull$$$0(22);
        }
        this.myTemplates.clear();
        this.myState.deletedKeys.clear();
        for (TemplateImpl template : this.myDefaultTemplates.values()) {
            this.myState.deletedKeys.add(TemplateKey.keyOf(template));
        }
        this.myMaxKeyLength = 0;
        SmartList schemes = new SmartList();
        for (TemplateGroup templateGroup : newGroups) {
            if (templateGroup.isEmpty()) continue;
            schemes.add(templateGroup);
            for (TemplateImpl template : templateGroup.getElements()) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
        }
        this.mySchemeManager.setSchemes((List<TemplateGroup>)schemes);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    @NotNull
    public List<TemplateImpl> collectMatchingCandidates(@NotNull String key, @Nullable Character shortcutChar, boolean hasArgument) {
        Collection<TemplateImpl> templates;
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(23);
        }
        if ((templates = this.getTemplates(key)).isEmpty()) {
            List<TemplateImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                TemplateSettings.$$$reportNull$$$0(24);
            }
            return list2;
        }
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : templates) {
            if (template.isDeactivated() || shortcutChar != null && this.getShortcutChar(template) != shortcutChar.charValue() || hasArgument && !template.hasArgument()) continue;
            candidates.add(template);
        }
        ArrayList<TemplateImpl> arrayList = candidates;
        if (arrayList == null) {
            TemplateSettings.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public char getShortcutChar(TemplateImpl template) {
        char c = template.getShortcutChar();
        return c == 'D' ? this.getDefaultShortcutChar() : c;
    }

    public List<TemplateKey> getDeletedTemplates() {
        return this.myState.deletedKeys;
    }

    public void reset() {
        this.myState.deletedKeys.clear();
        this.loadDefaultLiveTemplates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEMPLATE;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defTemplate";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeTemplate";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchingCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doLoadTemplates";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readDefTemplate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseTemplateGroup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeParsedGroup";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateFromElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "serializeTemplate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchingCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TemplateKey {
        private String groupName;
        private String key;

        public TemplateKey() {
        }

        private TemplateKey(String groupName, String key) {
            this.groupName = groupName;
            this.key = key;
        }

        public static TemplateKey keyOf(TemplateImpl template) {
            return new TemplateKey(template.getGroupName(), template.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.groupName, that.groupName) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            int result2 = this.groupName != null ? this.groupName.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.getKey() + "@" + this.getGroupName();
        }
    }

    static final class State {
        @OptionTag(nameAttribute="", valueAttribute="shortcut", converter=ShortcutConverter.class)
        public char defaultShortcut = (char)9;
        public List<TemplateKey> deletedKeys = new SmartList();

        State() {
        }
    }

    static final class ShortcutConverter
    extends Converter<Character> {
        ShortcutConverter() {
        }

        @NotNull
        public Character fromString(@NotNull String shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(0);
            }
            Character c = Character.valueOf((char)(TemplateSettings.TAB.equals(shortcut) ? 9 : (TemplateSettings.ENTER.equals(shortcut) ? 10 : (TemplateSettings.CUSTOM.equals(shortcut) ? 67 : (TemplateSettings.NONE.equals(shortcut) ? 78 : 32)))));
            if (c == null) {
                ShortcutConverter.$$$reportNull$$$0(1);
            }
            return c;
        }

        @NotNull
        public String toString(@NotNull Character shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(2);
            }
            return shortcut.charValue() == '\t' ? TemplateSettings.TAB : (shortcut.charValue() == '\n' ? TemplateSettings.ENTER : (shortcut.charValue() == 'C' ? TemplateSettings.CUSTOM : (shortcut.charValue() == 'N' ? TemplateSettings.NONE : TemplateSettings.SPACE)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TemplateSettings.SHORTCUT;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

