/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/navigation/PsiElementTargetPopupPresentation;", "Lcom/intellij/navigation/TargetPopupPresentation;", "myElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "myItemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "myModuleRendererData", "Lkotlin/Pair;", "", "Ljavax/swing/Icon;", "myProject", "Lcom/intellij/openapi/project/Project;", "myVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileBackgroundColor", "Ljava/awt/Color;", "getIcon", "getLocationAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getLocationText", "getPresentableAttributes", "getPresentableText", "getRightIcon", "getRightText", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class PsiElementTargetPopupPresentation
implements TargetPopupPresentation {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final ItemPresentation myItemPresentation;
    private final Pair<String, Icon> myModuleRendererData;
    private final PsiElement myElement;

    @Nullable
    public Icon getIcon() {
        return this.myElement.getIcon(3);
    }

    @NotNull
    public String getPresentableText() {
        Object object;
        Object object2 = this.myItemPresentation;
        if (object2 == null || (object2 = object2.getPresentableText()) == null) {
            PsiElement psiElement = this.myElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
            object2 = object = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        if (object2 == null) {
            String string = this.myElement.getText();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myElement.text");
        }
        return object;
    }

    private final Color getFileBackgroundColor() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return EditorTabPresentationUtil.getFileBackgroundColor(this.myProject, virtualFile2);
    }

    @Nullable
    public TextAttributes getPresentableAttributes() {
        TextAttributes textAttributes;
        ItemPresentation itemPresentation = this.myItemPresentation;
        TextAttributes textAttributes2 = textAttributes = itemPresentation != null ? UtilKt.getColoredAttributes(itemPresentation) : null;
        if ((textAttributes2 != null ? textAttributes2.getBackgroundColor() : null) != null) {
            return textAttributes;
        }
        Color fileColor = this.getFileBackgroundColor();
        if (fileColor == null) {
            return textAttributes;
        }
        TextAttributes textAttributes3 = textAttributes;
        if (textAttributes3 == null || (textAttributes3 = textAttributes3.clone()) == null) {
            textAttributes3 = new TextAttributes();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes3, (String)"textAttributes?.clone() ?: TextAttributes()");
        TextAttributes result2 = textAttributes3;
        result2.setBackgroundColor(fileColor);
        return result2;
    }

    @Nullable
    public String getLocationText() {
        ItemPresentation itemPresentation = this.myItemPresentation;
        return itemPresentation != null ? UtilKt.getLocationText(itemPresentation) : null;
    }

    @Nullable
    public TextAttributes getLocationAttributes() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile2);
        Color locationColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(virtualFile2);
        return hasProblem ? new TextAttributes(locationColor, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (locationColor != null ? new TextAttributes(locationColor, null, null, null, 0) : null);
    }

    @Nullable
    public String getRightText() {
        Pair<String, Icon> pair = this.myModuleRendererData;
        return pair != null ? (String)pair.getFirst() : null;
    }

    @Nullable
    public Icon getRightIcon() {
        Pair<String, Icon> pair = this.myModuleRendererData;
        return pair != null ? (Icon)pair.getSecond() : null;
    }

    public PsiElementTargetPopupPresentation(@NotNull PsiElement myElement) {
        Pair pair;
        JLabel component2;
        DefaultListCellRenderer renderer;
        Intrinsics.checkParameterIsNotNull((Object)myElement, (String)"myElement");
        this.myElement = myElement;
        Project project = this.myElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
        this.myProject = project;
        PsiFile psiFile = this.myElement.getContainingFile();
        this.myVirtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        PsiElement psiElement = this.myElement;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)psiElement;
        this.myItemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
        PsiElementTargetPopupPresentation psiElementTargetPopupPresentation = this;
        PsiElementTargetPopupPresentation psiElementTargetPopupPresentation2 = this;
        boolean bl = false;
        boolean bl2 = false;
        PsiElementTargetPopupPresentation $this$run = psiElementTargetPopupPresentation;
        boolean bl3 = false;
        DefaultListCellRenderer defaultListCellRenderer = renderer = PsiElementListCellRenderer.getModuleRenderer($this$run.myElement);
        Component component3 = defaultListCellRenderer != null ? defaultListCellRenderer.getListCellRendererComponent((JList<?>)new JList(), $this$run.myElement, -1, false, false) : null;
        if (!(component3 instanceof JLabel)) {
            component3 = null;
        }
        JLabel jLabel = component2 = (JLabel)component3;
        if (jLabel != null) {
            JLabel jLabel2 = jLabel;
            boolean bl4 = false;
            boolean bl5 = false;
            JLabel it = jLabel2;
            boolean bl6 = false;
            pair = new Pair((Object)component2.getText(), (Object)component2.getIcon());
        } else {
            pair = null;
        }
        Pair pair2 = pair;
        psiElementTargetPopupPresentation2.myModuleRendererData = pair2;
    }
}

