/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EmptySoftWrapModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\f\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewEditor;", "Lcom/intellij/openapi/editor/impl/ImaginaryEditor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "caretOffset", "", "(Lcom/intellij/psi/PsiFile;I)V", "getSoftWrapModel", "Lcom/intellij/openapi/editor/SoftWrapModel;", "isViewer", "", "logicalPositionToOffset", "pos", "Lcom/intellij/openapi/editor/LogicalPosition;", "logicalToVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "logicalPos", "notImplemented", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "offsetToLogicalPosition", "offset", "visualToLogicalPosition", "visiblePos", "intellij.platform.lang.impl"})
public final class IntentionPreviewEditor
extends ImaginaryEditor {
    @Override
    @NotNull
    protected RuntimeException notImplemented() {
        return new IntentionPreviewUnsupportedOperationException();
    }

    @Override
    public boolean isViewer() {
        return true;
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Document document = this.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document");
        Document document2 = document;
        int lineStart = document2.getLineStartOffset(pos.line);
        int lineEnd = document2.getLineEndOffset(pos.line);
        int n = lineStart + pos.column;
        boolean bl = false;
        return Math.min(lineEnd, n);
    }

    @Override
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        Intrinsics.checkParameterIsNotNull((Object)logicalPos, (String)"logicalPos");
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        Intrinsics.checkParameterIsNotNull((Object)visiblePos, (String)"visiblePos");
        return new LogicalPosition(visiblePos.line, visiblePos.column);
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        Document document = this.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document");
        Document document2 = document;
        int line = document2.getLineNumber(offset);
        int col = offset - document2.getLineStartOffset(line);
        return new LogicalPosition(line, col);
    }

    @Override
    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        return new EmptySoftWrapModel();
    }

    public IntentionPreviewEditor(@NotNull PsiFile psiFileCopy, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)psiFileCopy, (String)"psiFileCopy");
        Project project = psiFileCopy.getProject();
        FileViewProvider fileViewProvider = psiFileCopy.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFileCopy.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        super(project, document);
        this.getCaretModel().moveToOffset(caretOffset);
    }
}

