/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public final class DeclarativeInsertHandler
implements InsertHandler<LookupElement> {
    public final String ignoredCompletionChars;
    public final String valueToInsert;
    public final boolean autoPopup;

    private DeclarativeInsertHandler(@NotNull String ignoredCompletionChars, @NotNull String valueToInsert, boolean autoPopup) {
        if (ignoredCompletionChars == null) {
            DeclarativeInsertHandler.$$$reportNull$$$0(0);
        }
        if (valueToInsert == null) {
            DeclarativeInsertHandler.$$$reportNull$$$0(1);
        }
        this.ignoredCompletionChars = ignoredCompletionChars;
        this.valueToInsert = valueToInsert;
        this.autoPopup = autoPopup;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            DeclarativeInsertHandler.$$$reportNull$$$0(2);
        }
        if (item == null) {
            DeclarativeInsertHandler.$$$reportNull$$$0(3);
        }
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        if (StringUtil.containsChar((String)this.ignoredCompletionChars, (char)completionChar)) {
            return;
        }
        Project project = editor.getProject();
        if (project != null) {
            CaretModel model = editor.getCaretModel();
            if (this.isValueAlreadyHere(editor)) {
                model.moveToOffset(model.getOffset() + this.valueToInsert.length());
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)this.valueToInsert);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
            if (this.autoPopup) {
                AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
            }
        }
    }

    private boolean isValueAlreadyHere(@NotNull Editor editor) {
        if (editor == null) {
            DeclarativeInsertHandler.$$$reportNull$$$0(4);
        }
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int valueLength = this.valueToInsert.length();
        return document.getTextLength() >= startOffset + valueLength && document.getText(TextRange.create((int)startOffset, (int)(startOffset + valueLength))).equals(this.valueToInsert);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredCompletionChars";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueToInsert";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/DeclarativeInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValueAlreadyHere";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Builder {
        private String myIgnoredCharacters;
        private String myValueToInsert;
        private boolean myTriggerAutoPopup;

        @NotNull
        public Builder disableOnCompletionChars(@NotNull String ignoredChars) {
            if (ignoredChars == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myIgnoredCharacters = ignoredChars;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        public Builder insertOrMove(@NotNull String value2) {
            if (value2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myValueToInsert = value2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        public Builder triggerAutoPopup() {
            this.myTriggerAutoPopup = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public DeclarativeInsertHandler build() {
            return new DeclarativeInsertHandler(StringUtil.notNullize((String)this.myIgnoredCharacters), StringUtil.notNullize((String)this.myValueToInsert), this.myTriggerAutoPopup);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredChars";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/DeclarativeInsertHandler$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/DeclarativeInsertHandler$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableOnCompletionChars";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertOrMove";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "triggerAutoPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "disableOnCompletionChars";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insertOrMove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

