/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.regex.Pattern;
import org.freedesktop.dbus.messages.ExportedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTree {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TreeNode root = new TreeNode("");
    public static final Pattern SLASH_PATTERN = Pattern.compile("/");

    private TreeNode recursiveFind(TreeNode current, String path) {
        if ("/".equals(path)) {
            return current;
        }
        String[] elements = path.split("/", 2);
        if (path.startsWith(current.name)) {
            if (path.equals(current.name)) {
                return current;
            }
            if (current.down == null) {
                return null;
            }
            return this.recursiveFind(current.down, elements[1]);
        }
        if (current.right == null) {
            return null;
        }
        if (0 > current.right.name.compareTo(elements[0])) {
            return null;
        }
        return this.recursiveFind(current.right, path);
    }

    private TreeNode recursiveAdd(TreeNode current, String path, ExportedObject object, String data) {
        String[] elements = SLASH_PATTERN.split(path, 2);
        if (path.startsWith(current.name)) {
            if (1 == elements.length || "".equals(elements[1])) {
                current.object = object;
                current.data = data;
            } else {
                if (current.down == null) {
                    String[] el = elements[1].split("/", 2);
                    current.down = new TreeNode(el[0]);
                }
                current.down = this.recursiveAdd(current.down, elements[1], object, data);
            }
        } else if (current.right == null) {
            current.right = new TreeNode(elements[0]);
            current.right = this.recursiveAdd(current.right, path, object, data);
        } else if (0 > current.right.name.compareTo(elements[0])) {
            TreeNode t = new TreeNode(elements[0]);
            t.right = current.right;
            current.right = t;
            current.right = this.recursiveAdd(current.right, path, object, data);
        } else {
            current.right = this.recursiveAdd(current.right, path, object, data);
        }
        return current;
    }

    public synchronized void add(String path, ExportedObject object, String data) {
        this.logger.debug("Adding {} to object tree", (Object)path);
        this.root = this.recursiveAdd(this.root, path, object, data);
    }

    public synchronized void remove(String path) {
        this.logger.debug("Removing {} from object tree", (Object)path);
        TreeNode t = this.recursiveFind(this.root, path);
        t.object = null;
        t.data = null;
    }

    public String Introspect(String _path) {
        TreeNode t = this.recursiveFind(this.root, _path);
        if (null == t) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<node name=\"");
        sb.append(_path);
        sb.append("\">\n");
        if (null != t.data) {
            sb.append(t.data);
        }
        t = t.down;
        while (null != t) {
            sb.append("<node name=\"");
            sb.append(t.name);
            sb.append("\"/>\n");
            t = t.right;
        }
        sb.append("</node>");
        return sb.toString();
    }

    private String recursivePrint(TreeNode current) {
        String s = "";
        if (null != current) {
            s = s + current.name;
            if (null != current.object) {
                s = s + "*";
            }
            if (null != current.down) {
                s = s + "/{" + this.recursivePrint(current.down) + "}";
            }
            if (null != current.right) {
                s = s + ", " + this.recursivePrint(current.right);
            }
        }
        return s;
    }

    public String toString() {
        return this.recursivePrint(this.root);
    }

    class TreeNode {
        String name;
        ExportedObject object;
        String data;
        TreeNode right;
        TreeNode down;

        TreeNode(String _name) {
            this.name = _name;
        }

        TreeNode(String _name, ExportedObject _object, String _data) {
            this.name = _name;
            this.object = _object;
            this.data = _data;
        }
    }
}

