/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueCommentWithHtml;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.action.GHPRReloadStateAction;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHSubmittableTextFieldFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHSubmittableTextFieldModel;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandlerImpl;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStateModelImpl;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatePanel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProviderImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineComponent;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergingModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTitleComponent;
import org.jetbrains.plugins.github.ui.GHHandledErrorPanelModel;
import org.jetbrains.plugins.github.ui.GHHtmlErrorPanel;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J@\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRFileEditorComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "currentDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;)V", "detailsModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "errorModel", "Lorg/jetbrains/plugins/github/ui/GHHandledErrorPanelModel;", "reviewThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProviderImpl;", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModelImpl;", "timelineModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel;", "uiDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "create", "Ljavax/swing/JComponent;", "createCommentField", "commentService", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "createItemComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "intellij.vcs.github"})
public final class GHPRFileEditorComponentFactory {
    private final Disposable uiDisposable;
    private final SingleValueModel<GHPullRequestShort> detailsModel;
    private final GHHandledErrorPanelModel errorModel;
    private final GHPRTimelineMergingModel timelineModel;
    private final GHPRReviewsThreadsModelsProviderImpl reviewThreadsModelsProvider;
    private final GHPRStateModelImpl stateModel;
    private final Project project;
    private final GHPRTimelineFileEditor editor;

    @NotNull
    public final JComponent create() {
        Wrapper mainPanel = new Wrapper();
        CachingGithubAvatarIconsProvider avatarIconsProvider = this.editor.getAvatarIconsProviderFactory().create(GithubUIUtil.INSTANCE.getAvatarSize(), (Component)mainPanel);
        JComponent header = GHPRTitleComponent.INSTANCE.create(this.detailsModel, this.editor.getDetailsData());
        GHPRTimelineComponent gHPRTimelineComponent = new GHPRTimelineComponent(this.detailsModel, this.timelineModel, this.createItemComponentFactory(this.project, this.editor.getDetailsData(), this.editor.getCommentsData(), this.editor.getReviewData(), this.reviewThreadsModelsProvider, avatarIconsProvider, this.editor.getSecurityService().getCurrentUser()));
        boolean bl = false;
        boolean bl2 = false;
        JComponent $this$apply = gHPRTimelineComponent;
        boolean $i$a$-apply-GHPRFileEditorComponentFactory$create$timeline$22 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty((int)16, (int)0));
        GHPRTimelineComponent timeline = gHPRTimelineComponent;
        JComponent errorPanel = GHHtmlErrorPanel.create$default(GHHtmlErrorPanel.INSTANCE, this.errorModel, 0, 2, null);
        GHListLoader<GHPRTimelineItem> timelineLoader = this.editor.getTimelineLoader();
        $this$apply = new JLabel((Icon)new AnimatedIcon.Default());
        $i$a$-apply-GHPRFileEditorComponentFactory$create$timeline$22 = false;
        boolean bl3 = false;
        JComponent $this$apply422 = $this$apply;
        boolean bl4 = false;
        $this$apply422.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        $this$apply422.setVisible(timelineLoader.getLoading());
        JComponent loadingIcon = $this$apply;
        timelineLoader.addLoadingStateChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>((JLabel)loadingIcon, timelineLoader){
            final /* synthetic */ JLabel $loadingIcon;
            final /* synthetic */ GHListLoader $timelineLoader;

            public final void invoke() {
                this.$loadingIcon.setVisible(this.$timelineLoader.getLoading());
            }
            {
                this.$loadingIcon = jLabel;
                this.$timelineLoader = gHListLoader;
                super(0);
            }
        }));
        ScrollablePanel $i$a$-apply-GHPRFileEditorComponentFactory$create$timeline$22 = new ScrollablePanel();
        bl3 = false;
        boolean $this$apply422 = false;
        ScrollablePanel $this$apply32 = $i$a$-apply-GHPRFileEditorComponentFactory$create$timeline$22;
        boolean bl5 = false;
        $this$apply32.setOpaque(false);
        $this$apply32.setBorder((Border)JBUI.Borders.empty((int)24, (int)20));
        int maxWidth = (int)(GithubUIUtil.INSTANCE.getFontEM((JComponent)$this$apply32) * (float)42);
        $this$apply32.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().flowY(), new AC().size("" + ':' + maxWidth + ':' + maxWidth).gap("push")));
        $this$apply32.add((Component)header, (Object)new CC().growX());
        $this$apply32.add((Component)timeline, (Object)new CC().growX().minWidth(""));
        $this$apply32.add((Component)errorPanel, (Object)new CC().hideMode(2).alignX("center"));
        $this$apply32.add((Component)loadingIcon, (Object)new CC().hideMode(2).alignX("center"));
        if (this.editor.getSecurityService().currentUserHasPermissionLevel(GHRepositoryPermissionLevel.READ)) {
            JComponent commentField2 = this.createCommentField(this.editor.getCommentsData(), avatarIconsProvider, this.editor.getSecurityService().getCurrentUser());
            $this$apply32.add((Component)commentField2, (Object)new CC().growX());
        }
        ScrollablePanel timelinePanel = $i$a$-apply-GHPRFileEditorComponentFactory$create$timeline$22;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)timelinePanel), (boolean)true);
        $this$apply422 = false;
        boolean $this$apply32 = false;
        JScrollPane $this$apply22 = jScrollPane;
        boolean bl6 = false;
        $this$apply22.setOpaque(false);
        JViewport jViewport = $this$apply22.getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
        jViewport.setOpaque(false);
        JScrollBar jScrollBar = $this$apply22.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        jScrollBar.getModel().addChangeListener(new ChangeListener($this$apply22, timelineLoader){
            private boolean firstScroll;
            final /* synthetic */ JScrollPane $this_apply;
            final /* synthetic */ GHListLoader $timelineLoader$inlined;
            {
                this.$this_apply = $receiver;
                this.$timelineLoader$inlined = gHListLoader;
                this.firstScroll = true;
            }

            public void stateChanged(@NotNull ChangeEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (this.firstScroll) {
                    JScrollBar jScrollBar = this.$this_apply.getVerticalScrollBar();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
                    if (jScrollBar.getValue() > 0) {
                        this.firstScroll = false;
                    }
                }
                if (!this.firstScroll && this.$timelineLoader$inlined.canLoadMore()) {
                    GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader$inlined, false, 1, null);
                }
            }
        });
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"ScrollPaneFactory.create\u2026\n        }\n      })\n    }");
        JScrollPane scrollPane = jScrollPane2;
        UiNotifyConnector.doWhenFirstShown((JComponent)scrollPane, (Runnable)new Runnable(timelineLoader){
            final /* synthetic */ GHListLoader $timelineLoader;

            public final void run() {
                GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader, false, 1, null);
            }
            {
                this.$timelineLoader = gHListLoader;
            }
        });
        timelineLoader.addDataListener(this.uiDisposable, new GHListLoader.ListDataListener(scrollPane, timelineLoader){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ GHListLoader $timelineLoader;

            public void onAllDataRemoved() {
                if (this.$scrollPane.isShowing()) {
                    GHListLoader.DefaultImpls.loadMore$default(this.$timelineLoader, false, 1, null);
                }
            }
            {
                this.$scrollPane = $captured_local_variable$0;
                this.$timelineLoader = $captured_local_variable$1;
            }

            public void onDataAdded(int startIdx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataAdded(this, startIdx);
            }

            public void onDataUpdated(int idx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataUpdated(this, idx);
            }

            public void onDataRemoved(@NotNull Object data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                GHListLoader.ListDataListener.DefaultImpls.onDataRemoved(this, data);
            }
        });
        GHPRStatePanel $this$apply422 = new GHPRStatePanel(this.editor.getSecurityService(), this.stateModel);
        $this$apply32 = false;
        boolean $this$apply22 = false;
        GHPRStatePanel $this$apply5 = $this$apply422;
        boolean bl7 = false;
        $this$apply5.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((int)2), JBUI.Borders.empty((int)8)));
        GHPRStatePanel statePanel = $this$apply422;
        this.detailsModel.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(this, statePanel){
            final /* synthetic */ GHPRFileEditorComponentFactory this$0;
            final /* synthetic */ GHPRStatePanel $statePanel;

            public final void invoke() {
                this.$statePanel.select((Object)((Object)((GHPullRequestShort)GHPRFileEditorComponentFactory.access$getDetailsModel$p(this.this$0).getValue()).getState()), true);
            }
            {
                this.this$0 = gHPRFileEditorComponentFactory;
                this.$statePanel = gHPRStatePanel;
                super(0);
            }
        }));
        BorderLayoutPanel contentPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)scrollPane).addToBottom((Component)JBUI.Panels.simplePanel((Component)((Component)((Object)statePanel)))).andTransparent();
        mainPanel.setContent((JComponent)contentPanel);
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("Github.PullRequest.Timeline.Update").registerCustomShortcutSet((JComponent)scrollPane, this.uiDisposable);
        AnAction anAction = actionManager.getAction("Github.PullRequest.Timeline.Popup");
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup actionGroup = (ActionGroup)anAction;
        PopupHandler.installPopupHandler((JComponent)scrollPane, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)actionManager);
        PopupHandler.installPopupHandler((JComponent)((JComponent)((Object)statePanel)), (ActionGroup)((ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)new GHPRReloadStateAction()})), (String)"unknown", (ActionManager)actionManager);
        return (JComponent)mainPanel;
    }

    private final JComponent createCommentField(GHPRCommentsDataProvider commentService, GHAvatarIconsProvider avatarIconsProvider, GHUser currentUser) {
        GHSubmittableTextFieldModel model2 = new GHSubmittableTextFieldModel((Function1)new Function1<String, CompletableFuture<GithubIssueCommentWithHtml>>(commentService){
            final /* synthetic */ GHPRCommentsDataProvider $commentService;

            @NotNull
            public final CompletableFuture<GithubIssueCommentWithHtml> invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$commentService.addComment((ProgressIndicator)new EmptyProgressIndicator(), it);
            }
            {
                this.$commentService = gHPRCommentsDataProvider;
                super(1);
            }
        });
        return GHSubmittableTextFieldFactory.create$default(new GHSubmittableTextFieldFactory(model2), avatarIconsProvider, currentUser, null, null, 12, null);
    }

    private final GHPRTimelineItemComponentFactory createItemComponentFactory(Project project, GHPRDetailsDataProvider detailsDataProvider, GHPRCommentsDataProvider commentsDataProvider, GHPRReviewDataProvider reviewDataProvider, GHPRReviewsThreadsModelsProvider reviewThreadsModelsProvider, GHAvatarIconsProvider avatarIconsProvider, GHUser currentUser) {
        GHPRSelectInToolWindowHelper selectInToolWindowHelper = new GHPRSelectInToolWindowHelper(project, this.editor.getRepository(), this.detailsModel.getValue());
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        GHPRReviewThreadDiffComponentFactory diffFactory = new GHPRReviewThreadDiffComponentFactory(project, editorFactory);
        GHPRTimelineEventComponentFactoryImpl eventsFactory = new GHPRTimelineEventComponentFactoryImpl(avatarIconsProvider);
        return new GHPRTimelineItemComponentFactory(detailsDataProvider, commentsDataProvider, reviewDataProvider, avatarIconsProvider, reviewThreadsModelsProvider, diffFactory, eventsFactory, selectInToolWindowHelper, currentUser);
    }

    public GHPRFileEditorComponentFactory(@NotNull Project project, @NotNull GHPRTimelineFileEditor editor, @NotNull GHPullRequestShort currentDetails) {
        Disposable disposable;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)editor), (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)currentDetails, (String)"currentDetails");
        this.project = project;
        this.editor = editor;
        Disposable disposable2 = Disposer.newDisposable();
        GHPRFileEditorComponentFactory gHPRFileEditorComponentFactory = this;
        boolean bl = false;
        boolean bl2 = false;
        Disposable it = disposable2;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)this.editor), (Disposable)it);
        Disposable disposable3 = disposable = disposable2;
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable3, (String)"Disposer.newDisposable()\u2026.register(editor, it)\n  }");
        gHPRFileEditorComponentFactory.uiDisposable = disposable3;
        this.detailsModel = new SingleValueModel<GHPullRequestShort>(currentDetails);
        String string = GithubBundle.message("pull.request.timeline.cannot.load", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026st.timeline.cannot.load\")");
        this.errorModel = new GHHandledErrorPanelModel(string, new GHLoadingErrorHandlerImpl(this.project, this.editor.getSecurityService().getAccount(), (Function0<Unit>)((Function0)new Function0<Unit>(this.editor.getTimelineLoader()){

            public final void invoke() {
                ((GHListLoader)this.receiver).reset();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GHListLoader.class);
            }

            public final String getName() {
                return "reset";
            }

            public final String getSignature() {
                return "reset()V";
            }
        })));
        this.timelineModel = new GHPRTimelineMergingModel();
        this.reviewThreadsModelsProvider = new GHPRReviewsThreadsModelsProviderImpl(this.editor.getReviewData(), this.uiDisposable);
        this.stateModel = new GHPRStateModelImpl(this.project, this.editor.getStateData(), this.editor.getChangesData(), this.detailsModel, this.uiDisposable);
        this.editor.getDetailsData().loadDetails(this.uiDisposable, (Function1<? super CompletableFuture<GHPullRequest>, Unit>)((Function1)new Function1<CompletableFuture<GHPullRequest>, Unit>(){

            public final void invoke(@NotNull CompletableFuture<GHPullRequest> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                GithubAsyncUtilKt.handleOnEdt(it, uiDisposable, (Function2)new Function2<GHPullRequest, Throwable, Unit>(){

                    public final void invoke(@Nullable GHPullRequest pr, @Nullable Throwable $noName_1) {
                        if (pr != null) {
                            detailsModel.setValue(pr);
                        }
                    }
                });
            }
        }));
        this.editor.getTimelineLoader().addErrorChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                errorModel.setError(editor.getTimelineLoader().getError());
            }
        }));
        this.errorModel.setError(this.editor.getTimelineLoader().getError());
        this.editor.getTimelineLoader().addDataListener(this.uiDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                timelineModel.add(loadedData.subList(startIdx, loadedData.size()));
            }

            @Override
            public void onDataUpdated(int idx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                GHPRTimelineItem item = loadedData.get(idx);
                timelineModel.update(item);
            }

            @Override
            public void onDataRemoved(@NotNull Object data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (!(data instanceof GHPRTimelineItem)) {
                    return;
                }
                timelineModel.remove((GHPRTimelineItem)data);
            }

            @Override
            public void onAllDataRemoved() {
                timelineModel.removeAll();
            }
        });
        this.timelineModel.add(this.editor.getTimelineLoader().getLoadedData());
    }
}

