/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.io.BaseOutputReader;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private final CapturingProcessRunner myProcessRunner;

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            CapturingProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myProcessRunner = new CapturingProcessRunner((BaseProcessHandler<?>)this, (Function<? super ProcessOutput, ? extends ProcessAdapter>)((Function<ProcessOutput, ProcessAdapter>)processOutput -> this.createProcessAdapter((ProcessOutput)processOutput)));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public CapturingProcessHandler(@NotNull Process process2) {
        if (process2 == null) {
            CapturingProcessHandler.$$$reportNull$$$0(1);
        }
        this(process2, null, "");
        DeprecatedMethodException.report((String)"Use CapturingProcessHandler(Process, Charset, String) instead");
    }

    public CapturingProcessHandler(@NotNull Process process2, @Nullable Charset charset, String commandLine) {
        if (process2 == null) {
            CapturingProcessHandler.$$$reportNull$$$0(2);
        }
        super(process2, commandLine, charset);
        this.myProcessRunner = new CapturingProcessRunner((BaseProcessHandler<?>)this, (Function<? super ProcessOutput, ? extends ProcessAdapter>)((Function<ProcessOutput, ProcessAdapter>)processOutput -> this.createProcessAdapter((ProcessOutput)processOutput)));
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @NotNull
    public ProcessOutput runProcess() {
        ProcessOutput processOutput = this.myProcessRunner.runProcess();
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        return this.myProcessRunner.runProcess(timeoutInMilliseconds, destroyOnTimeout);
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(4);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(6);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(8);
        }
        ProcessOutput processOutput = this.myProcessRunner.runProcess(indicator, timeoutInMilliseconds, destroyOnTimeout);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(9);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressIndicator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Silent
    extends CapturingProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        public Silent(@NotNull Process process2, @Nullable Charset charset, @NotNull String commandLine) {
            if (process2 == null) {
                Silent.$$$reportNull$$$0(1);
            }
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(2);
            }
            super(process2, charset, commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
            if (options == null) {
                Silent.$$$reportNull$$$0(3);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/CapturingProcessHandler$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/CapturingProcessHandler$Silent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

