/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ScrollableSingleRowLayout
extends SingleRowLayout {
    public static final int DEADZONE_FOR_DECLARE_TAB_HIDDEN = 10;
    private int myScrollOffset = 0;
    private boolean myScrollSelectionInViewPending = false;

    public ScrollableSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    int getScrollOffset() {
        return this.myScrollOffset;
    }

    @Override
    public void scroll(int units) {
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.myLastSingRowLayout);
    }

    @Override
    protected boolean checkLayoutLabels(SingleRowPassInfo data) {
        if (this.myScrollSelectionInViewPending) {
            return true;
        }
        return super.checkLayoutLabels(data);
    }

    private void clampScrollOffsetToBounds(@Nullable SingleRowPassInfo data) {
        if (data == null) {
            return;
        }
        this.myScrollOffset = data.requiredLength < data.toFitLength ? 0 : Math.max(0, Math.min(this.myScrollOffset, data.requiredLength - data.toFitLength + this.getStrategy().getMoreRectAxisSize()));
    }

    @Override
    public void scrollSelectionInView() {
        this.myScrollSelectionInViewPending = true;
    }

    @Override
    public int getScrollUnitIncrement() {
        List visibleInfos;
        if (this.myLastSingRowLayout != null && (visibleInfos = this.myLastSingRowLayout.myVisibleInfos).size() > 0) {
            TabInfo info = (TabInfo)visibleInfos.get(0);
            return this.getStrategy().getScrollUnitIncrement(this.myTabs.myInfo2Label.get(info));
        }
        return 0;
    }

    private void doScrollSelectionInView(SingleRowPassInfo passInfo) {
        if (this.myTabs.isMouseInsideTabsArea()) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : passInfo.myVisibleInfos) {
            int length = this.getRequiredLength(info);
            if (info == this.myTabs.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = passInfo.toFitLength - this.getStrategy().getMoreRectAxisSize();
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
        this.clampScrollOffsetToBounds(data);
        if (this.myScrollSelectionInViewPending || this.myLastSingRowLayout == null || !data.layoutSize.equals(this.myLastSingRowLayout.layoutSize)) {
            this.myScrollSelectionInViewPending = false;
            this.doScrollSelectionInView(data);
            this.clampScrollOffsetToBounds(data);
        }
    }

    @Override
    protected void layoutMoreButton(SingleRowPassInfo data) {
        if (data.requiredLength > data.toFitLength) {
            data.moreRect = this.getStrategy().getMoreRect(data);
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length) {
        int moreRectSize;
        if (data.requiredLength > data.toFitLength && data.position + (length = this.getStrategy().getLengthIncrement(label.getPreferredSize())) > data.toFitLength - (moreRectSize = this.getStrategy().getMoreRectAxisSize())) {
            int clippedLength = this.getStrategy().drawPartialOverflowTabs() ? data.toFitLength - data.position - moreRectSize : 0;
            super.applyTabLayout(data, label, clippedLength);
            label.setAlignmentToCenter(false);
            return false;
        }
        return super.applyTabLayout(data, label, length);
    }

    @Override
    public boolean isTabHidden(TabInfo tabInfo) {
        TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
        Rectangle bounds = label.getBounds();
        return this.getStrategy().getMinPosition(bounds) < -10 || bounds.width < label.getPreferredSize().width - 10 || bounds.height < label.getPreferredSize().height - 10;
    }

    @Override
    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data) {
        for (int i = data.toLayout.size() - 1; i >= 0; --i) {
            TabInfo info = data.toLayout.get(i);
            TabLabel label = this.myTabs.myInfo2Label.get(info);
            if (label.getBounds().isEmpty()) continue;
            return label;
        }
        return null;
    }
}

