/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PausesStat;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionUtil {
    private static final Logger LOG = Logger.getInstance(ActionUtil.class);
    @NonNls
    private static final String WAS_ENABLED_BEFORE_DUMB = "WAS_ENABLED_BEFORE_DUMB";
    @NonNls
    public static final String WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = "WOULD_BE_ENABLED_IF_NOT_DUMB_MODE";
    @NonNls
    private static final String WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = "WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE";
    @NonNls
    private static final Key<ActionUpdateData> ACTION_UPDATE_DATA = Key.create((String)"ACTION_UPDATE_DATA");
    private static int insidePerformDumbAwareUpdate;

    private ActionUtil() {
    }

    public static void showDumbModeWarning(AnActionEvent ... events) {
        if (events == null) {
            ActionUtil.$$$reportNull$$$0(0);
        }
        Project project = null;
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            Project _project;
            String s = event.getPresentation().getText();
            if (StringUtil.isNotEmpty((String)s)) {
                actionNames.add(s);
            }
            if ((_project = event.getProject()) == null || project != null) continue;
            project = _project;
        }
        if (project == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Showing dumb mode warning for " + Arrays.asList(events), new Throwable());
        }
        DumbService.getInstance(project).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        if (actionNames == null) {
            ActionUtil.$$$reportNull$$$0(1);
        }
        String message = actionNames.isEmpty() ? ActionUtil.getUnavailableMessage("This action", false) : (actionNames.size() == 1 ? ActionUtil.getUnavailableMessage("'" + actionNames.get(0) + "'", false) : ActionUtil.getUnavailableMessage("None of the following actions", true) + ": " + StringUtil.join(actionNames, (String)", "));
        String string = message;
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getUnavailableMessage(@NotNull String action, boolean plural) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(3);
        }
        String string = action + (plural ? " are" : " is") + " not available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void performFastUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent event, boolean forceUseCached) {
        long finishUpdateNs;
        Presentation templatePresentation;
        ActionUpdateData ud;
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(5);
        }
        if (event == null) {
            ActionUtil.$$$reportNull$$$0(6);
        }
        if ((ud = (templatePresentation = action.getTemplatePresentation()).getClientProperty(ACTION_UPDATE_DATA)) == null) {
            ud = new ActionUpdateData();
            templatePresentation.putClientProperty(ACTION_UPDATE_DATA, ud);
        }
        boolean isSlow = ud.averageUpdateDurationMs > 10L;
        long startTimeNs = System.nanoTime();
        long relaxMs = Math.min(ud.averageUpdateDurationMs * 100L, 10000L);
        if (isSlow && ud.lastUpdateEvent != null && (forceUseCached || (startTimeNs - ud.lastUpdateTimeNs) / 1000000L < relaxMs)) {
            event.getPresentation().copyFrom(ud.lastUpdateEvent.getPresentation());
            return;
        }
        ActionUtil.performDumbAwareUpdate(isInModalContext, action, event, false);
        ud.lastUpdateTimeNs = finishUpdateNs = System.nanoTime();
        ud.lastUpdateEvent = event;
        float smoothAlpha = isSlow ? 0.8f : 0.3f;
        float smoothCoAlpha = 1.0f - smoothAlpha;
        long spentMs = (finishUpdateNs - startTimeNs) / 1000000L;
        ud.averageUpdateDurationMs = Math.round((float)spentMs * smoothAlpha + (float)ud.averageUpdateDurationMs * smoothCoAlpha);
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(8);
        }
        Presentation presentation = e.getPresentation();
        if (LightEdit.owns(e.getProject()) && !LightEdit.isActionCompatible(action)) {
            presentation.setEnabledAndVisible(false);
            return false;
        }
        Boolean wasEnabledBefore = (Boolean)presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean allowed = !(dumbMode && !action.isDumbAware() || Registry.is((String)"actionSystem.honor.modal.context") && isInModalContext && !action.isEnabledInModalContext());
        String presentationText = presentation.getText();
        boolean edt = ApplicationManager.getApplication().isDispatchThread();
        if (edt && insidePerformDumbAwareUpdate++ == 0) {
            ActionPauses.STAT.started();
        }
        action.applyTextOverride(e);
        try {
            if (beforeActionPerformed) {
                action.beforeActionPerformedUpdate(e);
            } else {
                action.update(e);
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isEnabled() ? 1 : 0));
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isVisible() ? 1 : 0));
        }
        catch (IndexNotReadyException e1) {
            if (!allowed) {
                boolean bl = true;
                return bl;
            }
            throw e1;
        }
        finally {
            if (edt && --insidePerformDumbAwareUpdate == 0) {
                ActionPauses.STAT.finished(presentationText + " action update (" + action.getClass() + ")");
            }
            if (!allowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, (Object)enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean performDumbAwareUpdate(@NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(9);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(10);
        }
        return ActionUtil.performDumbAwareUpdate(false, action, e, beforeActionPerformed);
    }

    public static <T> T underModalProgress(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        if (project == null) {
            ActionUtil.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            ActionUtil.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            ActionUtil.$$$reportNull$$$0(13);
        }
        DumbService dumbService = DumbService.getInstance(project);
        boolean useAlternativeResolve = dumbService.isAlternativeResolveEnabled();
        ThrowableComputable inReadAction = () -> ApplicationManager.getApplication().runReadAction(computable);
        ThrowableComputable prioritizedRunnable = () -> ProgressManager.getInstance().computePrioritized(inReadAction);
        ThrowableComputable process = useAlternativeResolve ? () -> dumbService.computeWithAlternativeResolveEnabled(prioritizedRunnable) : prioritizedRunnable;
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(process, progressTitle, true, project);
    }

    public static boolean isDumbMode(@Nullable Project project) {
        if (project != null) {
            return DumbService.getInstance(project).isDumb();
        }
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(openProject).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(AnAction action, AnActionEvent e, boolean visibilityMatters) {
        ActionUtil.performDumbAwareUpdate(false, action, e, true);
        Project project = e.getProject();
        if (project != null && DumbService.getInstance(project).isDumb() && !action.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    public static void performActionDumbAwareWithCallbacks(@NotNull AnAction action, @NotNull AnActionEvent e, @NotNull DataContext context) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            ActionUtil.$$$reportNull$$$0(16);
        }
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        manager.fireBeforeActionPerformed(action, context, e);
        ActionUtil.performActionDumbAware(action, e);
        manager.fireAfterActionPerformed(action, context, e);
    }

    public static void performActionDumbAware(AnAction action, AnActionEvent e) {
        try {
            action.actionPerformed(e);
        }
        catch (IndexNotReadyException ex) {
            LOG.info((Throwable)ex);
            ActionUtil.showDumbModeWarning(e);
        }
    }

    @NotNull
    public static AnActionEvent createEmptyEvent() {
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext("unknown", null, dataId -> null);
        if (anActionEvent == null) {
            ActionUtil.$$$reportNull$$$0(17);
        }
        return anActionEvent;
    }

    public static void sortAlphabetically(@NotNull List<? extends AnAction> list) {
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(18);
        }
        list.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplateText()), (Comparable)((Object)o2.getTemplateText())));
    }

    public static void moveActionTo(@NotNull List<AnAction> list, @NotNull String actionText, @NotNull String targetActionText, boolean before) {
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(19);
        }
        if (actionText == null) {
            ActionUtil.$$$reportNull$$$0(20);
        }
        if (targetActionText == null) {
            ActionUtil.$$$reportNull$$$0(21);
        }
        if (Objects.equals(actionText, targetActionText)) {
            return;
        }
        int actionIndex = -1;
        int targetIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            AnAction action = list.get(i);
            if (actionIndex == -1 && Objects.equals(actionText, action.getTemplateText())) {
                actionIndex = i;
            }
            if (targetIndex == -1 && Objects.equals(targetActionText, action.getTemplateText())) {
                targetIndex = i;
            }
            if (actionIndex == -1 || targetIndex == -1) continue;
            if (actionIndex < targetIndex) {
                --targetIndex;
            }
            AnAction anAction = list.remove(actionIndex);
            assert (targetIndex >= 0);
            list.add(before ? targetIndex : targetIndex + 1, anAction);
            return;
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(22);
        }
        List list = ContainerUtil.notNullize((List)((List)ComponentUtil.getClientProperty((JComponent)component, AnAction.ACTIONS_KEY)));
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    public static void clearActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(24);
        }
        ComponentUtil.putClientProperty((JComponent)component, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        if (to == null) {
            ActionUtil.$$$reportNull$$$0(25);
        }
        if (from == null) {
            ActionUtil.$$$reportNull$$$0(26);
        }
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component, @NotNull ActionListener action, @NotNull ShortcutSet shortcuts) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(27);
        }
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(28);
        }
        if (shortcuts == null) {
            ActionUtil.$$$reportNull$$$0(29);
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component.registerKeyboardAction(action, first, 2);
        }
    }

    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(30);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(31);
        }
        for (AnAction action : group.getChildren(null)) {
            if (action instanceof ActionGroup) {
                ActionUtil.recursiveRegisterShortcutSet((ActionGroup)action, component, parentDisposable);
            }
            action.registerCustomShortcutSet(component, parentDisposable);
        }
    }

    public static boolean recursiveContainsAction(@NotNull ActionGroup group, @NotNull AnAction action) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(32);
        }
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(33);
        }
        return ActionUtil.anyActionFromGroupMatches(group, true, Predicate.isEqual(action));
    }

    public static boolean anyActionFromGroupMatches(@NotNull ActionGroup group, boolean processPopupSubGroups, @NotNull Predicate<? super AnAction> condition) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(34);
        }
        if (condition == null) {
            ActionUtil.$$$reportNull$$$0(35);
        }
        for (AnAction child : group.getChildren(null)) {
            if (condition.test(child)) {
                return true;
            }
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (!processPopupSubGroups && childGroup.isPopup() || !ActionUtil.anyActionFromGroupMatches(childGroup, processPopupSubGroups, condition)) continue;
            return true;
        }
        return false;
    }

    public static AnAction copyFrom(@NotNull AnAction action, @NotNull @NonNls String actionId) {
        AnAction from;
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(36);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(37);
        }
        if ((from = ActionManager.getInstance().getAction(actionId)) != null) {
            action.copyFrom(from);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action, actionId);
        return action;
    }

    public static AnAction mergeFrom(@NotNull AnAction action, @NotNull String actionId) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(38);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(39);
        }
        AnAction a1 = action;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getIcon(), (Object)p2.getIcon()));
        p1.setDisabledIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getDisabledIcon(), (Object)p2.getDisabledIcon()));
        p1.setSelectedIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getSelectedIcon(), (Object)p2.getSelectedIcon()));
        p1.setHoveredIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()));
        if (StringUtil.isEmpty((String)p1.getText())) {
            p1.setTextWithMnemonic(p2.getTextWithPossibleMnemonic());
        }
        p1.setDescription((String)ObjectUtils.chooseNotNull((Object)p1.getDescription(), (Object)p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action, actionId);
        return a1;
    }

    public static void invokeAction(@NotNull AnAction action, @NotNull Component component, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(40);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(41);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(42);
        }
        ActionUtil.invokeAction(action, DataManager.getInstance().getDataContext(component), place, inputEvent, onDone);
    }

    public static void invokeAction(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(43);
        }
        if (dataContext == null) {
            ActionUtil.$$$reportNull$$$0(44);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(45);
        }
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, place, presentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate(false, action, event, true);
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            manager.fireBeforeActionPerformed(action, dataContext, event);
            ActionUtil.performActionDumbAware(action, event);
            if (onDone != null) {
                onDone.run();
            }
            manager.fireAfterActionPerformed(action, dataContext, event);
        }
    }

    @NotNull
    public static ActionListener createActionListener(@NotNull String actionId, @NotNull Component component, @NotNull String place) {
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(46);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(47);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(48);
        }
        ActionListener actionListener = e -> {
            AnAction action = ActionManager.getInstance().getAction(actionId);
            if (action == null) {
                LOG.warn("Can not find action by id " + actionId);
                return;
            }
            ActionUtil.invokeAction(action, component, place, null, null);
        };
        if (actionListener == null) {
            ActionUtil.$$$reportNull$$$0(49);
        }
        return actionListener;
    }

    @Nullable
    public static ShortcutSet getMnemonicAsShortcut(@NotNull AnAction action) {
        if (action == null) {
            ActionUtil.$$$reportNull$$$0(50);
        }
        return KeymapUtil.getMnemonicAsShortcut(action.getTemplatePresentation().getMnemonic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 28: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetActionText";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 37: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEvent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeWarning";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnavailableMessage";
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performFastUpdate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performDumbAwareUpdate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "underModalProgress";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performActionDumbAwareWithCallbacks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sortAlphabetically";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moveActionTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearActions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyRegisteredShortcuts";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerForEveryKeyboardShortcut";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "recursiveRegisterShortcutSet";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "recursiveContainsAction";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "anyActionFromGroupMatches";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createActionListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicAsShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 17: 
            case 23: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionUpdateData {
        AnActionEvent lastUpdateEvent;
        long lastUpdateTimeNs = 0L;
        long averageUpdateDurationMs = 0L;

        private ActionUpdateData() {
        }
    }

    public static final class ActionPauses {
        public static final PausesStat STAT = new PausesStat("AnAction.update()");
    }
}

